# -*- encoding: utf-8 -*-
from paver.easy import *
import paver.misctasks
import paver.setuputils

paver.setuputils.install_distutils_tasks()

options(
    deploy=Bunch(
        host='flyingelephantsoftware.de',
        directory='/home/keppla/wsgiapps/skarabaeus-beta',
        username='keppla',
    ),
    server=Bunch(
    
        werkzeug=Bunch(
            hostname='',
            port=5000,
            use_reloader=True,
            threaded=True,
        ),
        
        application=Bunch(
            session_secret='the cake is a lie!',
            userdb=Bunch(
                plugin='skarabaeus_server.plugins.dictuserdb.DictUserDb',
                default_max_file_size=1024 ** 2 * 5, # 5 megabytes
                default_max_total_size=1024 ** 3,    # 1 gigabyte
                users=Bunch(
                    anonymous={
                        'password' : None,
                    },
                    keppla={
                        'password' : 'passwd',
                    },
                    minime={
                        'password' : 'passwd',
                        'max_total_size' : 1024 * 2,
                    }
                ),
            ),
            filedb=Bunch(
                plugin='skarabaeus_server.plugins.fsfiledb.FsFileDb',
                storage_path='/tmp',
            ),
        ),
    ),
)

@task
def generate_manifest():
    pass

@task
def remove_pyc():
    """remove all the pyc files.
    """
    sh("find . -name '*.pyc' | xargs rm")
    
@task
def remove_uploads():
    """ remove all the uploaded files.
    """
    sh("rm /tmp/*.info /tmp/*.data")


@task
@needs(['remove_pyc'])
def deploy():
    """push the stuff up to the server.
    """
    sh("rsync -avz -e ssh skarabaeus_server %s@%s:%s/" % (options.username,
                                               options.host, options.directory))
    
@task
def test():
    """run the tests.
    """
    #import py.test
    #py.test.cmdline.main()
    sh('py.test')
    
    
@task
def virtualenv():
    sh('rm -rf /tmp/virtualenv')
    sh('rm -rf /tmp/skarabaeus-instance')
    
    sh('virtualenv /tmp/virtualenv --no-site-packages')
    sh('/tmp/virtualenv/bin/python setup.py install')
    sh('/tmp/virtualenv/bin/create_instance.py /tmp/skarabaeus-instance')
    
    sh('/tmp/skarabaeus-instance/starter.py')
    
    
@task
def server():
    """run a standalone server.
    """
    import sys
    sys.path += '.'
    
    from werkzeug.serving import run_simple
    from skarabaeus_server.application import Application
    from skarabaeus_server.view import template_exception_middleware    
                    
    application = Application(options.application)
    application = template_exception_middleware(application)
    
    import logging
    logging.basicConfig(level=logging.DEBUG)    
    
    run_simple(application=application, use_debugger=True, use_evalex=True, 
                                                             **options.werkzeug)


@task
def create_starter():
    import create_instance
    create_instance.main()

