
from setuptools import setup

setup(
    name='skarabaeus-server',        
    url='http://www.flyingelephantsoftware.de/project-skarabaeus-server.html',
    author='Philipp Benjamin Koeppchen',        
    author_email='koeppchen@flyingelephantsoftware.de',
    license='GNU General Public License version 3.0 (GPLv3)',
    version='0.6',        
    scripts=['create_instance.py'],
    packages=[
        'skarabaeus_server',
        'skarabaeus_server.plugins',
    ],
    package_data={ 
        'skarabaeus_server' : ['resources/*', 'templates/*'],
    },
    platforms='any',
    install_requires=[
        'Werkzeug >= 0.3',
        'mako >= 0.2',
        'simplejson >= 1.9',
    ],
    
    classifiers=[
        'Development Status :: 4 - Beta',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Topic :: Internet :: WWW/HTTP :: WSGI :: Application',
    ],

    description='Skarabaeus is a small wsgi application for sharing files',
    long_description=(
        'Skarabaeus is a small wsgi application for sharing files\n'
        'by making them avialabe under a URL. It was written to surpass\n'
        'problems with sending files between incompatible instant messengers.'
    ),
)
