# -*-  encoding: utf-8
"""
 :copyright: (c) 2009 Philipp Benjamin Köppchen
 :license: GPLv3, see LICENSE for more details.
"""

import os.path

from werkzeug import SharedDataMiddleware
from werkzeug.routing import RequestRedirect, NotFound
#from beaker.middleware import SessionMiddleware

import controller as controller_module
from model import Model
from view import View
import urls

from wrapper import Request, SecureCookieMiddleware

def abs_path_to(fixpoint, *filenames):
    return os.path.join(os.path.dirname(fixpoint), *filenames)
        

class Application(object):
    urls = urls.urls

    def __init__(self, config):
        self.config = config        

        self.setup_middleware()
        self.model = self.create_model()
        self.view = self.create_view()

    def setup_middleware(self):
        self.dispatch = SecureCookieMiddleware(self.dispatch, 
                                       secret_key=self.config['session_secret'])
        
        self.dispatch = SharedDataMiddleware(self.dispatch, {
            '/resources' : abs_path_to(__file__, 'resources'),
        })
        
    def create_model(self):
        return Model(self.config)
        
    def create_view(self):
        return View(abs_path_to(__file__, 'templates'))
                        
    def __call__(self, environ, start_response):
        return self.dispatch(environ, start_response)
        
    def dispatch(self, environ, start_response):
        url_adapter = self.urls.bind_to_environ(environ)
        try:
            endpoint, url_values = url_adapter.match()            
            response_application = self.run_controller(endpoint, environ, url_adapter, url_values)                        
        except NotFound, exc:
            response_application = self.run_controller('NotFound', environ, url_adapter, {})
        except RequestRedirect, exc:
            response_application = exc
        return response_application(environ, start_response)
        
    def run_controller(self, endpoint, environ, url_adapter, url_values):
        request = Request(environ, url_values)            
        factory = getattr(controller_module, endpoint)  
        controller = factory(request, url_adapter, self.model, self.view)
        return controller.run()

