# -*-  encoding: utf-8
"""
 :copyright: (c) 2009 Philipp Benjamin Köppchen
 :license: GPLv3, see LICENSE for more details.
"""

from skarabaeus_server.model import User


class DictUserDb(object):

    user_factory = User

    def __init__(self, model, config):
        self.model = model
        self.default_max_file_size = config['default_max_file_size']
        self.default_max_total_size = config['default_max_total_size']
        self.users = config['users']
        
    def get_user_by_login(self, login):
        """ returns the user with the given login, or raises self.model.NotFound
        """
        password, max_file_size, max_total_size = self._get_userdata(login)
        return self.user_factory(self.model, login, 
                                                  max_file_size, max_total_size)
        
    def get_anonymous_user(self):
        """ returns the anonymous user
        """
        return self.get_user_by_login('anonymous')

        
    def get_user_by_credentials(self, login, password):
        """ returns the user fitting to the given credentials, or raises
        self.model.NotFound
        """
        verification, max_file_size, max_total_size = self._get_userdata(login)
        if password != verification:
            raise self.model.NotFound("wrong password.")
        else:
            return self.user_factory(self.model, login, 
                                                  max_file_size, max_total_size)      
              
    def _get_userdata(self, login):
        """ returns a password, max_file_size, max_total_size) tuple, or raises
        an self.model.NotFound, if no user is found
        """
        try:
            userdict = self.users[login]
        except KeyError:
            raise self.model.NotFound("there is no user called '%s'" % login)
        return (userdict['password'], 
                    userdict.get('max_file_size', self.default_max_file_size),
                    userdict.get('max_total_size', self.default_max_total_size))
