
Watcher = new Class({
    initialize: function(progress_url, bar_element) {
        this.progress_url = progress_url;                   
        this.bar = bar_element; // $$('#progressbar div')[0];
        this.request = new Request.JSON({
            url: this.progress_url, 
            onComplete: this.onRequest.bind(this),
        });
    },

    doRequest: function() {
        this.request.send();            
    },

    onRequest: function(json) {
        var effect = new Fx.Morph(this.bar, {
            duration: 'short', 
            transition: Fx.Transitions.Sine.easeOut,
            unit: '%',
        });
        
        effect.start({width: json.progress});
        
        if (json.error) {
            document.location.href = this.progress_url;
        }
        else if (json.progress < 100) {
            this.doRequest.delay(1000, this);
        }
    },
});
