import cgi
from StringIO import StringIO

filecontent = ( 'King Kong died for your sins! There are following some dots: '
#              + (('.' * 23 + '\n') * 2)
              + 'no more dots. LIE!'
              )

postdata = """\
-----------------------------1462697136143318971179337931
Content-Disposition: form-data; name="greeting"

All Hail Discordia!
-----------------------------1462697136143318971179337931
Content-Disposition: form-data; name="file"; filename="test1.txt"
Content-Type: text/plain

%s
-----------------------------1462697136143318971179337931
Content-Disposition: form-data; name="file2"; filename="test2.txt"
Content-Type: text/plain

And now for something completely different...
-----------------------------1462697136143318971179337931--
""" % filecontent


class TestCgiParseHeader(object):

    def testContentDisposition(self):
        name, args = cgi.parse_header('Content-Disposition: form-data; name="fieldname"; filename="test2.txt"')
        assert name == 'Content-Disposition: form-data'.lower()
        assert args == { 'name' : 'fieldname', 'filename' : 'test2.txt' }

    def testContentType(self):
        name, args = cgi.parse_header('Content-Type: text/plain')
        assert name == 'Content-Type: text/plain'.lower()
        assert args == {}

    def testEmpty(self):
        name, args = cgi.parse_header('')
        assert name == ''
        assert args == {}

import rfc822

import mimetools

class TestRfc822Message(object):

    def testReadBody(self):
        stream = StringIO('Content-Type: text/plain\n\nData')
        msg = mimetools.Message(stream, False)
        assert stream.read() == 'Data'

    def testFakeStream(self):
        it = self.line_yielder()

        class Mock(object):
            def readline(self):
                return it.next()

        msg = mimetools.Message(Mock(), False)

        assert msg['X-Com'] == 'ufo'
        assert it.next() == 'content'


    def line_yielder(self):
        yield 'Content-Type: text/plain'
        yield 'X-Com: ufo'
        yield ''
        yield 'content'
        
        

class TestPostdata(object):

    def setup_method(self, method):
        self.stream = StringIO(postdata)
        self.fs = cgi.FieldStorage(fp=self.stream, environ={
            'REQUEST_METHOD': 'POST',
            'CONTENT_TYPE':  'multipart/form-data; '
             'boundary=---------------------------1462697136143318971179337931',
            'CONTENT_LENGTH': len(postdata),
        })

    def test_first_file(self):
        assert self.fs['file'].file.read() == filecontent

    def test_second_file(self):
        assert self.fs['file2'].file.read().startswith('And now for')
        

import pickle

class MyException(Exception):
    def __eq__(self, other):
        return type(self) == type(other) and self.message == other.message

class TestPickleExceptions(object):

    def setup_method(self, method):    
        self.exc = MyException("yo, man")
        
    def test_equality(self):
        assert MyException("") == MyException("")
        
    def test_pickle(self):
        assert self.exc == pickle.loads(pickle.dumps(self.exc)) 

