import pathfix
from skarabaeus_server.lib import Form
from StringIO import StringIO

data = """\
-----------------------------1462697136143318971179337931
Content-Disposition: form-data; name="greeting"

All Hail Discordia!
-----------------------------1462697136143318971179337931
Content-Disposition: form-data; name="file"; filename="test1.txt"
Content-Type: text/plain

King Kong died for your sins!
Another Line!
there can't be enough lines...
--maybe some that start like the boundary--
just do mock them.
-----------------------------1462697136143318971179337931
Content-Disposition: form-data; name="file2"; filename="test2.txt"
Content-Type: text/plain

And now for something completely different...
-----------------------------1462697136143318971179337931--
"""

data = '\r\n'.join(data.split('\n'))



class TestForm(object):

    def setup_method(self, method):
        self.form = Form(StringIO(data), len(data), 
                      '---------------------------1462697136143318971179337931')
        self.formiter = iter(self.form)

    def test_amount(self):
        assert len(list(self.form)) == 3
        
    def test_names(self):                
        assert self.formiter.next().name == 'greeting'
        assert self.formiter.next().name == 'file'
        assert self.formiter.next().name == 'file2'

    def test_filenames(self):
        assert self.formiter.next().filename == None
        assert self.formiter.next().filename == 'test1.txt'
        assert self.formiter.next().filename == 'test2.txt'

    def test_content(self):
        field = self.formiter.next()
        assert field.content == 'All Hail Discordia!'
        self.formiter.next()
        assert field.content == 'All Hail Discordia!'
    
    def test_maxsize(self):
        self.formiter.next()    
        self.formiter.next()
        field = self.formiter.next()
        assert field.maxsize == len('And now for something completely different...')
    
    
