from StringIO import StringIO

testsize = 100

filename = '/tmp/mockrequest'
boundary = '---------------------------1462697136143318971179337931'
chunk = 'x' * 1024 ** 2

def prepare_file():        
    data = [
        '--', boundary, '\r\n',
        'Content-Disposition: form-data; name="greeting"\r\n',
        '\r\n',
    ] + [chunk] * testsize + [
        '\r\n',
        '--' + boundary + '--\r\n',
    ]
    data = ''.join(data)
    return StringIO(data), len(data)


import pathfix        
from skarabaeus_server.lib import Form, Parser

import time

def benchmark(func, *args, **kwargs):
    start = time.time()
    func(*args, **kwargs)
    end = time.time()
    return end - start
    

def run(fpin, fpout, size, boundary):
    form = Form(fpin, size, boundary)

    for field in form:
        for chunk in field:
            pass
            #fpout.write(chunk)

if __name__ == '__main__':
    fpin, size = prepare_file()
    fpout = open('/tmp/speedtest.dump', 'wb')
    
    Parser.chunksize = 5 #512 #1024    
    
    try:
        time = benchmark(run, fpin, fpout, size, boundary)
        print "total: %s, mb/sec: %s, chunksize: %s" % (time, 1.0 * testsize / time, Parser.chunksize)

    finally:
        fpout.close()
        fpin.close()
                               
