
FILE_SIZE_UNITS = ['byte', 'kilobyte', 'megabyte', 'gigabyte', 'terabyte']

def as_filesize(value):        
    for exp, name in enumerate(FILE_SIZE_UNITS):
        unit_size = 1024.0 ** exp
        if abs(value) < unit_size * 1024 or exp == len(FILE_SIZE_UNITS) - 1:
            value = round(value / unit_size, 1)
            if value == int(value):
                value = int(value)            
            return '%s %s' % (value, name)

