## -*- coding: utf-8 -*-
<%inherit file="base.html.mako"/>

<h2>Upload</h2>

<iframe id="uploadframe"
        name="uploadframe"></iframe>       
        
<form method="POST" 
      id="uploadform"
      enctype="multipart/form-data"
      target="uploadframe"
      onsubmit="start_update(); return true"
>
    <p>Please choose a file to upload.</p>
    <p>You may upload files up to a size to <em>${ as_filesize(current_user.max_file_size) }</em>.                          
        If you have an account, you may consider <a href="${ url_for('LoginGet') }">logging in</a>, 
        to upload bigger files.</p>

    <input type="file"
           name="file"
    />

    <button type="submit">Upload</button>
</form>



<% preview_url = url_for('Preview', force_external=True, fileslot_id=fileslot.id) %>

<p id="nonjavascript_downloadurl">The file will be avialbale for download under 
  this URL, as soon as you start uploading: 
  <a href="${ preview_url  }">${ preview_url }</a> 
</p>

<div id="downloadurl">
  <div id="progressbar"><div></div></div> 
  <p>The file is avialble for download under this url:</p>
  <p><a id="downloadlink" href="${ preview_url  }">${ preview_url }</a></p>                           
  <p>Pass the link to the receiver, download may be started immediately, even if
    your upload is not complete yet.</p>
  <p>Though you should complete it, because Skarabäus <em>cannot</em> foresee
      uploads. Yet.</p>
</div>

<div id="errormessage"></div>

<script type="text/javascript">
<!--
    function start_update() {    
        $('downloadurl').style.display = 'block';
        $('uploadform').style.display = 'none';
        
        var progress_url = '${ url_for("Preview", fileslot_id=fileslot.id) }';
        var bar_element = $$('#progressbar div')[0];

        var watcher = new Watcher(progress_url, bar_element);
        watcher.doRequest();
    }

    $('downloadurl').style.display = 'none';
    $('nonjavascript_downloadurl').style.display = 'none';
-->
</script>
