# -*-  encoding: utf-8
"""
 :copyright: (c) 2009 Philipp Benjamin Köppchen
 :license: GPLv3, see LICENSE for more details.
"""

from werkzeug.routing import Map, Rule, Submount

urls = Map([
    Rule('/', endpoint='Info'),
    
    Rule('/credits', endpoint='Credits'),
    Rule('/license', endpoint='License'),
    
    Rule('/profile', endpoint='Profile'),

    Rule('/login', methods=['GET'], endpoint='LoginGet'),
    Rule('/login', methods=['POST'], endpoint='LoginPost'),
    
    Rule('/upload', endpoint='CreateFileslot'),

    Submount('/fileslots/<string:fileslot_id>', [
        Rule('/', endpoint='Preview'),
        Rule('/download', endpoint='Download'),
        Submount('/upload', [
            Rule('/', methods=['GET'], endpoint='UploadGet'),
            Rule('/', methods=['POST'], endpoint='UploadPost'),            
        ]),
    ]),
    
    Rule('/resources/<string:filename>', endpoint='ResourceFile', build_only=True)
])
