#! /usr/bin/python
# -*- encoding: utf-8 -*-

import optparse
import sys
import os
import os.path
import random
import stat

def main():    
    target_dir = parse_args()
    source_dir = os.path.join(os.path.dirname(__file__), 'templates')
        
    files = [
        ('standalone.py', 0770),
        ('skarabaeus.wsgi', 0770),
        ('config.py', 0660),    
    ]
    
    template_vars = {
        'session_secret' : random.randint(0, 10 ** 30),
        'standalone_port' : 23235,
        'storage_path' : '/tmp',
        'python_executable' : sys.executable,
    }
    
    if not os.path.isdir(target_dir):
        os.makedirs(target_dir)      
    
    mask = os.umask(0777)
    for filename, mode in files:
        render_template(filename, source_dir, target_dir, mode, template_vars)
        
    os.umask(mask)


def parse_args():
    parser = optparse.OptionParser(usage="%prog TARGET")
    #parser.add_option()
    
    options, args = parser.parse_args()
    if len(args) != 1:
        parser.error('please give a target')
        
    target, = args
    return target


def render_template(filename, sourcedir, targetdir, mode, args):
    fp_source = open(os.path.join(sourcedir, filename + '.tpl'), 'r')
    try:
        data = fp_source.read()
    finally:
        fp_source.close()
        
    targetfilename = os.path.join(targetdir, filename)
    fp_target = open(targetfilename, 'w')

    try:
        fp_target.write(data % args)
    finally:
        fp_target.close()        
    os.chmod(targetfilename, mode)

