# -*- encoding: utf-8

mb = 1024 ** 2
    
main = {
    # where to store the session data of the users.
    'session_secret' : '%(session_secret)s',
    
    'filedb' : {
        # use the filesystem for storage
        'plugin' : 'skarabaeus_server.plugins.fsfiledb.FsFileDb',
        
        # save uploaded files here
        'storage_path' : '%(storage_path)s',    
    },
    
    'userdb' : {
        # use this file for listing users
        'plugin' : 'skarabaeus_server.plugins.dictuserdb.DictUserDb',
        
        # any user may upload files up to 5 megabytes. this may be overridden
        # in the user's settings.
        'default_max_file_size' : 10 * mb,
        
        # before an upload, skarabäus clears files, so that the total size of
        # the uploading user's files is below 1 gigabyte.
        'default_max_total_size' : 1024 * mb,
        
        # list your users here
        'users' : {
                    
            # 'joe_malik' : {
            #     'password' : "there's no enemy",
            #     'max_total_size' : 23 * mb,                
            #     'max_file_size' : 5 * mb,
            # },
            
            
            # 'harry_coin' : {
            #     'password' : "there's no friend",
            # },        
            
            # this is the user anyone not logged in is treated as.
            # DO NOT DELETE!
            # if you dont want anonymous file upload, set 'max_file_size' to 0
            'anonymous' : {
                'password' : '',
                'max_total_size' : 23 * mb,                
                'max_file_size' : 5 * mb,                
            },
            
        },
        
    },
} # no trailing comma!
