import pathfix

from skarabaeus_server import helper

def test_as_filesize():
    assert helper.as_filesize(0) == '0 byte'
    
    assert helper.as_filesize(10) == '10 byte'
    assert helper.as_filesize(1024 - 1) == '1023 byte'
    
    assert helper.as_filesize(1024) == '1 kilobyte'    
    assert helper.as_filesize(1024 ** 2 - 1024 / 2) == '1023.5 kilobyte'
    
    assert helper.as_filesize(1024 ** 2) == '1 megabyte'
    assert helper.as_filesize(1024 ** 3 - 1024 ** 2 / 2) == '1023.5 megabyte'
    
    assert helper.as_filesize(1024 ** 3) == '1 gigabyte'    
    assert helper.as_filesize(1024 ** 4) == '1 terabyte'
    assert helper.as_filesize(1024 ** 5) == '1024 terabyte'
