# -*- coding: utf-8 -*-

import functools
import time
import thread
import kola
from kola import safe_call, safe_func


class Blueprint(kola.Blueprint):
    """
    主要改掉
    """

    def __init__(self, name):
        super(Blueprint, self).__init__(name)

    def repeat_app_timer(self, interval):
        """
        每隔一段时间执行(秒)
        """
        def inner_repeat_timer(func):
            @functools.wraps(func)
            def func_wrapper(*args, **kwargs):
                # 每次也要再加入

                time.sleep(interval)
                result = safe_call(func, *args, **kwargs)

                thread.start_new_thread(func_wrapper, ())

                return result

            self.events.repeat_app_timer += functools.partial(thread.start_new_thread, func_wrapper, ())
            return func_wrapper
        return inner_repeat_timer
