# -*- coding: utf-8 -*-

from netkit.stream import Stream as NetKitStream
from kola import safe_call


class Stream(NetKitStream):

    def __init__(self, *args, **kwargs):
        super(Stream, self).__init__(*args, **kwargs)
        self._close_callback = None

    def set_close_callback(self, callback):
        self._close_callback = callback

    def read_until_regex(self, regex, callback=None):
        data = super(Stream, self).read_until_regex(regex)
        if data:
            safe_call(callback, data)

        if self.closed():
            if self._close_callback:
                safe_call(self._close_callback)
                self._close_callback = None

    def read_until(self, delimiter, callback=None):
        data = super(Stream, self).read_until(delimiter)
        if data:
            safe_call(callback, data)

        if self.closed():
            if self._close_callback:
                safe_call(self._close_callback)
                self._close_callback = None

    def read_bytes(self, num_bytes, callback=None):
        data = super(Stream, self).read_bytes(num_bytes)
        if data:
            safe_call(callback, data)

        if self.closed():
            if self._close_callback:
                safe_call(self._close_callback)
                self._close_callback = None

    def read_until_close(self, callback=None):
        data = super(Stream, self).read_until_close(callback)
        if data:
            safe_call(callback, data)

        if self.closed():
            if self._close_callback:
                safe_call(self._close_callback)
                self._close_callback = None

    def write(self, data, callback=None):
        super(Stream, self).write(data)

        if callback:
            safe_call(callback)
