# -*- coding: utf-8 -*-

import thread
import time
from kola import safe_call


class Later(object):

    timeout = None

    def set(self, interval, callback, repeat=False, force=True):
        """
        添加timeout
        """
        if self.timeout:
            if force:
                # 如果已经存在，那么先要把现在的清空
                self.clear()
            else:
                # 已经存在的话，就返回了
                return

        def callback_wrapper():
            # 放在这里，不能放在 == 判断里
            time.sleep(interval)

            # 这样可以让timeout及时变成None
            if self.timeout == timeout:
                # 必须要确定，这次调用就是这个timeout引起的
                self.timeout = None
                result = safe_call(callback)
                if repeat:
                    # 重复的调用
                    self.set(interval, callback, repeat=repeat)
                return result

        self.timeout = timeout = thread.start_new_thread(callback_wrapper, ())

    def clear(self):
        """
        直接把现在的清空
        """
        if not self.timeout:
            return

        # 不阻塞
        self.timeout.kill(block=False)
        self.timeout = None
