# -*- coding: utf-8 -*-
import unittest

from skoolkittest import SkoolKitTestCase
from skoolkit.disassembler import Disassembler

ASM = {
    '000000': ('NOP', 'NOP', 'NOP'),
    '010000': ('LD BC,0',),
    '020000': ('LD (BC),A', 'NOP', 'NOP'),
    '030000': ('INC BC', 'NOP', 'NOP'),
    '040000': ('INC B', 'NOP', 'NOP'),
    '050000': ('DEC B', 'NOP', 'NOP'),
    '060000': ('LD B,0', 'NOP'),
    '070000': ('RLCA', 'NOP', 'NOP'),
    '080000': ("EX AF,AF'", 'NOP', 'NOP'),
    '090000': ('ADD HL,BC', 'NOP', 'NOP'),
    '0A0000': ('LD A,(BC)', 'NOP', 'NOP'),
    '0B0000': ('DEC BC', 'NOP', 'NOP'),
    '0C0000': ('INC C', 'NOP', 'NOP'),
    '0D0000': ('DEC C', 'NOP', 'NOP'),
    '0E0000': ('LD C,0', 'NOP'),
    '0F0000': ('RRCA', 'NOP', 'NOP'),
    '100000': ('DJNZ 16386', 'NOP'),
    '110000': ('LD DE,0',),
    '120000': ('LD (DE),A', 'NOP', 'NOP'),
    '130000': ('INC DE', 'NOP', 'NOP'),
    '140000': ('INC D', 'NOP', 'NOP'),
    '150000': ('DEC D', 'NOP', 'NOP'),
    '160000': ('LD D,0', 'NOP'),
    '170000': ('RLA', 'NOP', 'NOP'),
    '180000': ('JR 16386', 'NOP'),
    '190000': ('ADD HL,DE', 'NOP', 'NOP'),
    '1A0000': ('LD A,(DE)', 'NOP', 'NOP'),
    '1B0000': ('DEC DE', 'NOP', 'NOP'),
    '1C0000': ('INC E', 'NOP', 'NOP'),
    '1D0000': ('DEC E', 'NOP', 'NOP'),
    '1E0000': ('LD E,0', 'NOP'),
    '1F0000': ('RRA', 'NOP', 'NOP'),
    '200000': ('JR NZ,16386', 'NOP'),
    '210000': ('LD HL,0',),
    '220000': ('LD (0),HL',),
    '230000': ('INC HL', 'NOP', 'NOP'),
    '240000': ('INC H', 'NOP', 'NOP'),
    '250000': ('DEC H', 'NOP', 'NOP'),
    '260000': ('LD H,0', 'NOP'),
    '270000': ('DAA', 'NOP', 'NOP'),
    '280000': ('JR Z,16386', 'NOP'),
    '290000': ('ADD HL,HL', 'NOP', 'NOP'),
    '2A0000': ('LD HL,(0)',),
    '2B0000': ('DEC HL', 'NOP', 'NOP'),
    '2C0000': ('INC L', 'NOP', 'NOP'),
    '2D0000': ('DEC L', 'NOP', 'NOP'),
    '2E0000': ('LD L,0', 'NOP'),
    '2F0000': ('CPL', 'NOP', 'NOP'),
    '300000': ('JR NC,16386', 'NOP'),
    '310000': ('LD SP,0',),
    '320000': ('LD (0),A',),
    '330000': ('INC SP', 'NOP', 'NOP'),
    '340000': ('INC (HL)', 'NOP', 'NOP'),
    '350000': ('DEC (HL)', 'NOP', 'NOP'),
    '360000': ('LD (HL),0', 'NOP'),
    '370000': ('SCF', 'NOP', 'NOP'),
    '380000': ('JR C,16386', 'NOP'),
    '390000': ('ADD HL,SP', 'NOP', 'NOP'),
    '3A0000': ('LD A,(0)',),
    '3B0000': ('DEC SP', 'NOP', 'NOP'),
    '3C0000': ('INC A', 'NOP', 'NOP'),
    '3D0000': ('DEC A', 'NOP', 'NOP'),
    '3E0000': ('LD A,0', 'NOP'),
    '3F0000': ('CCF', 'NOP', 'NOP'),
    '400000': ('LD B,B', 'NOP', 'NOP'),
    '410000': ('LD B,C', 'NOP', 'NOP'),
    '420000': ('LD B,D', 'NOP', 'NOP'),
    '430000': ('LD B,E', 'NOP', 'NOP'),
    '440000': ('LD B,H', 'NOP', 'NOP'),
    '450000': ('LD B,L', 'NOP', 'NOP'),
    '460000': ('LD B,(HL)', 'NOP', 'NOP'),
    '470000': ('LD B,A', 'NOP', 'NOP'),
    '480000': ('LD C,B', 'NOP', 'NOP'),
    '490000': ('LD C,C', 'NOP', 'NOP'),
    '4A0000': ('LD C,D', 'NOP', 'NOP'),
    '4B0000': ('LD C,E', 'NOP', 'NOP'),
    '4C0000': ('LD C,H', 'NOP', 'NOP'),
    '4D0000': ('LD C,L', 'NOP', 'NOP'),
    '4E0000': ('LD C,(HL)', 'NOP', 'NOP'),
    '4F0000': ('LD C,A', 'NOP', 'NOP'),
    '500000': ('LD D,B', 'NOP', 'NOP'),
    '510000': ('LD D,C', 'NOP', 'NOP'),
    '520000': ('LD D,D', 'NOP', 'NOP'),
    '530000': ('LD D,E', 'NOP', 'NOP'),
    '540000': ('LD D,H', 'NOP', 'NOP'),
    '550000': ('LD D,L', 'NOP', 'NOP'),
    '560000': ('LD D,(HL)', 'NOP', 'NOP'),
    '570000': ('LD D,A', 'NOP', 'NOP'),
    '580000': ('LD E,B', 'NOP', 'NOP'),
    '590000': ('LD E,C', 'NOP', 'NOP'),
    '5A0000': ('LD E,D', 'NOP', 'NOP'),
    '5B0000': ('LD E,E', 'NOP', 'NOP'),
    '5C0000': ('LD E,H', 'NOP', 'NOP'),
    '5D0000': ('LD E,L', 'NOP', 'NOP'),
    '5E0000': ('LD E,(HL)', 'NOP', 'NOP'),
    '5F0000': ('LD E,A', 'NOP', 'NOP'),
    '600000': ('LD H,B', 'NOP', 'NOP'),
    '610000': ('LD H,C', 'NOP', 'NOP'),
    '620000': ('LD H,D', 'NOP', 'NOP'),
    '630000': ('LD H,E', 'NOP', 'NOP'),
    '640000': ('LD H,H', 'NOP', 'NOP'),
    '650000': ('LD H,L', 'NOP', 'NOP'),
    '660000': ('LD H,(HL)', 'NOP', 'NOP'),
    '670000': ('LD H,A', 'NOP', 'NOP'),
    '680000': ('LD L,B', 'NOP', 'NOP'),
    '690000': ('LD L,C', 'NOP', 'NOP'),
    '6A0000': ('LD L,D', 'NOP', 'NOP'),
    '6B0000': ('LD L,E', 'NOP', 'NOP'),
    '6C0000': ('LD L,H', 'NOP', 'NOP'),
    '6D0000': ('LD L,L', 'NOP', 'NOP'),
    '6E0000': ('LD L,(HL)', 'NOP', 'NOP'),
    '6F0000': ('LD L,A', 'NOP', 'NOP'),
    '700000': ('LD (HL),B', 'NOP', 'NOP'),
    '710000': ('LD (HL),C', 'NOP', 'NOP'),
    '720000': ('LD (HL),D', 'NOP', 'NOP'),
    '730000': ('LD (HL),E', 'NOP', 'NOP'),
    '740000': ('LD (HL),H', 'NOP', 'NOP'),
    '750000': ('LD (HL),L', 'NOP', 'NOP'),
    '760000': ('HALT', 'NOP', 'NOP'),
    '770000': ('LD (HL),A', 'NOP', 'NOP'),
    '780000': ('LD A,B', 'NOP', 'NOP'),
    '790000': ('LD A,C', 'NOP', 'NOP'),
    '7A0000': ('LD A,D', 'NOP', 'NOP'),
    '7B0000': ('LD A,E', 'NOP', 'NOP'),
    '7C0000': ('LD A,H', 'NOP', 'NOP'),
    '7D0000': ('LD A,L', 'NOP', 'NOP'),
    '7E0000': ('LD A,(HL)', 'NOP', 'NOP'),
    '7F0000': ('LD A,A', 'NOP', 'NOP'),
    '800000': ('ADD A,B', 'NOP', 'NOP'),
    '810000': ('ADD A,C', 'NOP', 'NOP'),
    '820000': ('ADD A,D', 'NOP', 'NOP'),
    '830000': ('ADD A,E', 'NOP', 'NOP'),
    '840000': ('ADD A,H', 'NOP', 'NOP'),
    '850000': ('ADD A,L', 'NOP', 'NOP'),
    '860000': ('ADD A,(HL)', 'NOP', 'NOP'),
    '870000': ('ADD A,A', 'NOP', 'NOP'),
    '880000': ('ADC A,B', 'NOP', 'NOP'),
    '890000': ('ADC A,C', 'NOP', 'NOP'),
    '8A0000': ('ADC A,D', 'NOP', 'NOP'),
    '8B0000': ('ADC A,E', 'NOP', 'NOP'),
    '8C0000': ('ADC A,H', 'NOP', 'NOP'),
    '8D0000': ('ADC A,L', 'NOP', 'NOP'),
    '8E0000': ('ADC A,(HL)', 'NOP', 'NOP'),
    '8F0000': ('ADC A,A', 'NOP', 'NOP'),
    '900000': ('SUB B', 'NOP', 'NOP'),
    '910000': ('SUB C', 'NOP', 'NOP'),
    '920000': ('SUB D', 'NOP', 'NOP'),
    '930000': ('SUB E', 'NOP', 'NOP'),
    '940000': ('SUB H', 'NOP', 'NOP'),
    '950000': ('SUB L', 'NOP', 'NOP'),
    '960000': ('SUB (HL)', 'NOP', 'NOP'),
    '970000': ('SUB A', 'NOP', 'NOP'),
    '980000': ('SBC A,B', 'NOP', 'NOP'),
    '990000': ('SBC A,C', 'NOP', 'NOP'),
    '9A0000': ('SBC A,D', 'NOP', 'NOP'),
    '9B0000': ('SBC A,E', 'NOP', 'NOP'),
    '9C0000': ('SBC A,H', 'NOP', 'NOP'),
    '9D0000': ('SBC A,L', 'NOP', 'NOP'),
    '9E0000': ('SBC A,(HL)', 'NOP', 'NOP'),
    '9F0000': ('SBC A,A', 'NOP', 'NOP'),
    'A00000': ('AND B', 'NOP', 'NOP'),
    'A10000': ('AND C', 'NOP', 'NOP'),
    'A20000': ('AND D', 'NOP', 'NOP'),
    'A30000': ('AND E', 'NOP', 'NOP'),
    'A40000': ('AND H', 'NOP', 'NOP'),
    'A50000': ('AND L', 'NOP', 'NOP'),
    'A60000': ('AND (HL)', 'NOP', 'NOP'),
    'A70000': ('AND A', 'NOP', 'NOP'),
    'A80000': ('XOR B', 'NOP', 'NOP'),
    'A90000': ('XOR C', 'NOP', 'NOP'),
    'AA0000': ('XOR D', 'NOP', 'NOP'),
    'AB0000': ('XOR E', 'NOP', 'NOP'),
    'AC0000': ('XOR H', 'NOP', 'NOP'),
    'AD0000': ('XOR L', 'NOP', 'NOP'),
    'AE0000': ('XOR (HL)', 'NOP', 'NOP'),
    'AF0000': ('XOR A', 'NOP', 'NOP'),
    'B00000': ('OR B', 'NOP', 'NOP'),
    'B10000': ('OR C', 'NOP', 'NOP'),
    'B20000': ('OR D', 'NOP', 'NOP'),
    'B30000': ('OR E', 'NOP', 'NOP'),
    'B40000': ('OR H', 'NOP', 'NOP'),
    'B50000': ('OR L', 'NOP', 'NOP'),
    'B60000': ('OR (HL)', 'NOP', 'NOP'),
    'B70000': ('OR A', 'NOP', 'NOP'),
    'B80000': ('CP B', 'NOP', 'NOP'),
    'B90000': ('CP C', 'NOP', 'NOP'),
    'BA0000': ('CP D', 'NOP', 'NOP'),
    'BB0000': ('CP E', 'NOP', 'NOP'),
    'BC0000': ('CP H', 'NOP', 'NOP'),
    'BD0000': ('CP L', 'NOP', 'NOP'),
    'BE0000': ('CP (HL)', 'NOP', 'NOP'),
    'BF0000': ('CP A', 'NOP', 'NOP'),
    'C00000': ('RET NZ', 'NOP', 'NOP'),
    'C10000': ('POP BC', 'NOP', 'NOP'),
    'C20000': ('JP NZ,0',),
    'C30000': ('JP 0',),
    'C40000': ('CALL NZ,0',),
    'C50000': ('PUSH BC', 'NOP', 'NOP'),
    'C60000': ('ADD A,0', 'NOP'),
    'C70000': ('RST 0', 'NOP', 'NOP'),
    'C80000': ('RET Z', 'NOP', 'NOP'),
    'C90000': ('RET', 'NOP', 'NOP'),
    'CA0000': ('JP Z,0',),
    'CB0000': ('RLC B', 'NOP'),
    'CC0000': ('CALL Z,0',),
    'CD0000': ('CALL 0',),
    'CE0000': ('ADC A,0', 'NOP'),
    'CF0000': ('RST 8', 'NOP', 'NOP'),
    'D00000': ('RET NC', 'NOP', 'NOP'),
    'D10000': ('POP DE', 'NOP', 'NOP'),
    'D20000': ('JP NC,0',),
    'D30000': ('OUT (0),A', 'NOP'),
    'D40000': ('CALL NC,0',),
    'D50000': ('PUSH DE', 'NOP', 'NOP'),
    'D60000': ('SUB 0', 'NOP'),
    'D70000': ('RST 16', 'NOP', 'NOP'),
    'D80000': ('RET C', 'NOP', 'NOP'),
    'D90000': ('EXX', 'NOP', 'NOP'),
    'DA0000': ('JP C,0',),
    'DB0000': ('IN A,(0)', 'NOP'),
    'DC0000': ('CALL C,0',),
    'DD0000': ('DEFB 221', 'NOP', 'NOP'),
    'DE0000': ('SBC A,0', 'NOP'),
    'DF0000': ('RST 24', 'NOP', 'NOP'),
    'E00000': ('RET PO', 'NOP', 'NOP'),
    'E10000': ('POP HL', 'NOP', 'NOP'),
    'E20000': ('JP PO,0',),
    'E30000': ('EX (SP),HL', 'NOP', 'NOP'),
    'E40000': ('CALL PO,0',),
    'E50000': ('PUSH HL', 'NOP', 'NOP'),
    'E60000': ('AND 0', 'NOP'),
    'E70000': ('RST 32', 'NOP', 'NOP'),
    'E80000': ('RET PE', 'NOP', 'NOP'),
    'E90000': ('JP (HL)', 'NOP', 'NOP'),
    'EA0000': ('JP PE,0',),
    'EB0000': ('EX DE,HL', 'NOP', 'NOP'),
    'EC0000': ('CALL PE,0',),
    'ED0000': ('DEFB 237,0', 'NOP'),
    'EE0000': ('XOR 0', 'NOP'),
    'EF0000': ('RST 40', 'NOP', 'NOP'),
    'F00000': ('RET P', 'NOP', 'NOP'),
    'F10000': ('POP AF', 'NOP', 'NOP'),
    'F20000': ('JP P,0',),
    'F30000': ('DI', 'NOP', 'NOP'),
    'F40000': ('CALL P,0',),
    'F50000': ('PUSH AF', 'NOP', 'NOP'),
    'F60000': ('OR 0', 'NOP'),
    'F70000': ('RST 48', 'NOP', 'NOP'),
    'F80000': ('RET M', 'NOP', 'NOP'),
    'F90000': ('LD SP,HL', 'NOP', 'NOP'),
    'FA0000': ('JP M,0',),
    'FB0000': ('EI', 'NOP', 'NOP'),
    'FC0000': ('CALL M,0',),
    'FD0000': ('DEFB 253', 'NOP', 'NOP'),
    'FE0000': ('CP 0', 'NOP'),
    'FF0000': ('RST 56', 'NOP', 'NOP'),
    'CB00': ('RLC B',),
    'CB01': ('RLC C',),
    'CB02': ('RLC D',),
    'CB03': ('RLC E',),
    'CB04': ('RLC H',),
    'CB05': ('RLC L',),
    'CB06': ('RLC (HL)',),
    'CB07': ('RLC A',),
    'CB08': ('RRC B',),
    'CB09': ('RRC C',),
    'CB0A': ('RRC D',),
    'CB0B': ('RRC E',),
    'CB0C': ('RRC H',),
    'CB0D': ('RRC L',),
    'CB0E': ('RRC (HL)',),
    'CB0F': ('RRC A',),
    'CB10': ('RL B',),
    'CB11': ('RL C',),
    'CB12': ('RL D',),
    'CB13': ('RL E',),
    'CB14': ('RL H',),
    'CB15': ('RL L',),
    'CB16': ('RL (HL)',),
    'CB17': ('RL A',),
    'CB18': ('RR B',),
    'CB19': ('RR C',),
    'CB1A': ('RR D',),
    'CB1B': ('RR E',),
    'CB1C': ('RR H',),
    'CB1D': ('RR L',),
    'CB1E': ('RR (HL)',),
    'CB1F': ('RR A',),
    'CB20': ('SLA B',),
    'CB21': ('SLA C',),
    'CB22': ('SLA D',),
    'CB23': ('SLA E',),
    'CB24': ('SLA H',),
    'CB25': ('SLA L',),
    'CB26': ('SLA (HL)',),
    'CB27': ('SLA A',),
    'CB28': ('SRA B',),
    'CB29': ('SRA C',),
    'CB2A': ('SRA D',),
    'CB2B': ('SRA E',),
    'CB2C': ('SRA H',),
    'CB2D': ('SRA L',),
    'CB2E': ('SRA (HL)',),
    'CB2F': ('SRA A',),
    'CB30': ('SLL B',),
    'CB31': ('SLL C',),
    'CB32': ('SLL D',),
    'CB33': ('SLL E',),
    'CB34': ('SLL H',),
    'CB35': ('SLL L',),
    'CB36': ('SLL (HL)',),
    'CB37': ('SLL A',),
    'CB38': ('SRL B',),
    'CB39': ('SRL C',),
    'CB3A': ('SRL D',),
    'CB3B': ('SRL E',),
    'CB3C': ('SRL H',),
    'CB3D': ('SRL L',),
    'CB3E': ('SRL (HL)',),
    'CB3F': ('SRL A',),
    'CB40': ('BIT 0,B',),
    'CB41': ('BIT 0,C',),
    'CB42': ('BIT 0,D',),
    'CB43': ('BIT 0,E',),
    'CB44': ('BIT 0,H',),
    'CB45': ('BIT 0,L',),
    'CB46': ('BIT 0,(HL)',),
    'CB47': ('BIT 0,A',),
    'CB48': ('BIT 1,B',),
    'CB49': ('BIT 1,C',),
    'CB4A': ('BIT 1,D',),
    'CB4B': ('BIT 1,E',),
    'CB4C': ('BIT 1,H',),
    'CB4D': ('BIT 1,L',),
    'CB4E': ('BIT 1,(HL)',),
    'CB4F': ('BIT 1,A',),
    'CB50': ('BIT 2,B',),
    'CB51': ('BIT 2,C',),
    'CB52': ('BIT 2,D',),
    'CB53': ('BIT 2,E',),
    'CB54': ('BIT 2,H',),
    'CB55': ('BIT 2,L',),
    'CB56': ('BIT 2,(HL)',),
    'CB57': ('BIT 2,A',),
    'CB58': ('BIT 3,B',),
    'CB59': ('BIT 3,C',),
    'CB5A': ('BIT 3,D',),
    'CB5B': ('BIT 3,E',),
    'CB5C': ('BIT 3,H',),
    'CB5D': ('BIT 3,L',),
    'CB5E': ('BIT 3,(HL)',),
    'CB5F': ('BIT 3,A',),
    'CB60': ('BIT 4,B',),
    'CB61': ('BIT 4,C',),
    'CB62': ('BIT 4,D',),
    'CB63': ('BIT 4,E',),
    'CB64': ('BIT 4,H',),
    'CB65': ('BIT 4,L',),
    'CB66': ('BIT 4,(HL)',),
    'CB67': ('BIT 4,A',),
    'CB68': ('BIT 5,B',),
    'CB69': ('BIT 5,C',),
    'CB6A': ('BIT 5,D',),
    'CB6B': ('BIT 5,E',),
    'CB6C': ('BIT 5,H',),
    'CB6D': ('BIT 5,L',),
    'CB6E': ('BIT 5,(HL)',),
    'CB6F': ('BIT 5,A',),
    'CB70': ('BIT 6,B',),
    'CB71': ('BIT 6,C',),
    'CB72': ('BIT 6,D',),
    'CB73': ('BIT 6,E',),
    'CB74': ('BIT 6,H',),
    'CB75': ('BIT 6,L',),
    'CB76': ('BIT 6,(HL)',),
    'CB77': ('BIT 6,A',),
    'CB78': ('BIT 7,B',),
    'CB79': ('BIT 7,C',),
    'CB7A': ('BIT 7,D',),
    'CB7B': ('BIT 7,E',),
    'CB7C': ('BIT 7,H',),
    'CB7D': ('BIT 7,L',),
    'CB7E': ('BIT 7,(HL)',),
    'CB7F': ('BIT 7,A',),
    'CB80': ('RES 0,B',),
    'CB81': ('RES 0,C',),
    'CB82': ('RES 0,D',),
    'CB83': ('RES 0,E',),
    'CB84': ('RES 0,H',),
    'CB85': ('RES 0,L',),
    'CB86': ('RES 0,(HL)',),
    'CB87': ('RES 0,A',),
    'CB88': ('RES 1,B',),
    'CB89': ('RES 1,C',),
    'CB8A': ('RES 1,D',),
    'CB8B': ('RES 1,E',),
    'CB8C': ('RES 1,H',),
    'CB8D': ('RES 1,L',),
    'CB8E': ('RES 1,(HL)',),
    'CB8F': ('RES 1,A',),
    'CB90': ('RES 2,B',),
    'CB91': ('RES 2,C',),
    'CB92': ('RES 2,D',),
    'CB93': ('RES 2,E',),
    'CB94': ('RES 2,H',),
    'CB95': ('RES 2,L',),
    'CB96': ('RES 2,(HL)',),
    'CB97': ('RES 2,A',),
    'CB98': ('RES 3,B',),
    'CB99': ('RES 3,C',),
    'CB9A': ('RES 3,D',),
    'CB9B': ('RES 3,E',),
    'CB9C': ('RES 3,H',),
    'CB9D': ('RES 3,L',),
    'CB9E': ('RES 3,(HL)',),
    'CB9F': ('RES 3,A',),
    'CBA0': ('RES 4,B',),
    'CBA1': ('RES 4,C',),
    'CBA2': ('RES 4,D',),
    'CBA3': ('RES 4,E',),
    'CBA4': ('RES 4,H',),
    'CBA5': ('RES 4,L',),
    'CBA6': ('RES 4,(HL)',),
    'CBA7': ('RES 4,A',),
    'CBA8': ('RES 5,B',),
    'CBA9': ('RES 5,C',),
    'CBAA': ('RES 5,D',),
    'CBAB': ('RES 5,E',),
    'CBAC': ('RES 5,H',),
    'CBAD': ('RES 5,L',),
    'CBAE': ('RES 5,(HL)',),
    'CBAF': ('RES 5,A',),
    'CBB0': ('RES 6,B',),
    'CBB1': ('RES 6,C',),
    'CBB2': ('RES 6,D',),
    'CBB3': ('RES 6,E',),
    'CBB4': ('RES 6,H',),
    'CBB5': ('RES 6,L',),
    'CBB6': ('RES 6,(HL)',),
    'CBB7': ('RES 6,A',),
    'CBB8': ('RES 7,B',),
    'CBB9': ('RES 7,C',),
    'CBBA': ('RES 7,D',),
    'CBBB': ('RES 7,E',),
    'CBBC': ('RES 7,H',),
    'CBBD': ('RES 7,L',),
    'CBBE': ('RES 7,(HL)',),
    'CBBF': ('RES 7,A',),
    'CBC0': ('SET 0,B',),
    'CBC1': ('SET 0,C',),
    'CBC2': ('SET 0,D',),
    'CBC3': ('SET 0,E',),
    'CBC4': ('SET 0,H',),
    'CBC5': ('SET 0,L',),
    'CBC6': ('SET 0,(HL)',),
    'CBC7': ('SET 0,A',),
    'CBC8': ('SET 1,B',),
    'CBC9': ('SET 1,C',),
    'CBCA': ('SET 1,D',),
    'CBCB': ('SET 1,E',),
    'CBCC': ('SET 1,H',),
    'CBCD': ('SET 1,L',),
    'CBCE': ('SET 1,(HL)',),
    'CBCF': ('SET 1,A',),
    'CBD0': ('SET 2,B',),
    'CBD1': ('SET 2,C',),
    'CBD2': ('SET 2,D',),
    'CBD3': ('SET 2,E',),
    'CBD4': ('SET 2,H',),
    'CBD5': ('SET 2,L',),
    'CBD6': ('SET 2,(HL)',),
    'CBD7': ('SET 2,A',),
    'CBD8': ('SET 3,B',),
    'CBD9': ('SET 3,C',),
    'CBDA': ('SET 3,D',),
    'CBDB': ('SET 3,E',),
    'CBDC': ('SET 3,H',),
    'CBDD': ('SET 3,L',),
    'CBDE': ('SET 3,(HL)',),
    'CBDF': ('SET 3,A',),
    'CBE0': ('SET 4,B',),
    'CBE1': ('SET 4,C',),
    'CBE2': ('SET 4,D',),
    'CBE3': ('SET 4,E',),
    'CBE4': ('SET 4,H',),
    'CBE5': ('SET 4,L',),
    'CBE6': ('SET 4,(HL)',),
    'CBE7': ('SET 4,A',),
    'CBE8': ('SET 5,B',),
    'CBE9': ('SET 5,C',),
    'CBEA': ('SET 5,D',),
    'CBEB': ('SET 5,E',),
    'CBEC': ('SET 5,H',),
    'CBED': ('SET 5,L',),
    'CBEE': ('SET 5,(HL)',),
    'CBEF': ('SET 5,A',),
    'CBF0': ('SET 6,B',),
    'CBF1': ('SET 6,C',),
    'CBF2': ('SET 6,D',),
    'CBF3': ('SET 6,E',),
    'CBF4': ('SET 6,H',),
    'CBF5': ('SET 6,L',),
    'CBF6': ('SET 6,(HL)',),
    'CBF7': ('SET 6,A',),
    'CBF8': ('SET 7,B',),
    'CBF9': ('SET 7,C',),
    'CBFA': ('SET 7,D',),
    'CBFB': ('SET 7,E',),
    'CBFC': ('SET 7,H',),
    'CBFD': ('SET 7,L',),
    'CBFE': ('SET 7,(HL)',),
    'CBFF': ('SET 7,A',),
    'ED000000': ('DEFB 237,0', 'NOP', 'NOP'),
    'ED010000': ('DEFB 237,1', 'NOP', 'NOP'),
    'ED020000': ('DEFB 237,2', 'NOP', 'NOP'),
    'ED030000': ('DEFB 237,3', 'NOP', 'NOP'),
    'ED040000': ('DEFB 237,4', 'NOP', 'NOP'),
    'ED050000': ('DEFB 237,5', 'NOP', 'NOP'),
    'ED060000': ('DEFB 237,6', 'NOP', 'NOP'),
    'ED070000': ('DEFB 237,7', 'NOP', 'NOP'),
    'ED080000': ('DEFB 237,8', 'NOP', 'NOP'),
    'ED090000': ('DEFB 237,9', 'NOP', 'NOP'),
    'ED0A0000': ('DEFB 237,10', 'NOP', 'NOP'),
    'ED0B0000': ('DEFB 237,11', 'NOP', 'NOP'),
    'ED0C0000': ('DEFB 237,12', 'NOP', 'NOP'),
    'ED0D0000': ('DEFB 237,13', 'NOP', 'NOP'),
    'ED0E0000': ('DEFB 237,14', 'NOP', 'NOP'),
    'ED0F0000': ('DEFB 237,15', 'NOP', 'NOP'),
    'ED100000': ('DEFB 237,16', 'NOP', 'NOP'),
    'ED110000': ('DEFB 237,17', 'NOP', 'NOP'),
    'ED120000': ('DEFB 237,18', 'NOP', 'NOP'),
    'ED130000': ('DEFB 237,19', 'NOP', 'NOP'),
    'ED140000': ('DEFB 237,20', 'NOP', 'NOP'),
    'ED150000': ('DEFB 237,21', 'NOP', 'NOP'),
    'ED160000': ('DEFB 237,22', 'NOP', 'NOP'),
    'ED170000': ('DEFB 237,23', 'NOP', 'NOP'),
    'ED180000': ('DEFB 237,24', 'NOP', 'NOP'),
    'ED190000': ('DEFB 237,25', 'NOP', 'NOP'),
    'ED1A0000': ('DEFB 237,26', 'NOP', 'NOP'),
    'ED1B0000': ('DEFB 237,27', 'NOP', 'NOP'),
    'ED1C0000': ('DEFB 237,28', 'NOP', 'NOP'),
    'ED1D0000': ('DEFB 237,29', 'NOP', 'NOP'),
    'ED1E0000': ('DEFB 237,30', 'NOP', 'NOP'),
    'ED1F0000': ('DEFB 237,31', 'NOP', 'NOP'),
    'ED200000': ('DEFB 237,32', 'NOP', 'NOP'),
    'ED210000': ('DEFB 237,33', 'NOP', 'NOP'),
    'ED220000': ('DEFB 237,34', 'NOP', 'NOP'),
    'ED230000': ('DEFB 237,35', 'NOP', 'NOP'),
    'ED240000': ('DEFB 237,36', 'NOP', 'NOP'),
    'ED250000': ('DEFB 237,37', 'NOP', 'NOP'),
    'ED260000': ('DEFB 237,38', 'NOP', 'NOP'),
    'ED270000': ('DEFB 237,39', 'NOP', 'NOP'),
    'ED280000': ('DEFB 237,40', 'NOP', 'NOP'),
    'ED290000': ('DEFB 237,41', 'NOP', 'NOP'),
    'ED2A0000': ('DEFB 237,42', 'NOP', 'NOP'),
    'ED2B0000': ('DEFB 237,43', 'NOP', 'NOP'),
    'ED2C0000': ('DEFB 237,44', 'NOP', 'NOP'),
    'ED2D0000': ('DEFB 237,45', 'NOP', 'NOP'),
    'ED2E0000': ('DEFB 237,46', 'NOP', 'NOP'),
    'ED2F0000': ('DEFB 237,47', 'NOP', 'NOP'),
    'ED300000': ('DEFB 237,48', 'NOP', 'NOP'),
    'ED310000': ('DEFB 237,49', 'NOP', 'NOP'),
    'ED320000': ('DEFB 237,50', 'NOP', 'NOP'),
    'ED330000': ('DEFB 237,51', 'NOP', 'NOP'),
    'ED340000': ('DEFB 237,52', 'NOP', 'NOP'),
    'ED350000': ('DEFB 237,53', 'NOP', 'NOP'),
    'ED360000': ('DEFB 237,54', 'NOP', 'NOP'),
    'ED370000': ('DEFB 237,55', 'NOP', 'NOP'),
    'ED380000': ('DEFB 237,56', 'NOP', 'NOP'),
    'ED390000': ('DEFB 237,57', 'NOP', 'NOP'),
    'ED3A0000': ('DEFB 237,58', 'NOP', 'NOP'),
    'ED3B0000': ('DEFB 237,59', 'NOP', 'NOP'),
    'ED3C0000': ('DEFB 237,60', 'NOP', 'NOP'),
    'ED3D0000': ('DEFB 237,61', 'NOP', 'NOP'),
    'ED3E0000': ('DEFB 237,62', 'NOP', 'NOP'),
    'ED3F0000': ('DEFB 237,63', 'NOP', 'NOP'),
    'ED400000': ('IN B,(C)', 'NOP', 'NOP'),
    'ED410000': ('OUT (C),B', 'NOP', 'NOP'),
    'ED420000': ('SBC HL,BC', 'NOP', 'NOP'),
    'ED430000': ('LD (0),BC',),
    'ED440000': ('NEG', 'NOP', 'NOP'),
    'ED450000': ('RETN', 'NOP', 'NOP'),
    'ED460000': ('IM 0', 'NOP', 'NOP'),
    'ED470000': ('LD I,A', 'NOP', 'NOP'),
    'ED480000': ('IN C,(C)', 'NOP', 'NOP'),
    'ED490000': ('OUT (C),C', 'NOP', 'NOP'),
    'ED4A0000': ('ADC HL,BC', 'NOP', 'NOP'),
    'ED4B0000': ('LD BC,(0)',),
    'ED4C0000': ('DEFB 237,76', 'NOP', 'NOP'),
    'ED4D0000': ('RETI', 'NOP', 'NOP'),
    'ED4E0000': ('DEFB 237,78', 'NOP', 'NOP'),
    'ED4F0000': ('LD R,A', 'NOP', 'NOP'),
    'ED500000': ('IN D,(C)', 'NOP', 'NOP'),
    'ED510000': ('OUT (C),D', 'NOP', 'NOP'),
    'ED520000': ('SBC HL,DE', 'NOP', 'NOP'),
    'ED530000': ('LD (0),DE',),
    'ED540000': ('DEFB 237,84', 'NOP', 'NOP'),
    'ED550000': ('DEFB 237,85', 'NOP', 'NOP'),
    'ED560000': ('IM 1', 'NOP', 'NOP'),
    'ED570000': ('LD A,I', 'NOP', 'NOP'),
    'ED580000': ('IN E,(C)', 'NOP', 'NOP'),
    'ED590000': ('OUT (C),E', 'NOP', 'NOP'),
    'ED5A0000': ('ADC HL,DE', 'NOP', 'NOP'),
    'ED5B0000': ('LD DE,(0)',),
    'ED5C0000': ('DEFB 237,92', 'NOP', 'NOP'),
    'ED5D0000': ('DEFB 237,93', 'NOP', 'NOP'),
    'ED5E0000': ('IM 2', 'NOP', 'NOP'),
    'ED5F0000': ('LD A,R', 'NOP', 'NOP'),
    'ED600000': ('IN H,(C)', 'NOP', 'NOP'),
    'ED610000': ('OUT (C),H', 'NOP', 'NOP'),
    'ED620000': ('SBC HL,HL', 'NOP', 'NOP'),
    'ED630000': ('DEFB 237,99,0,0',),
    'ED640000': ('DEFB 237,100', 'NOP', 'NOP'),
    'ED650000': ('DEFB 237,101', 'NOP', 'NOP'),
    'ED660000': ('DEFB 237,102', 'NOP', 'NOP'),
    'ED670000': ('RRD', 'NOP', 'NOP'),
    'ED680000': ('IN L,(C)', 'NOP', 'NOP'),
    'ED690000': ('OUT (C),L', 'NOP', 'NOP'),
    'ED6A0000': ('ADC HL,HL', 'NOP', 'NOP'),
    'ED6B0000': ('DEFB 237,107,0,0',),
    'ED6C0000': ('DEFB 237,108', 'NOP', 'NOP'),
    'ED6D0000': ('DEFB 237,109', 'NOP', 'NOP'),
    'ED6E0000': ('DEFB 237,110', 'NOP', 'NOP'),
    'ED6F0000': ('RLD', 'NOP', 'NOP'),
    'ED700000': ('DEFB 237,112', 'NOP', 'NOP'),
    'ED710000': ('DEFB 237,113', 'NOP', 'NOP'),
    'ED720000': ('SBC HL,SP', 'NOP', 'NOP'),
    'ED730000': ('LD (0),SP',),
    'ED740000': ('DEFB 237,116', 'NOP', 'NOP'),
    'ED750000': ('DEFB 237,117', 'NOP', 'NOP'),
    'ED760000': ('DEFB 237,118', 'NOP', 'NOP'),
    'ED770000': ('DEFB 237,119', 'NOP', 'NOP'),
    'ED780000': ('IN A,(C)', 'NOP', 'NOP'),
    'ED790000': ('OUT (C),A', 'NOP', 'NOP'),
    'ED7A0000': ('ADC HL,SP', 'NOP', 'NOP'),
    'ED7B0000': ('LD SP,(0)',),
    'ED7C0000': ('DEFB 237,124', 'NOP', 'NOP'),
    'ED7D0000': ('DEFB 237,125', 'NOP', 'NOP'),
    'ED7E0000': ('DEFB 237,126', 'NOP', 'NOP'),
    'ED7F0000': ('DEFB 237,127', 'NOP', 'NOP'),
    'ED800000': ('DEFB 237,128', 'NOP', 'NOP'),
    'ED810000': ('DEFB 237,129', 'NOP', 'NOP'),
    'ED820000': ('DEFB 237,130', 'NOP', 'NOP'),
    'ED830000': ('DEFB 237,131', 'NOP', 'NOP'),
    'ED840000': ('DEFB 237,132', 'NOP', 'NOP'),
    'ED850000': ('DEFB 237,133', 'NOP', 'NOP'),
    'ED860000': ('DEFB 237,134', 'NOP', 'NOP'),
    'ED870000': ('DEFB 237,135', 'NOP', 'NOP'),
    'ED880000': ('DEFB 237,136', 'NOP', 'NOP'),
    'ED890000': ('DEFB 237,137', 'NOP', 'NOP'),
    'ED8A0000': ('DEFB 237,138', 'NOP', 'NOP'),
    'ED8B0000': ('DEFB 237,139', 'NOP', 'NOP'),
    'ED8C0000': ('DEFB 237,140', 'NOP', 'NOP'),
    'ED8D0000': ('DEFB 237,141', 'NOP', 'NOP'),
    'ED8E0000': ('DEFB 237,142', 'NOP', 'NOP'),
    'ED8F0000': ('DEFB 237,143', 'NOP', 'NOP'),
    'ED900000': ('DEFB 237,144', 'NOP', 'NOP'),
    'ED910000': ('DEFB 237,145', 'NOP', 'NOP'),
    'ED920000': ('DEFB 237,146', 'NOP', 'NOP'),
    'ED930000': ('DEFB 237,147', 'NOP', 'NOP'),
    'ED940000': ('DEFB 237,148', 'NOP', 'NOP'),
    'ED950000': ('DEFB 237,149', 'NOP', 'NOP'),
    'ED960000': ('DEFB 237,150', 'NOP', 'NOP'),
    'ED970000': ('DEFB 237,151', 'NOP', 'NOP'),
    'ED980000': ('DEFB 237,152', 'NOP', 'NOP'),
    'ED990000': ('DEFB 237,153', 'NOP', 'NOP'),
    'ED9A0000': ('DEFB 237,154', 'NOP', 'NOP'),
    'ED9B0000': ('DEFB 237,155', 'NOP', 'NOP'),
    'ED9C0000': ('DEFB 237,156', 'NOP', 'NOP'),
    'ED9D0000': ('DEFB 237,157', 'NOP', 'NOP'),
    'ED9E0000': ('DEFB 237,158', 'NOP', 'NOP'),
    'ED9F0000': ('DEFB 237,159', 'NOP', 'NOP'),
    'EDA00000': ('LDI', 'NOP', 'NOP'),
    'EDA10000': ('CPI', 'NOP', 'NOP'),
    'EDA20000': ('INI', 'NOP', 'NOP'),
    'EDA30000': ('OUTI', 'NOP', 'NOP'),
    'EDA40000': ('DEFB 237,164', 'NOP', 'NOP'),
    'EDA50000': ('DEFB 237,165', 'NOP', 'NOP'),
    'EDA60000': ('DEFB 237,166', 'NOP', 'NOP'),
    'EDA70000': ('DEFB 237,167', 'NOP', 'NOP'),
    'EDA80000': ('LDD', 'NOP', 'NOP'),
    'EDA90000': ('CPD', 'NOP', 'NOP'),
    'EDAA0000': ('IND', 'NOP', 'NOP'),
    'EDAB0000': ('OUTD', 'NOP', 'NOP'),
    'EDAC0000': ('DEFB 237,172', 'NOP', 'NOP'),
    'EDAD0000': ('DEFB 237,173', 'NOP', 'NOP'),
    'EDAE0000': ('DEFB 237,174', 'NOP', 'NOP'),
    'EDAF0000': ('DEFB 237,175', 'NOP', 'NOP'),
    'EDB00000': ('LDIR', 'NOP', 'NOP'),
    'EDB10000': ('CPIR', 'NOP', 'NOP'),
    'EDB20000': ('INIR', 'NOP', 'NOP'),
    'EDB30000': ('OTIR', 'NOP', 'NOP'),
    'EDB40000': ('DEFB 237,180', 'NOP', 'NOP'),
    'EDB50000': ('DEFB 237,181', 'NOP', 'NOP'),
    'EDB60000': ('DEFB 237,182', 'NOP', 'NOP'),
    'EDB70000': ('DEFB 237,183', 'NOP', 'NOP'),
    'EDB80000': ('LDDR', 'NOP', 'NOP'),
    'EDB90000': ('CPDR', 'NOP', 'NOP'),
    'EDBA0000': ('INDR', 'NOP', 'NOP'),
    'EDBB0000': ('OTDR', 'NOP', 'NOP'),
    'EDBC0000': ('DEFB 237,188', 'NOP', 'NOP'),
    'EDBD0000': ('DEFB 237,189', 'NOP', 'NOP'),
    'EDBE0000': ('DEFB 237,190', 'NOP', 'NOP'),
    'EDBF0000': ('DEFB 237,191', 'NOP', 'NOP'),
    'EDC00000': ('DEFB 237,192', 'NOP', 'NOP'),
    'EDC10000': ('DEFB 237,193', 'NOP', 'NOP'),
    'EDC20000': ('DEFB 237,194', 'NOP', 'NOP'),
    'EDC30000': ('DEFB 237,195', 'NOP', 'NOP'),
    'EDC40000': ('DEFB 237,196', 'NOP', 'NOP'),
    'EDC50000': ('DEFB 237,197', 'NOP', 'NOP'),
    'EDC60000': ('DEFB 237,198', 'NOP', 'NOP'),
    'EDC70000': ('DEFB 237,199', 'NOP', 'NOP'),
    'EDC80000': ('DEFB 237,200', 'NOP', 'NOP'),
    'EDC90000': ('DEFB 237,201', 'NOP', 'NOP'),
    'EDCA0000': ('DEFB 237,202', 'NOP', 'NOP'),
    'EDCB0000': ('DEFB 237,203', 'NOP', 'NOP'),
    'EDCC0000': ('DEFB 237,204', 'NOP', 'NOP'),
    'EDCD0000': ('DEFB 237,205', 'NOP', 'NOP'),
    'EDCE0000': ('DEFB 237,206', 'NOP', 'NOP'),
    'EDCF0000': ('DEFB 237,207', 'NOP', 'NOP'),
    'EDD00000': ('DEFB 237,208', 'NOP', 'NOP'),
    'EDD10000': ('DEFB 237,209', 'NOP', 'NOP'),
    'EDD20000': ('DEFB 237,210', 'NOP', 'NOP'),
    'EDD30000': ('DEFB 237,211', 'NOP', 'NOP'),
    'EDD40000': ('DEFB 237,212', 'NOP', 'NOP'),
    'EDD50000': ('DEFB 237,213', 'NOP', 'NOP'),
    'EDD60000': ('DEFB 237,214', 'NOP', 'NOP'),
    'EDD70000': ('DEFB 237,215', 'NOP', 'NOP'),
    'EDD80000': ('DEFB 237,216', 'NOP', 'NOP'),
    'EDD90000': ('DEFB 237,217', 'NOP', 'NOP'),
    'EDDA0000': ('DEFB 237,218', 'NOP', 'NOP'),
    'EDDB0000': ('DEFB 237,219', 'NOP', 'NOP'),
    'EDDC0000': ('DEFB 237,220', 'NOP', 'NOP'),
    'EDDD0000': ('DEFB 237,221', 'NOP', 'NOP'),
    'EDDE0000': ('DEFB 237,222', 'NOP', 'NOP'),
    'EDDF0000': ('DEFB 237,223', 'NOP', 'NOP'),
    'EDE00000': ('DEFB 237,224', 'NOP', 'NOP'),
    'EDE10000': ('DEFB 237,225', 'NOP', 'NOP'),
    'EDE20000': ('DEFB 237,226', 'NOP', 'NOP'),
    'EDE30000': ('DEFB 237,227', 'NOP', 'NOP'),
    'EDE40000': ('DEFB 237,228', 'NOP', 'NOP'),
    'EDE50000': ('DEFB 237,229', 'NOP', 'NOP'),
    'EDE60000': ('DEFB 237,230', 'NOP', 'NOP'),
    'EDE70000': ('DEFB 237,231', 'NOP', 'NOP'),
    'EDE80000': ('DEFB 237,232', 'NOP', 'NOP'),
    'EDE90000': ('DEFB 237,233', 'NOP', 'NOP'),
    'EDEA0000': ('DEFB 237,234', 'NOP', 'NOP'),
    'EDEB0000': ('DEFB 237,235', 'NOP', 'NOP'),
    'EDEC0000': ('DEFB 237,236', 'NOP', 'NOP'),
    'EDED0000': ('DEFB 237,237', 'NOP', 'NOP'),
    'EDEE0000': ('DEFB 237,238', 'NOP', 'NOP'),
    'EDEF0000': ('DEFB 237,239', 'NOP', 'NOP'),
    'EDF00000': ('DEFB 237,240', 'NOP', 'NOP'),
    'EDF10000': ('DEFB 237,241', 'NOP', 'NOP'),
    'EDF20000': ('DEFB 237,242', 'NOP', 'NOP'),
    'EDF30000': ('DEFB 237,243', 'NOP', 'NOP'),
    'EDF40000': ('DEFB 237,244', 'NOP', 'NOP'),
    'EDF50000': ('DEFB 237,245', 'NOP', 'NOP'),
    'EDF60000': ('DEFB 237,246', 'NOP', 'NOP'),
    'EDF70000': ('DEFB 237,247', 'NOP', 'NOP'),
    'EDF80000': ('DEFB 237,248', 'NOP', 'NOP'),
    'EDF90000': ('DEFB 237,249', 'NOP', 'NOP'),
    'EDFA0000': ('DEFB 237,250', 'NOP', 'NOP'),
    'EDFB0000': ('DEFB 237,251', 'NOP', 'NOP'),
    'EDFC0000': ('DEFB 237,252', 'NOP', 'NOP'),
    'EDFD0000': ('DEFB 237,253', 'NOP', 'NOP'),
    'EDFE0000': ('DEFB 237,254', 'NOP', 'NOP'),
    'EDFF0000': ('DEFB 237,255', 'NOP', 'NOP'),
    'DD000000': ('DEFB 221', 'NOP', 'NOP', 'NOP'),
    'DD010000': ('DEFB 221', 'LD BC,0'),
    'DD020000': ('DEFB 221', 'LD (BC),A', 'NOP', 'NOP'),
    'DD030000': ('DEFB 221', 'INC BC', 'NOP', 'NOP'),
    'DD040000': ('DEFB 221', 'INC B', 'NOP', 'NOP'),
    'DD050000': ('DEFB 221', 'DEC B', 'NOP', 'NOP'),
    'DD060000': ('DEFB 221', 'LD B,0', 'NOP'),
    'DD070000': ('DEFB 221', 'RLCA', 'NOP', 'NOP'),
    'DD080000': ('DEFB 221', "EX AF,AF'", 'NOP', 'NOP'),
    'DD090000': ('ADD IX,BC', 'NOP', 'NOP'),
    'DD0A0000': ('DEFB 221', 'LD A,(BC)', 'NOP', 'NOP'),
    'DD0B0000': ('DEFB 221', 'DEC BC', 'NOP', 'NOP'),
    'DD0C0000': ('DEFB 221', 'INC C', 'NOP', 'NOP'),
    'DD0D0000': ('DEFB 221', 'DEC C', 'NOP', 'NOP'),
    'DD0E0000': ('DEFB 221', 'LD C,0', 'NOP'),
    'DD0F0000': ('DEFB 221', 'RRCA', 'NOP', 'NOP'),
    'DD100000': ('DEFB 221', 'DJNZ 16387', 'NOP'),
    'DD110000': ('DEFB 221', 'LD DE,0'),
    'DD120000': ('DEFB 221', 'LD (DE),A', 'NOP', 'NOP'),
    'DD130000': ('DEFB 221', 'INC DE', 'NOP', 'NOP'),
    'DD140000': ('DEFB 221', 'INC D', 'NOP', 'NOP'),
    'DD150000': ('DEFB 221', 'DEC D', 'NOP', 'NOP'),
    'DD160000': ('DEFB 221', 'LD D,0', 'NOP'),
    'DD170000': ('DEFB 221', 'RLA', 'NOP', 'NOP'),
    'DD180000': ('DEFB 221', 'JR 16387', 'NOP'),
    'DD190000': ('ADD IX,DE', 'NOP', 'NOP'),
    'DD1A0000': ('DEFB 221', 'LD A,(DE)', 'NOP', 'NOP'),
    'DD1B0000': ('DEFB 221', 'DEC DE', 'NOP', 'NOP'),
    'DD1C0000': ('DEFB 221', 'INC E', 'NOP', 'NOP'),
    'DD1D0000': ('DEFB 221', 'DEC E', 'NOP', 'NOP'),
    'DD1E0000': ('DEFB 221', 'LD E,0', 'NOP'),
    'DD1F0000': ('DEFB 221', 'RRA', 'NOP', 'NOP'),
    'DD200000': ('DEFB 221', 'JR NZ,16387', 'NOP'),
    'DD210000': ('LD IX,0',),
    'DD220000': ('LD (0),IX',),
    'DD230000': ('INC IX', 'NOP', 'NOP'),
    'DD240000': ('INC IXh', 'NOP', 'NOP'),
    'DD250000': ('DEC IXh', 'NOP', 'NOP'),
    'DD260000': ('LD IXh,0', 'NOP'),
    'DD270000': ('DEFB 221', 'DAA', 'NOP', 'NOP'),
    'DD280000': ('DEFB 221', 'JR Z,16387', 'NOP'),
    'DD290000': ('ADD IX,IX', 'NOP', 'NOP'),
    'DD2A0000': ('LD IX,(0)',),
    'DD2B0000': ('DEC IX', 'NOP', 'NOP'),
    'DD2C0000': ('INC IXl', 'NOP', 'NOP'),
    'DD2D0000': ('DEC IXl', 'NOP', 'NOP'),
    'DD2E0000': ('LD IXl,0', 'NOP'),
    'DD2F0000': ('DEFB 221', 'CPL', 'NOP', 'NOP'),
    'DD300000': ('DEFB 221', 'JR NC,16387', 'NOP'),
    'DD310000': ('DEFB 221', 'LD SP,0'),
    'DD320000': ('DEFB 221', 'LD (0),A'),
    'DD330000': ('DEFB 221', 'INC SP', 'NOP', 'NOP'),
    'DD340000': ('INC (IX+0)', 'NOP'),
    'DD350000': ('DEC (IX+0)', 'NOP'),
    'DD360A14': ('LD (IX+10),20',),
    'DD370000': ('DEFB 221', 'SCF', 'NOP', 'NOP'),
    'DD380000': ('DEFB 221', 'JR C,16387', 'NOP'),
    'DD390000': ('ADD IX,SP', 'NOP', 'NOP'),
    'DD3A0000': ('DEFB 221', 'LD A,(0)'),
    'DD3B0000': ('DEFB 221', 'DEC SP', 'NOP', 'NOP'),
    'DD3C0000': ('DEFB 221', 'INC A', 'NOP', 'NOP'),
    'DD3D0000': ('DEFB 221', 'DEC A', 'NOP', 'NOP'),
    'DD3E0000': ('DEFB 221', 'LD A,0', 'NOP'),
    'DD3F0000': ('DEFB 221', 'CCF', 'NOP', 'NOP'),
    'DD400000': ('DEFB 221', 'LD B,B', 'NOP', 'NOP'),
    'DD410000': ('DEFB 221', 'LD B,C', 'NOP', 'NOP'),
    'DD420000': ('DEFB 221', 'LD B,D', 'NOP', 'NOP'),
    'DD430000': ('DEFB 221', 'LD B,E', 'NOP', 'NOP'),
    'DD440000': ('LD B,IXh', 'NOP', 'NOP'),
    'DD450000': ('LD B,IXl', 'NOP', 'NOP'),
    'DD460000': ('LD B,(IX+0)', 'NOP'),
    'DD470000': ('DEFB 221', 'LD B,A', 'NOP', 'NOP'),
    'DD480000': ('DEFB 221', 'LD C,B', 'NOP', 'NOP'),
    'DD490000': ('DEFB 221', 'LD C,C', 'NOP', 'NOP'),
    'DD4A0000': ('DEFB 221', 'LD C,D', 'NOP', 'NOP'),
    'DD4B0000': ('DEFB 221', 'LD C,E', 'NOP', 'NOP'),
    'DD4C0000': ('LD C,IXh', 'NOP', 'NOP'),
    'DD4D0000': ('LD C,IXl', 'NOP', 'NOP'),
    'DD4E0000': ('LD C,(IX+0)', 'NOP'),
    'DD4F0000': ('DEFB 221', 'LD C,A', 'NOP', 'NOP'),
    'DD500000': ('DEFB 221', 'LD D,B', 'NOP', 'NOP'),
    'DD510000': ('DEFB 221', 'LD D,C', 'NOP', 'NOP'),
    'DD520000': ('DEFB 221', 'LD D,D', 'NOP', 'NOP'),
    'DD530000': ('DEFB 221', 'LD D,E', 'NOP', 'NOP'),
    'DD540000': ('LD D,IXh', 'NOP', 'NOP'),
    'DD550000': ('LD D,IXl', 'NOP', 'NOP'),
    'DD560000': ('LD D,(IX+0)', 'NOP'),
    'DD570000': ('DEFB 221', 'LD D,A', 'NOP', 'NOP'),
    'DD580000': ('DEFB 221', 'LD E,B', 'NOP', 'NOP'),
    'DD590000': ('DEFB 221', 'LD E,C', 'NOP', 'NOP'),
    'DD5A0000': ('DEFB 221', 'LD E,D', 'NOP', 'NOP'),
    'DD5B0000': ('DEFB 221', 'LD E,E', 'NOP', 'NOP'),
    'DD5C0000': ('LD E,IXh', 'NOP', 'NOP'),
    'DD5D0000': ('LD E,IXl', 'NOP', 'NOP'),
    'DD5E0000': ('LD E,(IX+0)', 'NOP'),
    'DD5F0000': ('DEFB 221', 'LD E,A', 'NOP', 'NOP'),
    'DD600000': ('LD IXh,B', 'NOP', 'NOP'),
    'DD610000': ('LD IXh,C', 'NOP', 'NOP'),
    'DD620000': ('LD IXh,D', 'NOP', 'NOP'),
    'DD630000': ('LD IXh,E', 'NOP', 'NOP'),
    'DD640000': ('LD IXh,IXh', 'NOP', 'NOP'),
    'DD650000': ('LD IXh,IXl', 'NOP', 'NOP'),
    'DD660000': ('LD H,(IX+0)', 'NOP'),
    'DD670000': ('LD IXh,A', 'NOP', 'NOP'),
    'DD680000': ('LD IXl,B', 'NOP', 'NOP'),
    'DD690000': ('LD IXl,C', 'NOP', 'NOP'),
    'DD6A0000': ('LD IXl,D', 'NOP', 'NOP'),
    'DD6B0000': ('LD IXl,E', 'NOP', 'NOP'),
    'DD6C0000': ('LD IXl,IXh', 'NOP', 'NOP'),
    'DD6D0000': ('LD IXl,IXl', 'NOP', 'NOP'),
    'DD6E0000': ('LD L,(IX+0)', 'NOP'),
    'DD6F0000': ('LD IXl,A', 'NOP', 'NOP'),
    'DD700000': ('LD (IX+0),B', 'NOP'),
    'DD710000': ('LD (IX+0),C', 'NOP'),
    'DD720000': ('LD (IX+0),D', 'NOP'),
    'DD730000': ('LD (IX+0),E', 'NOP'),
    'DD740000': ('LD (IX+0),H', 'NOP'),
    'DD750000': ('LD (IX+0),L', 'NOP'),
    'DD760000': ('DEFB 221', 'HALT', 'NOP', 'NOP'),
    'DD770000': ('LD (IX+0),A', 'NOP'),
    'DD780000': ('DEFB 221', 'LD A,B', 'NOP', 'NOP'),
    'DD790000': ('DEFB 221', 'LD A,C', 'NOP', 'NOP'),
    'DD7A0000': ('DEFB 221', 'LD A,D', 'NOP', 'NOP'),
    'DD7B0000': ('DEFB 221', 'LD A,E', 'NOP', 'NOP'),
    'DD7C0000': ('LD A,IXh', 'NOP', 'NOP'),
    'DD7D0000': ('LD A,IXl', 'NOP', 'NOP'),
    'DD7E0000': ('LD A,(IX+0)', 'NOP'),
    'DD7F0000': ('DEFB 221', 'LD A,A', 'NOP', 'NOP'),
    'DD800000': ('DEFB 221', 'ADD A,B', 'NOP', 'NOP'),
    'DD810000': ('DEFB 221', 'ADD A,C', 'NOP', 'NOP'),
    'DD820000': ('DEFB 221', 'ADD A,D', 'NOP', 'NOP'),
    'DD830000': ('DEFB 221', 'ADD A,E', 'NOP', 'NOP'),
    'DD840000': ('ADD A,IXh', 'NOP', 'NOP'),
    'DD850000': ('ADD A,IXl', 'NOP', 'NOP'),
    'DD860000': ('ADD A,(IX+0)', 'NOP'),
    'DD870000': ('DEFB 221', 'ADD A,A', 'NOP', 'NOP'),
    'DD880000': ('DEFB 221', 'ADC A,B', 'NOP', 'NOP'),
    'DD890000': ('DEFB 221', 'ADC A,C', 'NOP', 'NOP'),
    'DD8A0000': ('DEFB 221', 'ADC A,D', 'NOP', 'NOP'),
    'DD8B0000': ('DEFB 221', 'ADC A,E', 'NOP', 'NOP'),
    'DD8C0000': ('ADC A,IXh', 'NOP', 'NOP'),
    'DD8D0000': ('ADC A,IXl', 'NOP', 'NOP'),
    'DD8E0000': ('ADC A,(IX+0)', 'NOP'),
    'DD8F0000': ('DEFB 221', 'ADC A,A', 'NOP', 'NOP'),
    'DD900000': ('DEFB 221', 'SUB B', 'NOP', 'NOP'),
    'DD910000': ('DEFB 221', 'SUB C', 'NOP', 'NOP'),
    'DD920000': ('DEFB 221', 'SUB D', 'NOP', 'NOP'),
    'DD930000': ('DEFB 221', 'SUB E', 'NOP', 'NOP'),
    'DD940000': ('SUB IXh', 'NOP', 'NOP'),
    'DD950000': ('SUB IXl', 'NOP', 'NOP'),
    'DD960000': ('SUB (IX+0)', 'NOP'),
    'DD970000': ('DEFB 221', 'SUB A', 'NOP', 'NOP'),
    'DD980000': ('DEFB 221', 'SBC A,B', 'NOP', 'NOP'),
    'DD990000': ('DEFB 221', 'SBC A,C', 'NOP', 'NOP'),
    'DD9A0000': ('DEFB 221', 'SBC A,D', 'NOP', 'NOP'),
    'DD9B0000': ('DEFB 221', 'SBC A,E', 'NOP', 'NOP'),
    'DD9C0000': ('SBC A,IXh', 'NOP', 'NOP'),
    'DD9D0000': ('SBC A,IXl', 'NOP', 'NOP'),
    'DD9E0000': ('SBC A,(IX+0)', 'NOP'),
    'DD9F0000': ('DEFB 221', 'SBC A,A', 'NOP', 'NOP'),
    'DDA00000': ('DEFB 221', 'AND B', 'NOP', 'NOP'),
    'DDA10000': ('DEFB 221', 'AND C', 'NOP', 'NOP'),
    'DDA20000': ('DEFB 221', 'AND D', 'NOP', 'NOP'),
    'DDA30000': ('DEFB 221', 'AND E', 'NOP', 'NOP'),
    'DDA40000': ('AND IXh', 'NOP', 'NOP'),
    'DDA50000': ('AND IXl', 'NOP', 'NOP'),
    'DDA60000': ('AND (IX+0)', 'NOP'),
    'DDA70000': ('DEFB 221', 'AND A', 'NOP', 'NOP'),
    'DDA80000': ('DEFB 221', 'XOR B', 'NOP', 'NOP'),
    'DDA90000': ('DEFB 221', 'XOR C', 'NOP', 'NOP'),
    'DDAA0000': ('DEFB 221', 'XOR D', 'NOP', 'NOP'),
    'DDAB0000': ('DEFB 221', 'XOR E', 'NOP', 'NOP'),
    'DDAC0000': ('XOR IXh', 'NOP', 'NOP'),
    'DDAD0000': ('XOR IXl', 'NOP', 'NOP'),
    'DDAE0000': ('XOR (IX+0)', 'NOP'),
    'DDAF0000': ('DEFB 221', 'XOR A', 'NOP', 'NOP'),
    'DDB00000': ('DEFB 221', 'OR B', 'NOP', 'NOP'),
    'DDB10000': ('DEFB 221', 'OR C', 'NOP', 'NOP'),
    'DDB20000': ('DEFB 221', 'OR D', 'NOP', 'NOP'),
    'DDB30000': ('DEFB 221', 'OR E', 'NOP', 'NOP'),
    'DDB40000': ('OR IXh', 'NOP', 'NOP'),
    'DDB50000': ('OR IXl', 'NOP', 'NOP'),
    'DDB60000': ('OR (IX+0)', 'NOP'),
    'DDB70000': ('DEFB 221', 'OR A', 'NOP', 'NOP'),
    'DDB80000': ('DEFB 221', 'CP B', 'NOP', 'NOP'),
    'DDB90000': ('DEFB 221', 'CP C', 'NOP', 'NOP'),
    'DDBA0000': ('DEFB 221', 'CP D', 'NOP', 'NOP'),
    'DDBB0000': ('DEFB 221', 'CP E', 'NOP', 'NOP'),
    'DDBC0000': ('CP IXh', 'NOP', 'NOP'),
    'DDBD0000': ('CP IXl', 'NOP', 'NOP'),
    'DDBE0000': ('CP (IX+0)', 'NOP'),
    'DDBF0000': ('DEFB 221', 'CP A', 'NOP', 'NOP'),
    'DDC00000': ('DEFB 221', 'RET NZ', 'NOP', 'NOP'),
    'DDC10000': ('DEFB 221', 'POP BC', 'NOP', 'NOP'),
    'DDC20000': ('DEFB 221', 'JP NZ,0'),
    'DDC30000': ('DEFB 221', 'JP 0'),
    'DDC40000': ('DEFB 221', 'CALL NZ,0'),
    'DDC50000': ('DEFB 221', 'PUSH BC', 'NOP', 'NOP'),
    'DDC60000': ('DEFB 221', 'ADD A,0', 'NOP'),
    'DDC70000': ('DEFB 221', 'RST 0', 'NOP', 'NOP'),
    'DDC80000': ('DEFB 221', 'RET Z', 'NOP', 'NOP'),
    'DDC90000': ('DEFB 221', 'RET', 'NOP', 'NOP'),
    'DDCA0000': ('DEFB 221', 'JP Z,0'),
    'DDCB0000': ('DEFB 221,203,0,0',),
    'DDCC0000': ('DEFB 221', 'CALL Z,0'),
    'DDCD0000': ('DEFB 221', 'CALL 0'),
    'DDCE0000': ('DEFB 221', 'ADC A,0', 'NOP'),
    'DDCF0000': ('DEFB 221', 'RST 8', 'NOP', 'NOP'),
    'DDD00000': ('DEFB 221', 'RET NC', 'NOP', 'NOP'),
    'DDD10000': ('DEFB 221', 'POP DE', 'NOP', 'NOP'),
    'DDD20000': ('DEFB 221', 'JP NC,0'),
    'DDD30000': ('DEFB 221', 'OUT (0),A', 'NOP'),
    'DDD40000': ('DEFB 221', 'CALL NC,0'),
    'DDD50000': ('DEFB 221', 'PUSH DE', 'NOP', 'NOP'),
    'DDD60000': ('DEFB 221', 'SUB 0', 'NOP'),
    'DDD70000': ('DEFB 221', 'RST 16', 'NOP', 'NOP'),
    'DDD80000': ('DEFB 221', 'RET C', 'NOP', 'NOP'),
    'DDD90000': ('DEFB 221', 'EXX', 'NOP', 'NOP'),
    'DDDA0000': ('DEFB 221', 'JP C,0'),
    'DDDB0000': ('DEFB 221', 'IN A,(0)', 'NOP'),
    'DDDC0000': ('DEFB 221', 'CALL C,0'),
    'DDDD0000': ('DEFB 221', 'DEFB 221', 'NOP', 'NOP'),
    'DDDE0000': ('DEFB 221', 'SBC A,0', 'NOP'),
    'DDDF0000': ('DEFB 221', 'RST 24', 'NOP', 'NOP'),
    'DDE00000': ('DEFB 221', 'RET PO', 'NOP', 'NOP'),
    'DDE10000': ('POP IX', 'NOP', 'NOP'),
    'DDE20000': ('DEFB 221', 'JP PO,0'),
    'DDE30000': ('EX (SP),IX', 'NOP', 'NOP'),
    'DDE40000': ('DEFB 221', 'CALL PO,0'),
    'DDE50000': ('PUSH IX', 'NOP', 'NOP'),
    'DDE60000': ('DEFB 221', 'AND 0', 'NOP'),
    'DDE70000': ('DEFB 221', 'RST 32', 'NOP', 'NOP'),
    'DDE80000': ('DEFB 221', 'RET PE', 'NOP', 'NOP'),
    'DDE90000': ('JP (IX)', 'NOP', 'NOP'),
    'DDEA0000': ('DEFB 221', 'JP PE,0'),
    'DDEB0000': ('DEFB 221', 'EX DE,HL', 'NOP', 'NOP'),
    'DDEC0000': ('DEFB 221', 'CALL PE,0'),
    'DDED0000': ('DEFB 221', 'DEFB 237,0', 'NOP'),
    'DDEE0000': ('DEFB 221', 'XOR 0', 'NOP'),
    'DDEF0000': ('DEFB 221', 'RST 40', 'NOP', 'NOP'),
    'DDF00000': ('DEFB 221', 'RET P', 'NOP', 'NOP'),
    'DDF10000': ('DEFB 221', 'POP AF', 'NOP', 'NOP'),
    'DDF20000': ('DEFB 221', 'JP P,0'),
    'DDF30000': ('DEFB 221', 'DI', 'NOP', 'NOP'),
    'DDF40000': ('DEFB 221', 'CALL P,0'),
    'DDF50000': ('DEFB 221', 'PUSH AF', 'NOP', 'NOP'),
    'DDF60000': ('DEFB 221', 'OR 0', 'NOP'),
    'DDF70000': ('DEFB 221', 'RST 48', 'NOP', 'NOP'),
    'DDF80000': ('DEFB 221', 'RET M', 'NOP', 'NOP'),
    'DDF90000': ('LD SP,IX', 'NOP', 'NOP'),
    'DDFA0000': ('DEFB 221', 'JP M,0'),
    'DDFB0000': ('DEFB 221', 'EI', 'NOP', 'NOP'),
    'DDFC0000': ('DEFB 221', 'CALL M,0'),
    'DDFD0000': ('DEFB 221', 'DEFB 253', 'NOP', 'NOP'),
    'DDFE0000': ('DEFB 221', 'CP 0', 'NOP'),
    'DDFF0000': ('DEFB 221', 'RST 56', 'NOP', 'NOP'),
    'FD000000': ('DEFB 253', 'NOP', 'NOP', 'NOP'),
    'FD010000': ('DEFB 253', 'LD BC,0'),
    'FD020000': ('DEFB 253', 'LD (BC),A', 'NOP', 'NOP'),
    'FD030000': ('DEFB 253', 'INC BC', 'NOP', 'NOP'),
    'FD040000': ('DEFB 253', 'INC B', 'NOP', 'NOP'),
    'FD050000': ('DEFB 253', 'DEC B', 'NOP', 'NOP'),
    'FD060000': ('DEFB 253', 'LD B,0', 'NOP'),
    'FD070000': ('DEFB 253', 'RLCA', 'NOP', 'NOP'),
    'FD080000': ('DEFB 253', "EX AF,AF'", 'NOP', 'NOP'),
    'FD090000': ('ADD IY,BC', 'NOP', 'NOP'),
    'FD0A0000': ('DEFB 253', 'LD A,(BC)', 'NOP', 'NOP'),
    'FD0B0000': ('DEFB 253', 'DEC BC', 'NOP', 'NOP'),
    'FD0C0000': ('DEFB 253', 'INC C', 'NOP', 'NOP'),
    'FD0D0000': ('DEFB 253', 'DEC C', 'NOP', 'NOP'),
    'FD0E0000': ('DEFB 253', 'LD C,0', 'NOP'),
    'FD0F0000': ('DEFB 253', 'RRCA', 'NOP', 'NOP'),
    'FD100000': ('DEFB 253', 'DJNZ 16387', 'NOP'),
    'FD110000': ('DEFB 253', 'LD DE,0'),
    'FD120000': ('DEFB 253', 'LD (DE),A', 'NOP', 'NOP'),
    'FD130000': ('DEFB 253', 'INC DE', 'NOP', 'NOP'),
    'FD140000': ('DEFB 253', 'INC D', 'NOP', 'NOP'),
    'FD150000': ('DEFB 253', 'DEC D', 'NOP', 'NOP'),
    'FD160000': ('DEFB 253', 'LD D,0', 'NOP'),
    'FD170000': ('DEFB 253', 'RLA', 'NOP', 'NOP'),
    'FD180000': ('DEFB 253', 'JR 16387', 'NOP'),
    'FD190000': ('ADD IY,DE', 'NOP', 'NOP'),
    'FD1A0000': ('DEFB 253', 'LD A,(DE)', 'NOP', 'NOP'),
    'FD1B0000': ('DEFB 253', 'DEC DE', 'NOP', 'NOP'),
    'FD1C0000': ('DEFB 253', 'INC E', 'NOP', 'NOP'),
    'FD1D0000': ('DEFB 253', 'DEC E', 'NOP', 'NOP'),
    'FD1E0000': ('DEFB 253', 'LD E,0', 'NOP'),
    'FD1F0000': ('DEFB 253', 'RRA', 'NOP', 'NOP'),
    'FD200000': ('DEFB 253', 'JR NZ,16387', 'NOP'),
    'FD210000': ('LD IY,0',),
    'FD220000': ('LD (0),IY',),
    'FD230000': ('INC IY', 'NOP', 'NOP'),
    'FD240000': ('INC IYh', 'NOP', 'NOP'),
    'FD250000': ('DEC IYh', 'NOP', 'NOP'),
    'FD260000': ('LD IYh,0', 'NOP'),
    'FD270000': ('DEFB 253', 'DAA', 'NOP', 'NOP'),
    'FD280000': ('DEFB 253', 'JR Z,16387', 'NOP'),
    'FD290000': ('ADD IY,IY', 'NOP', 'NOP'),
    'FD2A0000': ('LD IY,(0)',),
    'FD2B0000': ('DEC IY', 'NOP', 'NOP'),
    'FD2C0000': ('INC IYl', 'NOP', 'NOP'),
    'FD2D0000': ('DEC IYl', 'NOP', 'NOP'),
    'FD2E0000': ('LD IYl,0', 'NOP'),
    'FD2F0000': ('DEFB 253', 'CPL', 'NOP', 'NOP'),
    'FD300000': ('DEFB 253', 'JR NC,16387', 'NOP'),
    'FD310000': ('DEFB 253', 'LD SP,0'),
    'FD320000': ('DEFB 253', 'LD (0),A'),
    'FD330000': ('DEFB 253', 'INC SP', 'NOP', 'NOP'),
    'FD340000': ('INC (IY+0)', 'NOP'),
    'FD350000': ('DEC (IY+0)', 'NOP'),
    'FD360000': ('LD (IY+0),0',),
    'FD370000': ('DEFB 253', 'SCF', 'NOP', 'NOP'),
    'FD380000': ('DEFB 253', 'JR C,16387', 'NOP'),
    'FD390000': ('ADD IY,SP', 'NOP', 'NOP'),
    'FD3A0000': ('DEFB 253', 'LD A,(0)'),
    'FD3B0000': ('DEFB 253', 'DEC SP', 'NOP', 'NOP'),
    'FD3C0000': ('DEFB 253', 'INC A', 'NOP', 'NOP'),
    'FD3D0000': ('DEFB 253', 'DEC A', 'NOP', 'NOP'),
    'FD3E0000': ('DEFB 253', 'LD A,0', 'NOP'),
    'FD3F0000': ('DEFB 253', 'CCF', 'NOP', 'NOP'),
    'FD400000': ('DEFB 253', 'LD B,B', 'NOP', 'NOP'),
    'FD410000': ('DEFB 253', 'LD B,C', 'NOP', 'NOP'),
    'FD420000': ('DEFB 253', 'LD B,D', 'NOP', 'NOP'),
    'FD430000': ('DEFB 253', 'LD B,E', 'NOP', 'NOP'),
    'FD440000': ('LD B,IYh', 'NOP', 'NOP'),
    'FD450000': ('LD B,IYl', 'NOP', 'NOP'),
    'FD460000': ('LD B,(IY+0)', 'NOP'),
    'FD470000': ('DEFB 253', 'LD B,A', 'NOP', 'NOP'),
    'FD480000': ('DEFB 253', 'LD C,B', 'NOP', 'NOP'),
    'FD490000': ('DEFB 253', 'LD C,C', 'NOP', 'NOP'),
    'FD4A0000': ('DEFB 253', 'LD C,D', 'NOP', 'NOP'),
    'FD4B0000': ('DEFB 253', 'LD C,E', 'NOP', 'NOP'),
    'FD4C0000': ('LD C,IYh', 'NOP', 'NOP'),
    'FD4D0000': ('LD C,IYl', 'NOP', 'NOP'),
    'FD4E0000': ('LD C,(IY+0)', 'NOP'),
    'FD4F0000': ('DEFB 253', 'LD C,A', 'NOP', 'NOP'),
    'FD500000': ('DEFB 253', 'LD D,B', 'NOP', 'NOP'),
    'FD510000': ('DEFB 253', 'LD D,C', 'NOP', 'NOP'),
    'FD520000': ('DEFB 253', 'LD D,D', 'NOP', 'NOP'),
    'FD530000': ('DEFB 253', 'LD D,E', 'NOP', 'NOP'),
    'FD540000': ('LD D,IYh', 'NOP', 'NOP'),
    'FD550000': ('LD D,IYl', 'NOP', 'NOP'),
    'FD560000': ('LD D,(IY+0)', 'NOP'),
    'FD570000': ('DEFB 253', 'LD D,A', 'NOP', 'NOP'),
    'FD580000': ('DEFB 253', 'LD E,B', 'NOP', 'NOP'),
    'FD590000': ('DEFB 253', 'LD E,C', 'NOP', 'NOP'),
    'FD5A0000': ('DEFB 253', 'LD E,D', 'NOP', 'NOP'),
    'FD5B0000': ('DEFB 253', 'LD E,E', 'NOP', 'NOP'),
    'FD5C0000': ('LD E,IYh', 'NOP', 'NOP'),
    'FD5D0000': ('LD E,IYl', 'NOP', 'NOP'),
    'FD5E0000': ('LD E,(IY+0)', 'NOP'),
    'FD5F0000': ('DEFB 253', 'LD E,A', 'NOP', 'NOP'),
    'FD600000': ('LD IYh,B', 'NOP', 'NOP'),
    'FD610000': ('LD IYh,C', 'NOP', 'NOP'),
    'FD620000': ('LD IYh,D', 'NOP', 'NOP'),
    'FD630000': ('LD IYh,E', 'NOP', 'NOP'),
    'FD640000': ('LD IYh,IYh', 'NOP', 'NOP'),
    'FD650000': ('LD IYh,IYl', 'NOP', 'NOP'),
    'FD660000': ('LD H,(IY+0)', 'NOP'),
    'FD670000': ('LD IYh,A', 'NOP', 'NOP'),
    'FD680000': ('LD IYl,B', 'NOP', 'NOP'),
    'FD690000': ('LD IYl,C', 'NOP', 'NOP'),
    'FD6A0000': ('LD IYl,D', 'NOP', 'NOP'),
    'FD6B0000': ('LD IYl,E', 'NOP', 'NOP'),
    'FD6C0000': ('LD IYl,IYh', 'NOP', 'NOP'),
    'FD6D0000': ('LD IYl,IYl', 'NOP', 'NOP'),
    'FD6E0000': ('LD L,(IY+0)', 'NOP'),
    'FD6F0000': ('LD IYl,A', 'NOP', 'NOP'),
    'FD700000': ('LD (IY+0),B', 'NOP'),
    'FD710000': ('LD (IY+0),C', 'NOP'),
    'FD720000': ('LD (IY+0),D', 'NOP'),
    'FD730000': ('LD (IY+0),E', 'NOP'),
    'FD740000': ('LD (IY+0),H', 'NOP'),
    'FD750000': ('LD (IY+0),L', 'NOP'),
    'FD760000': ('DEFB 253', 'HALT', 'NOP', 'NOP'),
    'FD770000': ('LD (IY+0),A', 'NOP'),
    'FD780000': ('DEFB 253', 'LD A,B', 'NOP', 'NOP'),
    'FD790000': ('DEFB 253', 'LD A,C', 'NOP', 'NOP'),
    'FD7A0000': ('DEFB 253', 'LD A,D', 'NOP', 'NOP'),
    'FD7B0000': ('DEFB 253', 'LD A,E', 'NOP', 'NOP'),
    'FD7C0000': ('LD A,IYh', 'NOP', 'NOP'),
    'FD7D0000': ('LD A,IYl', 'NOP', 'NOP'),
    'FD7E0000': ('LD A,(IY+0)', 'NOP'),
    'FD7F0000': ('DEFB 253', 'LD A,A', 'NOP', 'NOP'),
    'FD800000': ('DEFB 253', 'ADD A,B', 'NOP', 'NOP'),
    'FD810000': ('DEFB 253', 'ADD A,C', 'NOP', 'NOP'),
    'FD820000': ('DEFB 253', 'ADD A,D', 'NOP', 'NOP'),
    'FD830000': ('DEFB 253', 'ADD A,E', 'NOP', 'NOP'),
    'FD840000': ('ADD A,IYh', 'NOP', 'NOP'),
    'FD850000': ('ADD A,IYl', 'NOP', 'NOP'),
    'FD860000': ('ADD A,(IY+0)', 'NOP'),
    'FD870000': ('DEFB 253', 'ADD A,A', 'NOP', 'NOP'),
    'FD880000': ('DEFB 253', 'ADC A,B', 'NOP', 'NOP'),
    'FD890000': ('DEFB 253', 'ADC A,C', 'NOP', 'NOP'),
    'FD8A0000': ('DEFB 253', 'ADC A,D', 'NOP', 'NOP'),
    'FD8B0000': ('DEFB 253', 'ADC A,E', 'NOP', 'NOP'),
    'FD8C0000': ('ADC A,IYh', 'NOP', 'NOP'),
    'FD8D0000': ('ADC A,IYl', 'NOP', 'NOP'),
    'FD8E0000': ('ADC A,(IY+0)', 'NOP'),
    'FD8F0000': ('DEFB 253', 'ADC A,A', 'NOP', 'NOP'),
    'FD900000': ('DEFB 253', 'SUB B', 'NOP', 'NOP'),
    'FD910000': ('DEFB 253', 'SUB C', 'NOP', 'NOP'),
    'FD920000': ('DEFB 253', 'SUB D', 'NOP', 'NOP'),
    'FD930000': ('DEFB 253', 'SUB E', 'NOP', 'NOP'),
    'FD940000': ('SUB IYh', 'NOP', 'NOP'),
    'FD950000': ('SUB IYl', 'NOP', 'NOP'),
    'FD960000': ('SUB (IY+0)', 'NOP'),
    'FD970000': ('DEFB 253', 'SUB A', 'NOP', 'NOP'),
    'FD980000': ('DEFB 253', 'SBC A,B', 'NOP', 'NOP'),
    'FD990000': ('DEFB 253', 'SBC A,C', 'NOP', 'NOP'),
    'FD9A0000': ('DEFB 253', 'SBC A,D', 'NOP', 'NOP'),
    'FD9B0000': ('DEFB 253', 'SBC A,E', 'NOP', 'NOP'),
    'FD9C0000': ('SBC A,IYh', 'NOP', 'NOP'),
    'FD9D0000': ('SBC A,IYl', 'NOP', 'NOP'),
    'FD9E0000': ('SBC A,(IY+0)', 'NOP'),
    'FD9F0000': ('DEFB 253', 'SBC A,A', 'NOP', 'NOP'),
    'FDA00000': ('DEFB 253', 'AND B', 'NOP', 'NOP'),
    'FDA10000': ('DEFB 253', 'AND C', 'NOP', 'NOP'),
    'FDA20000': ('DEFB 253', 'AND D', 'NOP', 'NOP'),
    'FDA30000': ('DEFB 253', 'AND E', 'NOP', 'NOP'),
    'FDA40000': ('AND IYh', 'NOP', 'NOP'),
    'FDA50000': ('AND IYl', 'NOP', 'NOP'),
    'FDA60000': ('AND (IY+0)', 'NOP'),
    'FDA70000': ('DEFB 253', 'AND A', 'NOP', 'NOP'),
    'FDA80000': ('DEFB 253', 'XOR B', 'NOP', 'NOP'),
    'FDA90000': ('DEFB 253', 'XOR C', 'NOP', 'NOP'),
    'FDAA0000': ('DEFB 253', 'XOR D', 'NOP', 'NOP'),
    'FDAB0000': ('DEFB 253', 'XOR E', 'NOP', 'NOP'),
    'FDAC0000': ('XOR IYh', 'NOP', 'NOP'),
    'FDAD0000': ('XOR IYl', 'NOP', 'NOP'),
    'FDAE0000': ('XOR (IY+0)', 'NOP'),
    'FDAF0000': ('DEFB 253', 'XOR A', 'NOP', 'NOP'),
    'FDB00000': ('DEFB 253', 'OR B', 'NOP', 'NOP'),
    'FDB10000': ('DEFB 253', 'OR C', 'NOP', 'NOP'),
    'FDB20000': ('DEFB 253', 'OR D', 'NOP', 'NOP'),
    'FDB30000': ('DEFB 253', 'OR E', 'NOP', 'NOP'),
    'FDB40000': ('OR IYh', 'NOP', 'NOP'),
    'FDB50000': ('OR IYl', 'NOP', 'NOP'),
    'FDB60000': ('OR (IY+0)', 'NOP'),
    'FDB70000': ('DEFB 253', 'OR A', 'NOP', 'NOP'),
    'FDB80000': ('DEFB 253', 'CP B', 'NOP', 'NOP'),
    'FDB90000': ('DEFB 253', 'CP C', 'NOP', 'NOP'),
    'FDBA0000': ('DEFB 253', 'CP D', 'NOP', 'NOP'),
    'FDBB0000': ('DEFB 253', 'CP E', 'NOP', 'NOP'),
    'FDBC0000': ('CP IYh', 'NOP', 'NOP'),
    'FDBD0000': ('CP IYl', 'NOP', 'NOP'),
    'FDBE0000': ('CP (IY+0)', 'NOP'),
    'FDBF0000': ('DEFB 253', 'CP A', 'NOP', 'NOP'),
    'FDC00000': ('DEFB 253', 'RET NZ', 'NOP', 'NOP'),
    'FDC10000': ('DEFB 253', 'POP BC', 'NOP', 'NOP'),
    'FDC20000': ('DEFB 253', 'JP NZ,0'),
    'FDC30000': ('DEFB 253', 'JP 0'),
    'FDC40000': ('DEFB 253', 'CALL NZ,0'),
    'FDC50000': ('DEFB 253', 'PUSH BC', 'NOP', 'NOP'),
    'FDC60000': ('DEFB 253', 'ADD A,0', 'NOP'),
    'FDC70000': ('DEFB 253', 'RST 0', 'NOP', 'NOP'),
    'FDC80000': ('DEFB 253', 'RET Z', 'NOP', 'NOP'),
    'FDC90000': ('DEFB 253', 'RET', 'NOP', 'NOP'),
    'FDCA0000': ('DEFB 253', 'JP Z,0'),
    'FDCB0000': ('DEFB 253,203,0,0',),
    'FDCC0000': ('DEFB 253', 'CALL Z,0'),
    'FDCD0000': ('DEFB 253', 'CALL 0'),
    'FDCE0000': ('DEFB 253', 'ADC A,0', 'NOP'),
    'FDCF0000': ('DEFB 253', 'RST 8', 'NOP', 'NOP'),
    'FDD00000': ('DEFB 253', 'RET NC', 'NOP', 'NOP'),
    'FDD10000': ('DEFB 253', 'POP DE', 'NOP', 'NOP'),
    'FDD20000': ('DEFB 253', 'JP NC,0'),
    'FDD30000': ('DEFB 253', 'OUT (0),A', 'NOP'),
    'FDD40000': ('DEFB 253', 'CALL NC,0'),
    'FDD50000': ('DEFB 253', 'PUSH DE', 'NOP', 'NOP'),
    'FDD60000': ('DEFB 253', 'SUB 0', 'NOP'),
    'FDD70000': ('DEFB 253', 'RST 16', 'NOP', 'NOP'),
    'FDD80000': ('DEFB 253', 'RET C', 'NOP', 'NOP'),
    'FDD90000': ('DEFB 253', 'EXX', 'NOP', 'NOP'),
    'FDDA0000': ('DEFB 253', 'JP C,0'),
    'FDDB0000': ('DEFB 253', 'IN A,(0)', 'NOP'),
    'FDDC0000': ('DEFB 253', 'CALL C,0'),
    'FDDD0000': ('DEFB 253', 'DEFB 221', 'NOP', 'NOP'),
    'FDDE0000': ('DEFB 253', 'SBC A,0', 'NOP'),
    'FDDF0000': ('DEFB 253', 'RST 24', 'NOP', 'NOP'),
    'FDE00000': ('DEFB 253', 'RET PO', 'NOP', 'NOP'),
    'FDE10000': ('POP IY', 'NOP', 'NOP'),
    'FDE20000': ('DEFB 253', 'JP PO,0'),
    'FDE30000': ('EX (SP),IY', 'NOP', 'NOP'),
    'FDE40000': ('DEFB 253', 'CALL PO,0'),
    'FDE50000': ('PUSH IY', 'NOP', 'NOP'),
    'FDE60000': ('DEFB 253', 'AND 0', 'NOP'),
    'FDE70000': ('DEFB 253', 'RST 32', 'NOP', 'NOP'),
    'FDE80000': ('DEFB 253', 'RET PE', 'NOP', 'NOP'),
    'FDE90000': ('JP (IY)', 'NOP', 'NOP'),
    'FDEA0000': ('DEFB 253', 'JP PE,0'),
    'FDEB0000': ('DEFB 253', 'EX DE,HL', 'NOP', 'NOP'),
    'FDEC0000': ('DEFB 253', 'CALL PE,0'),
    'FDED0000': ('DEFB 253', 'DEFB 237,0', 'NOP'),
    'FDEE0000': ('DEFB 253', 'XOR 0', 'NOP'),
    'FDEF0000': ('DEFB 253', 'RST 40', 'NOP', 'NOP'),
    'FDF00000': ('DEFB 253', 'RET P', 'NOP', 'NOP'),
    'FDF10000': ('DEFB 253', 'POP AF', 'NOP', 'NOP'),
    'FDF20000': ('DEFB 253', 'JP P,0'),
    'FDF30000': ('DEFB 253', 'DI', 'NOP', 'NOP'),
    'FDF40000': ('DEFB 253', 'CALL P,0'),
    'FDF50000': ('DEFB 253', 'PUSH AF', 'NOP', 'NOP'),
    'FDF60000': ('DEFB 253', 'OR 0', 'NOP'),
    'FDF70000': ('DEFB 253', 'RST 48', 'NOP', 'NOP'),
    'FDF80000': ('DEFB 253', 'RET M', 'NOP', 'NOP'),
    'FDF90000': ('LD SP,IY', 'NOP', 'NOP'),
    'FDFA0000': ('DEFB 253', 'JP M,0'),
    'FDFB0000': ('DEFB 253', 'EI', 'NOP', 'NOP'),
    'FDFC0000': ('DEFB 253', 'CALL M,0'),
    'FDFD0000': ('DEFB 253', 'DEFB 253', 'NOP', 'NOP'),
    'FDFE0000': ('DEFB 253', 'CP 0', 'NOP'),
    'FDFF0000': ('DEFB 253', 'RST 56', 'NOP', 'NOP'),
    'DDCB0100': ('DEFB 221,203,1,0',),
    'DDCB0101': ('DEFB 221,203,1,1',),
    'DDCB0102': ('DEFB 221,203,1,2',),
    'DDCB0103': ('DEFB 221,203,1,3',),
    'DDCB0104': ('DEFB 221,203,1,4',),
    'DDCB0105': ('DEFB 221,203,1,5',),
    'DDCBFF06': ('RLC (IX-1)',),
    'DDCB0107': ('DEFB 221,203,1,7',),
    'DDCB0108': ('DEFB 221,203,1,8',),
    'DDCB0109': ('DEFB 221,203,1,9',),
    'DDCB010A': ('DEFB 221,203,1,10',),
    'DDCB010B': ('DEFB 221,203,1,11',),
    'DDCB010C': ('DEFB 221,203,1,12',),
    'DDCB010D': ('DEFB 221,203,1,13',),
    'DDCBFF0E': ('RRC (IX-1)',),
    'DDCB010F': ('DEFB 221,203,1,15',),
    'DDCB0110': ('DEFB 221,203,1,16',),
    'DDCB0111': ('DEFB 221,203,1,17',),
    'DDCB0112': ('DEFB 221,203,1,18',),
    'DDCB0113': ('DEFB 221,203,1,19',),
    'DDCB0114': ('DEFB 221,203,1,20',),
    'DDCB0115': ('DEFB 221,203,1,21',),
    'DDCB0116': ('RL (IX+1)',),
    'DDCB0117': ('DEFB 221,203,1,23',),
    'DDCB0118': ('DEFB 221,203,1,24',),
    'DDCB0119': ('DEFB 221,203,1,25',),
    'DDCB011A': ('DEFB 221,203,1,26',),
    'DDCB011B': ('DEFB 221,203,1,27',),
    'DDCB011C': ('DEFB 221,203,1,28',),
    'DDCB011D': ('DEFB 221,203,1,29',),
    'DDCB011E': ('RR (IX+1)',),
    'DDCB011F': ('DEFB 221,203,1,31',),
    'DDCB0120': ('DEFB 221,203,1,32',),
    'DDCB0121': ('DEFB 221,203,1,33',),
    'DDCB0122': ('DEFB 221,203,1,34',),
    'DDCB0123': ('DEFB 221,203,1,35',),
    'DDCB0124': ('DEFB 221,203,1,36',),
    'DDCB0125': ('DEFB 221,203,1,37',),
    'DDCB0126': ('SLA (IX+1)',),
    'DDCB0127': ('DEFB 221,203,1,39',),
    'DDCB0128': ('DEFB 221,203,1,40',),
    'DDCB0129': ('DEFB 221,203,1,41',),
    'DDCB012A': ('DEFB 221,203,1,42',),
    'DDCB012B': ('DEFB 221,203,1,43',),
    'DDCB012C': ('DEFB 221,203,1,44',),
    'DDCB012D': ('DEFB 221,203,1,45',),
    'DDCB012E': ('SRA (IX+1)',),
    'DDCB012F': ('DEFB 221,203,1,47',),
    'DDCB0130': ('DEFB 221,203,1,48',),
    'DDCB0131': ('DEFB 221,203,1,49',),
    'DDCB0132': ('DEFB 221,203,1,50',),
    'DDCB0133': ('DEFB 221,203,1,51',),
    'DDCB0134': ('DEFB 221,203,1,52',),
    'DDCB0135': ('DEFB 221,203,1,53',),
    'DDCB0136': ('SLL (IX+1)',),
    'DDCB0137': ('DEFB 221,203,1,55',),
    'DDCB0138': ('DEFB 221,203,1,56',),
    'DDCB0139': ('DEFB 221,203,1,57',),
    'DDCB013A': ('DEFB 221,203,1,58',),
    'DDCB013B': ('DEFB 221,203,1,59',),
    'DDCB013C': ('DEFB 221,203,1,60',),
    'DDCB013D': ('DEFB 221,203,1,61',),
    'DDCB013E': ('SRL (IX+1)',),
    'DDCB013F': ('DEFB 221,203,1,63',),
    'DDCB0140': ('DEFB 221,203,1,64',),
    'DDCB0141': ('DEFB 221,203,1,65',),
    'DDCB0142': ('DEFB 221,203,1,66',),
    'DDCB0143': ('DEFB 221,203,1,67',),
    'DDCB0144': ('DEFB 221,203,1,68',),
    'DDCB0145': ('DEFB 221,203,1,69',),
    'DDCB0146': ('BIT 0,(IX+1)',),
    'DDCB0147': ('DEFB 221,203,1,71',),
    'DDCB0148': ('DEFB 221,203,1,72',),
    'DDCB0149': ('DEFB 221,203,1,73',),
    'DDCB014A': ('DEFB 221,203,1,74',),
    'DDCB014B': ('DEFB 221,203,1,75',),
    'DDCB014C': ('DEFB 221,203,1,76',),
    'DDCB014D': ('DEFB 221,203,1,77',),
    'DDCB014E': ('BIT 1,(IX+1)',),
    'DDCB014F': ('DEFB 221,203,1,79',),
    'DDCB0150': ('DEFB 221,203,1,80',),
    'DDCB0151': ('DEFB 221,203,1,81',),
    'DDCB0152': ('DEFB 221,203,1,82',),
    'DDCB0153': ('DEFB 221,203,1,83',),
    'DDCB0154': ('DEFB 221,203,1,84',),
    'DDCB0155': ('DEFB 221,203,1,85',),
    'DDCB0156': ('BIT 2,(IX+1)',),
    'DDCB0157': ('DEFB 221,203,1,87',),
    'DDCB0158': ('DEFB 221,203,1,88',),
    'DDCB0159': ('DEFB 221,203,1,89',),
    'DDCB015A': ('DEFB 221,203,1,90',),
    'DDCB015B': ('DEFB 221,203,1,91',),
    'DDCB015C': ('DEFB 221,203,1,92',),
    'DDCB015D': ('DEFB 221,203,1,93',),
    'DDCB015E': ('BIT 3,(IX+1)',),
    'DDCB015F': ('DEFB 221,203,1,95',),
    'DDCB0160': ('DEFB 221,203,1,96',),
    'DDCB0161': ('DEFB 221,203,1,97',),
    'DDCB0162': ('DEFB 221,203,1,98',),
    'DDCB0163': ('DEFB 221,203,1,99',),
    'DDCB0164': ('DEFB 221,203,1,100',),
    'DDCB0165': ('DEFB 221,203,1,101',),
    'DDCB0166': ('BIT 4,(IX+1)',),
    'DDCB0167': ('DEFB 221,203,1,103',),
    'DDCB0168': ('DEFB 221,203,1,104',),
    'DDCB0169': ('DEFB 221,203,1,105',),
    'DDCB016A': ('DEFB 221,203,1,106',),
    'DDCB016B': ('DEFB 221,203,1,107',),
    'DDCB016C': ('DEFB 221,203,1,108',),
    'DDCB016D': ('DEFB 221,203,1,109',),
    'DDCB016E': ('BIT 5,(IX+1)',),
    'DDCB016F': ('DEFB 221,203,1,111',),
    'DDCB0170': ('DEFB 221,203,1,112',),
    'DDCB0171': ('DEFB 221,203,1,113',),
    'DDCB0172': ('DEFB 221,203,1,114',),
    'DDCB0173': ('DEFB 221,203,1,115',),
    'DDCB0174': ('DEFB 221,203,1,116',),
    'DDCB0175': ('DEFB 221,203,1,117',),
    'DDCB0176': ('BIT 6,(IX+1)',),
    'DDCB0177': ('DEFB 221,203,1,119',),
    'DDCB0178': ('DEFB 221,203,1,120',),
    'DDCB0179': ('DEFB 221,203,1,121',),
    'DDCB017A': ('DEFB 221,203,1,122',),
    'DDCB017B': ('DEFB 221,203,1,123',),
    'DDCB017C': ('DEFB 221,203,1,124',),
    'DDCB017D': ('DEFB 221,203,1,125',),
    'DDCB017E': ('BIT 7,(IX+1)',),
    'DDCB017F': ('DEFB 221,203,1,127',),
    'DDCB0180': ('DEFB 221,203,1,128',),
    'DDCB0181': ('DEFB 221,203,1,129',),
    'DDCB0182': ('DEFB 221,203,1,130',),
    'DDCB0183': ('DEFB 221,203,1,131',),
    'DDCB0184': ('DEFB 221,203,1,132',),
    'DDCB0185': ('DEFB 221,203,1,133',),
    'DDCB0186': ('RES 0,(IX+1)',),
    'DDCB0187': ('DEFB 221,203,1,135',),
    'DDCB0188': ('DEFB 221,203,1,136',),
    'DDCB0189': ('DEFB 221,203,1,137',),
    'DDCB018A': ('DEFB 221,203,1,138',),
    'DDCB018B': ('DEFB 221,203,1,139',),
    'DDCB018C': ('DEFB 221,203,1,140',),
    'DDCB018D': ('DEFB 221,203,1,141',),
    'DDCB018E': ('RES 1,(IX+1)',),
    'DDCB018F': ('DEFB 221,203,1,143',),
    'DDCB0190': ('DEFB 221,203,1,144',),
    'DDCB0191': ('DEFB 221,203,1,145',),
    'DDCB0192': ('DEFB 221,203,1,146',),
    'DDCB0193': ('DEFB 221,203,1,147',),
    'DDCB0194': ('DEFB 221,203,1,148',),
    'DDCB0195': ('DEFB 221,203,1,149',),
    'DDCB0196': ('RES 2,(IX+1)',),
    'DDCB0197': ('DEFB 221,203,1,151',),
    'DDCB0198': ('DEFB 221,203,1,152',),
    'DDCB0199': ('DEFB 221,203,1,153',),
    'DDCB019A': ('DEFB 221,203,1,154',),
    'DDCB019B': ('DEFB 221,203,1,155',),
    'DDCB019C': ('DEFB 221,203,1,156',),
    'DDCB019D': ('DEFB 221,203,1,157',),
    'DDCB019E': ('RES 3,(IX+1)',),
    'DDCB019F': ('DEFB 221,203,1,159',),
    'DDCB01A0': ('DEFB 221,203,1,160',),
    'DDCB01A1': ('DEFB 221,203,1,161',),
    'DDCB01A2': ('DEFB 221,203,1,162',),
    'DDCB01A3': ('DEFB 221,203,1,163',),
    'DDCB01A4': ('DEFB 221,203,1,164',),
    'DDCB01A5': ('DEFB 221,203,1,165',),
    'DDCB01A6': ('RES 4,(IX+1)',),
    'DDCB01A7': ('DEFB 221,203,1,167',),
    'DDCB01A8': ('DEFB 221,203,1,168',),
    'DDCB01A9': ('DEFB 221,203,1,169',),
    'DDCB01AA': ('DEFB 221,203,1,170',),
    'DDCB01AB': ('DEFB 221,203,1,171',),
    'DDCB01AC': ('DEFB 221,203,1,172',),
    'DDCB01AD': ('DEFB 221,203,1,173',),
    'DDCB01AE': ('RES 5,(IX+1)',),
    'DDCB01AF': ('DEFB 221,203,1,175',),
    'DDCB01B0': ('DEFB 221,203,1,176',),
    'DDCB01B1': ('DEFB 221,203,1,177',),
    'DDCB01B2': ('DEFB 221,203,1,178',),
    'DDCB01B3': ('DEFB 221,203,1,179',),
    'DDCB01B4': ('DEFB 221,203,1,180',),
    'DDCB01B5': ('DEFB 221,203,1,181',),
    'DDCB01B6': ('RES 6,(IX+1)',),
    'DDCB01B7': ('DEFB 221,203,1,183',),
    'DDCB01B8': ('DEFB 221,203,1,184',),
    'DDCB01B9': ('DEFB 221,203,1,185',),
    'DDCB01BA': ('DEFB 221,203,1,186',),
    'DDCB01BB': ('DEFB 221,203,1,187',),
    'DDCB01BC': ('DEFB 221,203,1,188',),
    'DDCB01BD': ('DEFB 221,203,1,189',),
    'DDCB01BE': ('RES 7,(IX+1)',),
    'DDCB01BF': ('DEFB 221,203,1,191',),
    'DDCB01C0': ('DEFB 221,203,1,192',),
    'DDCB01C1': ('DEFB 221,203,1,193',),
    'DDCB01C2': ('DEFB 221,203,1,194',),
    'DDCB01C3': ('DEFB 221,203,1,195',),
    'DDCB01C4': ('DEFB 221,203,1,196',),
    'DDCB01C5': ('DEFB 221,203,1,197',),
    'DDCB01C6': ('SET 0,(IX+1)',),
    'DDCB01C7': ('DEFB 221,203,1,199',),
    'DDCB01C8': ('DEFB 221,203,1,200',),
    'DDCB01C9': ('DEFB 221,203,1,201',),
    'DDCB01CA': ('DEFB 221,203,1,202',),
    'DDCB01CB': ('DEFB 221,203,1,203',),
    'DDCB01CC': ('DEFB 221,203,1,204',),
    'DDCB01CD': ('DEFB 221,203,1,205',),
    'DDCB01CE': ('SET 1,(IX+1)',),
    'DDCB01CF': ('DEFB 221,203,1,207',),
    'DDCB01D0': ('DEFB 221,203,1,208',),
    'DDCB01D1': ('DEFB 221,203,1,209',),
    'DDCB01D2': ('DEFB 221,203,1,210',),
    'DDCB01D3': ('DEFB 221,203,1,211',),
    'DDCB01D4': ('DEFB 221,203,1,212',),
    'DDCB01D5': ('DEFB 221,203,1,213',),
    'DDCB01D6': ('SET 2,(IX+1)',),
    'DDCB01D7': ('DEFB 221,203,1,215',),
    'DDCB01D8': ('DEFB 221,203,1,216',),
    'DDCB01D9': ('DEFB 221,203,1,217',),
    'DDCB01DA': ('DEFB 221,203,1,218',),
    'DDCB01DB': ('DEFB 221,203,1,219',),
    'DDCB01DC': ('DEFB 221,203,1,220',),
    'DDCB01DD': ('DEFB 221,203,1,221',),
    'DDCB01DE': ('SET 3,(IX+1)',),
    'DDCB01DF': ('DEFB 221,203,1,223',),
    'DDCB01E0': ('DEFB 221,203,1,224',),
    'DDCB01E1': ('DEFB 221,203,1,225',),
    'DDCB01E2': ('DEFB 221,203,1,226',),
    'DDCB01E3': ('DEFB 221,203,1,227',),
    'DDCB01E4': ('DEFB 221,203,1,228',),
    'DDCB01E5': ('DEFB 221,203,1,229',),
    'DDCB01E6': ('SET 4,(IX+1)',),
    'DDCB01E7': ('DEFB 221,203,1,231',),
    'DDCB01E8': ('DEFB 221,203,1,232',),
    'DDCB01E9': ('DEFB 221,203,1,233',),
    'DDCB01EA': ('DEFB 221,203,1,234',),
    'DDCB01EB': ('DEFB 221,203,1,235',),
    'DDCB01EC': ('DEFB 221,203,1,236',),
    'DDCB01ED': ('DEFB 221,203,1,237',),
    'DDCB01EE': ('SET 5,(IX+1)',),
    'DDCB01EF': ('DEFB 221,203,1,239',),
    'DDCB01F0': ('DEFB 221,203,1,240',),
    'DDCB01F1': ('DEFB 221,203,1,241',),
    'DDCB01F2': ('DEFB 221,203,1,242',),
    'DDCB01F3': ('DEFB 221,203,1,243',),
    'DDCB01F4': ('DEFB 221,203,1,244',),
    'DDCB01F5': ('DEFB 221,203,1,245',),
    'DDCB01F6': ('SET 6,(IX+1)',),
    'DDCB01F7': ('DEFB 221,203,1,247',),
    'DDCB01F8': ('DEFB 221,203,1,248',),
    'DDCB01F9': ('DEFB 221,203,1,249',),
    'DDCB01FA': ('DEFB 221,203,1,250',),
    'DDCB01FB': ('DEFB 221,203,1,251',),
    'DDCB01FC': ('DEFB 221,203,1,252',),
    'DDCB01FD': ('DEFB 221,203,1,253',),
    'DDCB01FE': ('SET 7,(IX+1)',),
    'DDCB01FF': ('DEFB 221,203,1,255',),
    'FDCB0100': ('DEFB 253,203,1,0',),
    'FDCB0101': ('DEFB 253,203,1,1',),
    'FDCB0102': ('DEFB 253,203,1,2',),
    'FDCB0103': ('DEFB 253,203,1,3',),
    'FDCB0104': ('DEFB 253,203,1,4',),
    'FDCB0105': ('DEFB 253,203,1,5',),
    'FDCBFF06': ('RLC (IY-1)',),
    'FDCB0107': ('DEFB 253,203,1,7',),
    'FDCB0108': ('DEFB 253,203,1,8',),
    'FDCB0109': ('DEFB 253,203,1,9',),
    'FDCB010A': ('DEFB 253,203,1,10',),
    'FDCB010B': ('DEFB 253,203,1,11',),
    'FDCB010C': ('DEFB 253,203,1,12',),
    'FDCB010D': ('DEFB 253,203,1,13',),
    'FDCBFF0E': ('RRC (IY-1)',),
    'FDCB010F': ('DEFB 253,203,1,15',),
    'FDCB0110': ('DEFB 253,203,1,16',),
    'FDCB0111': ('DEFB 253,203,1,17',),
    'FDCB0112': ('DEFB 253,203,1,18',),
    'FDCB0113': ('DEFB 253,203,1,19',),
    'FDCB0114': ('DEFB 253,203,1,20',),
    'FDCB0115': ('DEFB 253,203,1,21',),
    'FDCB0116': ('RL (IY+1)',),
    'FDCB0117': ('DEFB 253,203,1,23',),
    'FDCB0118': ('DEFB 253,203,1,24',),
    'FDCB0119': ('DEFB 253,203,1,25',),
    'FDCB011A': ('DEFB 253,203,1,26',),
    'FDCB011B': ('DEFB 253,203,1,27',),
    'FDCB011C': ('DEFB 253,203,1,28',),
    'FDCB011D': ('DEFB 253,203,1,29',),
    'FDCB011E': ('RR (IY+1)',),
    'FDCB011F': ('DEFB 253,203,1,31',),
    'FDCB0120': ('DEFB 253,203,1,32',),
    'FDCB0121': ('DEFB 253,203,1,33',),
    'FDCB0122': ('DEFB 253,203,1,34',),
    'FDCB0123': ('DEFB 253,203,1,35',),
    'FDCB0124': ('DEFB 253,203,1,36',),
    'FDCB0125': ('DEFB 253,203,1,37',),
    'FDCB0126': ('SLA (IY+1)',),
    'FDCB0127': ('DEFB 253,203,1,39',),
    'FDCB0128': ('DEFB 253,203,1,40',),
    'FDCB0129': ('DEFB 253,203,1,41',),
    'FDCB012A': ('DEFB 253,203,1,42',),
    'FDCB012B': ('DEFB 253,203,1,43',),
    'FDCB012C': ('DEFB 253,203,1,44',),
    'FDCB012D': ('DEFB 253,203,1,45',),
    'FDCB012E': ('SRA (IY+1)',),
    'FDCB012F': ('DEFB 253,203,1,47',),
    'FDCB0130': ('DEFB 253,203,1,48',),
    'FDCB0131': ('DEFB 253,203,1,49',),
    'FDCB0132': ('DEFB 253,203,1,50',),
    'FDCB0133': ('DEFB 253,203,1,51',),
    'FDCB0134': ('DEFB 253,203,1,52',),
    'FDCB0135': ('DEFB 253,203,1,53',),
    'FDCB0136': ('SLL (IY+1)',),
    'FDCB0137': ('DEFB 253,203,1,55',),
    'FDCB0138': ('DEFB 253,203,1,56',),
    'FDCB0139': ('DEFB 253,203,1,57',),
    'FDCB013A': ('DEFB 253,203,1,58',),
    'FDCB013B': ('DEFB 253,203,1,59',),
    'FDCB013C': ('DEFB 253,203,1,60',),
    'FDCB013D': ('DEFB 253,203,1,61',),
    'FDCB013E': ('SRL (IY+1)',),
    'FDCB013F': ('DEFB 253,203,1,63',),
    'FDCB0140': ('DEFB 253,203,1,64',),
    'FDCB0141': ('DEFB 253,203,1,65',),
    'FDCB0142': ('DEFB 253,203,1,66',),
    'FDCB0143': ('DEFB 253,203,1,67',),
    'FDCB0144': ('DEFB 253,203,1,68',),
    'FDCB0145': ('DEFB 253,203,1,69',),
    'FDCB0146': ('BIT 0,(IY+1)',),
    'FDCB0147': ('DEFB 253,203,1,71',),
    'FDCB0148': ('DEFB 253,203,1,72',),
    'FDCB0149': ('DEFB 253,203,1,73',),
    'FDCB014A': ('DEFB 253,203,1,74',),
    'FDCB014B': ('DEFB 253,203,1,75',),
    'FDCB014C': ('DEFB 253,203,1,76',),
    'FDCB014D': ('DEFB 253,203,1,77',),
    'FDCB014E': ('BIT 1,(IY+1)',),
    'FDCB014F': ('DEFB 253,203,1,79',),
    'FDCB0150': ('DEFB 253,203,1,80',),
    'FDCB0151': ('DEFB 253,203,1,81',),
    'FDCB0152': ('DEFB 253,203,1,82',),
    'FDCB0153': ('DEFB 253,203,1,83',),
    'FDCB0154': ('DEFB 253,203,1,84',),
    'FDCB0155': ('DEFB 253,203,1,85',),
    'FDCB0156': ('BIT 2,(IY+1)',),
    'FDCB0157': ('DEFB 253,203,1,87',),
    'FDCB0158': ('DEFB 253,203,1,88',),
    'FDCB0159': ('DEFB 253,203,1,89',),
    'FDCB015A': ('DEFB 253,203,1,90',),
    'FDCB015B': ('DEFB 253,203,1,91',),
    'FDCB015C': ('DEFB 253,203,1,92',),
    'FDCB015D': ('DEFB 253,203,1,93',),
    'FDCB015E': ('BIT 3,(IY+1)',),
    'FDCB015F': ('DEFB 253,203,1,95',),
    'FDCB0160': ('DEFB 253,203,1,96',),
    'FDCB0161': ('DEFB 253,203,1,97',),
    'FDCB0162': ('DEFB 253,203,1,98',),
    'FDCB0163': ('DEFB 253,203,1,99',),
    'FDCB0164': ('DEFB 253,203,1,100',),
    'FDCB0165': ('DEFB 253,203,1,101',),
    'FDCB0166': ('BIT 4,(IY+1)',),
    'FDCB0167': ('DEFB 253,203,1,103',),
    'FDCB0168': ('DEFB 253,203,1,104',),
    'FDCB0169': ('DEFB 253,203,1,105',),
    'FDCB016A': ('DEFB 253,203,1,106',),
    'FDCB016B': ('DEFB 253,203,1,107',),
    'FDCB016C': ('DEFB 253,203,1,108',),
    'FDCB016D': ('DEFB 253,203,1,109',),
    'FDCB016E': ('BIT 5,(IY+1)',),
    'FDCB016F': ('DEFB 253,203,1,111',),
    'FDCB0170': ('DEFB 253,203,1,112',),
    'FDCB0171': ('DEFB 253,203,1,113',),
    'FDCB0172': ('DEFB 253,203,1,114',),
    'FDCB0173': ('DEFB 253,203,1,115',),
    'FDCB0174': ('DEFB 253,203,1,116',),
    'FDCB0175': ('DEFB 253,203,1,117',),
    'FDCB0176': ('BIT 6,(IY+1)',),
    'FDCB0177': ('DEFB 253,203,1,119',),
    'FDCB0178': ('DEFB 253,203,1,120',),
    'FDCB0179': ('DEFB 253,203,1,121',),
    'FDCB017A': ('DEFB 253,203,1,122',),
    'FDCB017B': ('DEFB 253,203,1,123',),
    'FDCB017C': ('DEFB 253,203,1,124',),
    'FDCB017D': ('DEFB 253,203,1,125',),
    'FDCB017E': ('BIT 7,(IY+1)',),
    'FDCB017F': ('DEFB 253,203,1,127',),
    'FDCB0180': ('DEFB 253,203,1,128',),
    'FDCB0181': ('DEFB 253,203,1,129',),
    'FDCB0182': ('DEFB 253,203,1,130',),
    'FDCB0183': ('DEFB 253,203,1,131',),
    'FDCB0184': ('DEFB 253,203,1,132',),
    'FDCB0185': ('DEFB 253,203,1,133',),
    'FDCB0186': ('RES 0,(IY+1)',),
    'FDCB0187': ('DEFB 253,203,1,135',),
    'FDCB0188': ('DEFB 253,203,1,136',),
    'FDCB0189': ('DEFB 253,203,1,137',),
    'FDCB018A': ('DEFB 253,203,1,138',),
    'FDCB018B': ('DEFB 253,203,1,139',),
    'FDCB018C': ('DEFB 253,203,1,140',),
    'FDCB018D': ('DEFB 253,203,1,141',),
    'FDCB018E': ('RES 1,(IY+1)',),
    'FDCB018F': ('DEFB 253,203,1,143',),
    'FDCB0190': ('DEFB 253,203,1,144',),
    'FDCB0191': ('DEFB 253,203,1,145',),
    'FDCB0192': ('DEFB 253,203,1,146',),
    'FDCB0193': ('DEFB 253,203,1,147',),
    'FDCB0194': ('DEFB 253,203,1,148',),
    'FDCB0195': ('DEFB 253,203,1,149',),
    'FDCB0196': ('RES 2,(IY+1)',),
    'FDCB0197': ('DEFB 253,203,1,151',),
    'FDCB0198': ('DEFB 253,203,1,152',),
    'FDCB0199': ('DEFB 253,203,1,153',),
    'FDCB019A': ('DEFB 253,203,1,154',),
    'FDCB019B': ('DEFB 253,203,1,155',),
    'FDCB019C': ('DEFB 253,203,1,156',),
    'FDCB019D': ('DEFB 253,203,1,157',),
    'FDCB019E': ('RES 3,(IY+1)',),
    'FDCB019F': ('DEFB 253,203,1,159',),
    'FDCB01A0': ('DEFB 253,203,1,160',),
    'FDCB01A1': ('DEFB 253,203,1,161',),
    'FDCB01A2': ('DEFB 253,203,1,162',),
    'FDCB01A3': ('DEFB 253,203,1,163',),
    'FDCB01A4': ('DEFB 253,203,1,164',),
    'FDCB01A5': ('DEFB 253,203,1,165',),
    'FDCB01A6': ('RES 4,(IY+1)',),
    'FDCB01A7': ('DEFB 253,203,1,167',),
    'FDCB01A8': ('DEFB 253,203,1,168',),
    'FDCB01A9': ('DEFB 253,203,1,169',),
    'FDCB01AA': ('DEFB 253,203,1,170',),
    'FDCB01AB': ('DEFB 253,203,1,171',),
    'FDCB01AC': ('DEFB 253,203,1,172',),
    'FDCB01AD': ('DEFB 253,203,1,173',),
    'FDCB01AE': ('RES 5,(IY+1)',),
    'FDCB01AF': ('DEFB 253,203,1,175',),
    'FDCB01B0': ('DEFB 253,203,1,176',),
    'FDCB01B1': ('DEFB 253,203,1,177',),
    'FDCB01B2': ('DEFB 253,203,1,178',),
    'FDCB01B3': ('DEFB 253,203,1,179',),
    'FDCB01B4': ('DEFB 253,203,1,180',),
    'FDCB01B5': ('DEFB 253,203,1,181',),
    'FDCB01B6': ('RES 6,(IY+1)',),
    'FDCB01B7': ('DEFB 253,203,1,183',),
    'FDCB01B8': ('DEFB 253,203,1,184',),
    'FDCB01B9': ('DEFB 253,203,1,185',),
    'FDCB01BA': ('DEFB 253,203,1,186',),
    'FDCB01BB': ('DEFB 253,203,1,187',),
    'FDCB01BC': ('DEFB 253,203,1,188',),
    'FDCB01BD': ('DEFB 253,203,1,189',),
    'FDCB01BE': ('RES 7,(IY+1)',),
    'FDCB01BF': ('DEFB 253,203,1,191',),
    'FDCB01C0': ('DEFB 253,203,1,192',),
    'FDCB01C1': ('DEFB 253,203,1,193',),
    'FDCB01C2': ('DEFB 253,203,1,194',),
    'FDCB01C3': ('DEFB 253,203,1,195',),
    'FDCB01C4': ('DEFB 253,203,1,196',),
    'FDCB01C5': ('DEFB 253,203,1,197',),
    'FDCB01C6': ('SET 0,(IY+1)',),
    'FDCB01C7': ('DEFB 253,203,1,199',),
    'FDCB01C8': ('DEFB 253,203,1,200',),
    'FDCB01C9': ('DEFB 253,203,1,201',),
    'FDCB01CA': ('DEFB 253,203,1,202',),
    'FDCB01CB': ('DEFB 253,203,1,203',),
    'FDCB01CC': ('DEFB 253,203,1,204',),
    'FDCB01CD': ('DEFB 253,203,1,205',),
    'FDCB01CE': ('SET 1,(IY+1)',),
    'FDCB01CF': ('DEFB 253,203,1,207',),
    'FDCB01D0': ('DEFB 253,203,1,208',),
    'FDCB01D1': ('DEFB 253,203,1,209',),
    'FDCB01D2': ('DEFB 253,203,1,210',),
    'FDCB01D3': ('DEFB 253,203,1,211',),
    'FDCB01D4': ('DEFB 253,203,1,212',),
    'FDCB01D5': ('DEFB 253,203,1,213',),
    'FDCB01D6': ('SET 2,(IY+1)',),
    'FDCB01D7': ('DEFB 253,203,1,215',),
    'FDCB01D8': ('DEFB 253,203,1,216',),
    'FDCB01D9': ('DEFB 253,203,1,217',),
    'FDCB01DA': ('DEFB 253,203,1,218',),
    'FDCB01DB': ('DEFB 253,203,1,219',),
    'FDCB01DC': ('DEFB 253,203,1,220',),
    'FDCB01DD': ('DEFB 253,203,1,221',),
    'FDCB01DE': ('SET 3,(IY+1)',),
    'FDCB01DF': ('DEFB 253,203,1,223',),
    'FDCB01E0': ('DEFB 253,203,1,224',),
    'FDCB01E1': ('DEFB 253,203,1,225',),
    'FDCB01E2': ('DEFB 253,203,1,226',),
    'FDCB01E3': ('DEFB 253,203,1,227',),
    'FDCB01E4': ('DEFB 253,203,1,228',),
    'FDCB01E5': ('DEFB 253,203,1,229',),
    'FDCB01E6': ('SET 4,(IY+1)',),
    'FDCB01E7': ('DEFB 253,203,1,231',),
    'FDCB01E8': ('DEFB 253,203,1,232',),
    'FDCB01E9': ('DEFB 253,203,1,233',),
    'FDCB01EA': ('DEFB 253,203,1,234',),
    'FDCB01EB': ('DEFB 253,203,1,235',),
    'FDCB01EC': ('DEFB 253,203,1,236',),
    'FDCB01ED': ('DEFB 253,203,1,237',),
    'FDCB01EE': ('SET 5,(IY+1)',),
    'FDCB01EF': ('DEFB 253,203,1,239',),
    'FDCB01F0': ('DEFB 253,203,1,240',),
    'FDCB01F1': ('DEFB 253,203,1,241',),
    'FDCB01F2': ('DEFB 253,203,1,242',),
    'FDCB01F3': ('DEFB 253,203,1,243',),
    'FDCB01F4': ('DEFB 253,203,1,244',),
    'FDCB01F5': ('DEFB 253,203,1,245',),
    'FDCB01F6': ('SET 6,(IY+1)',),
    'FDCB01F7': ('DEFB 253,203,1,247',),
    'FDCB01F8': ('DEFB 253,203,1,248',),
    'FDCB01F9': ('DEFB 253,203,1,249',),
    'FDCB01FA': ('DEFB 253,203,1,250',),
    'FDCB01FB': ('DEFB 253,203,1,251',),
    'FDCB01FC': ('DEFB 253,203,1,252',),
    'FDCB01FD': ('DEFB 253,203,1,253',),
    'FDCB01FE': ('SET 7,(IY+1)',),
    'FDCB01FF': ('DEFB 253,203,1,255',),
}

class DisassemblerTest(SkoolKitTestCase):
    def _get_disassembler(self, snapshot=(), defb_size=8, defb_mod=8, zfill=False, defm_width=66, asm_hex=False, asm_lower=False):
        return Disassembler(snapshot, defb_size, defb_mod, zfill, defm_width, asm_hex, asm_lower)

    def _get_snapshot(self, start, data):
        snapshot = [0] * 65539
        snapshot[start:start + len(data)] = list(data)
        return snapshot

    def _get_instructions(self, *data):
        start = 65536 - len(data)
        snapshot = self._get_snapshot(start, data)
        disassembler = self._get_disassembler(snapshot)
        return disassembler.disassemble(start)

    def defbs_equal(self, *data):
        instructions = self._get_instructions(*data)
        self.assertEqual(len(instructions), 1)
        self.assertEqual(instructions[0].operation, 'DEFB {0}'.format(','.join([str(b) for b in data])))

    def test_all_instructions(self):
        sna_prefix = [0] * 16384
        for hex_bytes, ops in ASM.items():
            snapshot = sna_prefix + [int(hex_bytes[i:i + 2], 16) for i in range(0, len(hex_bytes), 2)]
            disassembler = self._get_disassembler(snapshot)
            instructions = disassembler.disassemble(len(sna_prefix), len(snapshot))
            operations = tuple([inst.operation for inst in instructions])
            self.assertEqual(operations, ops)

    def test_jr1(self):
        # 65535 JR d
        self.defbs_equal(24)

    def test_jr2(self):
        # 65534 JR 65537
        self.defbs_equal(24, 1)

    def test_jp1(self):
        # 65535 JP nn
        self.defbs_equal(195)

    def test_jp2(self):
        # 65534 JP nn
        self.defbs_equal(195, 0)

    def test_call1(self):
        # 65535 CALL nn
        self.defbs_equal(205)

    def test_call2(self):
        # 65534 CALL nn
        self.defbs_equal(205, 0)

    def test_cb(self):
        # 65535 CB
        self.defbs_equal(203)

    def test_ed(self):
        # 65535 ED
        self.defbs_equal(237)

    def test_dd(self):
        # 65535 DD
        self.defbs_equal(221)

    def test_fd(self):
        # 65535 FD
        self.defbs_equal(253)

    def test_ddcb1(self):
        # 65534 DDCB
        self.defbs_equal(221, 203)

    def test_fdcb1(self):
        # 65534 FDCB
        self.defbs_equal(253, 203)

    def test_ddcb2(self):
        # 65533 DDCB
        self.defbs_equal(221, 203, 6)

    def test_fdcb2(self):
        # 65533 FDCB
        self.defbs_equal(253, 203, 6)

    def test_dded1(self):
        # 65534 DDED
        # This disassembles to two instructions: the disassembler knows that ED
        # is unaffected by a DD prefix, but when it sees DD, it doesn't know
        # that there will be no suffix after ED
        instructions = self._get_instructions(221, 237)
        self.assertEqual(len(instructions), 2)
        self.assertEqual(instructions[0].operation, 'DEFB 221')
        self.assertEqual(instructions[1].operation, 'DEFB 237')

    def test_dded2(self):
        # 65533 DDED4300
        # This disassembles to two instructions: the disassembler knows that ED
        # is unaffected by a DD prefix, but when it sees DD, it doesn't know
        # that there will be no room for the 2-byte suffix after ED43
        instructions = self._get_instructions(221, 237, 67, 0)
        self.assertEqual(len(instructions), 2)
        self.assertEqual(instructions[0].operation, 'DEFB 221')
        self.assertEqual(instructions[1].operation, 'DEFB 237,67,0')

    def test_defb_range(self):
        snapshot = self._get_snapshot(32768, (97, 98, 99, 94, 96, 65, 66, 67, 127))
        disassembler = self._get_disassembler(snapshot)

        instructions = disassembler.defb_range(32768, 32777)
        self.assertEqual(len(instructions), 2)
        operations = [i.operation for i in instructions]
        self.assertEqual(operations, ['DEFB 97,98,99,94,96,65,66,67', 'DEFB 127'])

        sublengths = [(3, 'T'), (2, None), (3, 'T'), (1, None)]
        instructions = disassembler.defb_range(32768, 32777, sublengths=sublengths)
        self.assertEqual(len(instructions), 1)
        self.assertEqual(instructions[0].operation, 'DEFB "abc",94,96,"ABC",127')

        sublengths = [(3, 'T'), (2, 'B'), (3, 'X'), (1, None)]
        instructions = disassembler.defb_range(32768, 32777, sublengths=sublengths)
        self.assertEqual(len(instructions), 1)
        self.assertEqual(instructions[0].operation, 'DEFB "abc",94,96,"ABC",127')

    def test_defm_range(self):
        snapshot = self._get_snapshot(32768, (97, 98, 99, 94, 96, 65, 66, 67, 127))
        disassembler = self._get_disassembler(snapshot)

        instructions = disassembler.defm_range(32768, 32771)
        self.assertEqual(len(instructions), 1)
        self.assertEqual(instructions[0].operation, 'DEFM "abc"')

        instructions = disassembler.defm_range(32768, 32777)
        self.assertEqual(len(instructions), 5)
        operations = [i.operation for i in instructions]
        self.assertEqual(operations, ['DEFM "abc"', 'DEFB 94', 'DEFB 96', 'DEFM "ABC"', 'DEFB 127'])

        sublengths = [(3, None), (2, 'B'), (3, None), (1, 'B')]
        instructions = disassembler.defm_range(32768, 32777, sublengths=sublengths)
        self.assertEqual(len(instructions), 1)
        self.assertEqual(instructions[0].operation, 'DEFM "abc",94,96,"ABC",127')

        sublengths = [(3, 'T'), (2, 'X'), (3, None), (1, 'B')]
        instructions = disassembler.defm_range(32768, 32777, sublengths=sublengths)
        self.assertEqual(len(instructions), 1)
        self.assertEqual(instructions[0].operation, 'DEFM "abc",94,96,"ABC",127')

    def test_defm_line(self):
        disassembler = self._get_disassembler()

        instruction = disassembler.defm_line(0, [34, 72, 101, 108, 108, 111, 34])
        self.assertEqual(instruction.operation, r'DEFM "\"Hello\""')

        instruction = disassembler.defm_line(0, [67, 58, 92, 84, 69, 77, 80])
        self.assertEqual(instruction.operation, r'DEFM "C:\\TEMP"')

    def test_defw_range(self):
        start = 32768
        data = [1, 0, 1, 1, 2, 2, 3, 255]
        snapshot = self._get_snapshot(start, data)
        disassembler = self._get_disassembler(snapshot)
        
        instructions = disassembler.defw_range(start, start + len(data), False)
        self.assertEqual(len(instructions), 4)
        i = 0
        for address in range(start, start + len(data), 2):
            defw = instructions[i]
            defw_data = data[i * 2:i * 2 + 2]
            self.assertEqual(defw.address, address)
            self.assertEqual(defw.operation, 'DEFW {0}'.format(defw_data[0] + 256 * defw_data[1]))
            self.assertEqual(defw.bytes, defw_data)
            i += 1

        instructions = disassembler.defw_range(start, start + len(data), True)
        self.assertEqual(len(instructions), 1)
        defw = instructions[0]
        self.assertEqual(defw.address, start)
        self.assertEqual(defw.operation, 'DEFW 1,257,514,65283')
        self.assertEqual(defw.bytes, data)

    def test_num_str(self):
        disassembler = self._get_disassembler(asm_hex=False)
        self.assertEqual(disassembler.num_str(123), '123')

        disassembler = self._get_disassembler(asm_hex=True)
        self.assertEqual(disassembler.num_str(5), '5')
        self.assertEqual(disassembler.num_str(10), '$0A')
        self.assertEqual(disassembler.num_str(256), '$0100')
        self.assertEqual(disassembler.num_str(5, 1), '$05')
        self.assertEqual(disassembler.num_str(10, 1), '$0A')
        self.assertEqual(disassembler.num_str(5, 2), '$0005')
        self.assertEqual(disassembler.num_str(10, 2), '$000A')
        self.assertEqual(disassembler.num_str(256, 2), '$0100')

if __name__ == '__main__':
    unittest.main()
