#!/usr/bin/env python
# -*- mode:python; tab-width: 2; coding: utf-8 -*-

"""
resource

Represents a generic gateway to AMQP implementation
"""

from __future__ import absolute_import

__author__ = "caelum - http://caelum.com.br"
__modified_by__  = "Carlos Martin <cmartin@liberalia.net>"
__license__ = "See LICENSE.restfulie for details"

# Import here any required modules.

__all__ = ['Resource']

# Project requirements

# local submodule requirements

class ResourceError(Exception):
    """Resource exception"""

#pylint: disable-msg=R0921
class Resource(object):
    """Prepares a connection. only get a pika connection is lazy created"""

    def __getitem__(self, key):
        raise NotImplementedError
        
    def links(self):
        """Returns a list of all links."""
        raise NotImplementedError

    def link(self, rel, default=None):
        """Return a Link with rel."""
        raise NotImplementedError

    def error(self):
        """
        Return error if any or None if no error is present or isn't
        suported by format
        """
        return None
