#!/usr/bin/env python
#
# Copyright 2010 Andrey Churin. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

import os

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

here = os.path.abspath(os.path.dirname(__file__))

try:
    README = open(os.path.join(here, 'README.txt')).read().strip()
except IOError:
    README = ''
    
try:
    CHANGES = open(os.path.join(here, 'CHANGES.txt')).read().strip()    
except IOError:    
    CHANGES = ''

requires = [
    'pyramid',
    'colander',
]
    
setup(
    name='smallform',
    version='0.1',
    description='Smallform is very small and simple form utility for Pyramid',
    long_description=README + '\n\n' +  CHANGES,
    classifiers=[
        'Programming Language :: Python',
        'Framework :: Pylons',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: WSGI :: Application',
        'License :: OSI Approved :: Apache Software License',
        'Operating System :: OS Independent',
        ],
    author='Andrey Churin',
    author_email='aachurin@gmail.com',
    keywords='web pyramid pylons form colander',
    packages=['smallform'],
    package_dir={'smallform': 'smallform'},
    zip_safe=False,
    include_package_data=True,
    license='LICENSE.txt',
    install_requires=requires,
    )

