import networkx as net
import matplotlib.pyplot as plot
from collections import defaultdict

def plot_multimode(m,layout=net.circular_layout, type_string='type',with_labels=True, font_size=12, filename_prefix='',output_type='pdf'):
#### Plot a wheel-diagram
    colors=['r','g','b','c','m','y','k']
    colormap={}
    d=net.degree(m)
    pos=layout(m)
    nodesets=defaultdict(list)
    for n in m.nodes():
        try:
            t=m.node[n][type_string]
        except KeyError:
            ##this happens if a node doesn't have a type_string -- give it a None value
            t='None'
        nodesets[t].append(n)
    print "drawing nodes..."
    i=0
    for key in nodesets.keys():
        ns=[d[n]*100 for n in nodesets[key]]
        net.draw_networkx_nodes(m,pos,nodelist=nodesets[key], node_size=ns, node_color=colors[i], alpha=0.6)
        colormap[key]=colors[i]
        i+=1
        if i==len(colors): 
            i=0  ### wrap around the colormap if we run out of colors
    print colormap  
    
    print "drawing edges..."
    net.draw_networkx_edges(m,pos,width=0.5,alpha=0.5)   
    
    if with_labels:
        net.draw_networkx_labels(m,pos,font_size=font_size)
    
    plot.axis('off')
    if filename_prefix is not '':
        plot.savefig(filename_prefix+'.'+output_type)