#!/usr/bin/env python

"""SockJSProxy - Proxy SockJS message to/from ZeroMQ PUB/SUB sockets.

See the `samples/datereply-sjp.py` file for an example client.

Development Status :: 4 - Beta
Intended Audience :: Developers
License :: OSI Approved :: MIT License
Programming Language :: Python
Topic :: Database
Topic :: Software Development :: Libraries :: Python Modules
Operating System :: Microsoft :: Windows
Operating System :: Unix
"""

desc, long_desc, classifiers = __doc__.split("\n\n")

from setuptools import setup

setup(name='sockjsproxy',
      version='0.4',
      author='Emil Ivanov',
      author_email='emil.vladev@gmail.com',
      url='https://bitbucket.org/vladev/sockjsproxy',
      packages=['sockjsproxy'],
      install_requires=['pyzmq',
                        'sockjs-tornado'
      ],
      scripts=['sockjsproxy/sockjsproxy.py',
               'sockjsproxy/samples/datereply-sjp.py'],
      license='MIT',
      description=desc,
      classifiers=[c for c in classifiers.split("\n") if c],
      long_description=long_desc
)
