#!/usr/bin/env
# -*- coding: utf-8 -*-
import os
import fnmatch

from distutils.core import setup
from setuptools import find_packages

with open('.gitignore', 'r') as g:
    ignore_patterns = [l.strip('\n') for l in g.readlines() if not
                       l.startswith('#') and not l == '' and not l == '\n']

with open('requirements.txt', 'r') as r:
    requirements = [l.strip('\n') for l in r.readlines()]

with open('README.rst', 'r') as r:
    long_desc = r.read()

exclude_data = {p: ignore_patterns for p in find_packages()}
exclude_data.update({'': ignore_patterns})


def get_package_data(rel, *dirs):
    files = []

    for directory in dirs:
        for cwd, dirs, filenames in os.walk(directory):
            path, dirname = os.path.split(cwd)
            if dirname.startswith(('.', '_')):
                continue

            for fname in filenames:
                bad_file = False
                for pattern in ignore_patterns:
                    if fnmatch.fnmatch(fname, pattern):
                        bad_file = True
                        break

                if not bad_file:
                    path = os.path.relpath(os.path.join(cwd, fname), rel)
                    files.append(path)

    return files


setup_params = {
    'author': 'kuyan',
    'author_email': 'kuyanatan.nlao@gmail.com',
    'classifiers': [
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python',
        'Topic :: Software Development'
    ],
    'description': 'Really lightweight web prototyping.',
    'entry_points': {'console_scripts': ['shovel=soil.shovel:run_main']},
    'exclude_package_data': exclude_data,
    'install_requires': requirements,
    'license': 'LICENSE.txt',
    'long_description': long_desc,
    'name': 'soil',
    'packages': find_packages(),
    'package_data': {
        'soil': get_package_data('soil', 'soil/skeleton'),
        'soil.test': get_package_data('soil/test', 'soil/test/test_project')
    },
    'url': 'https://github.com/kuyan/soil',
    'version': '0.1.2-dev',
    'zip_safe': False,
}

setup(**setup_params)
