# -*- coding: utf-8 -*-
"""
    soil.test.extensions.test_contextadditions
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    Contains tests for the ContextAdditions extension.

    :copyright: (c) 2012 by Natan Lao.
    :license: BSD, see LICENSE for more details.
"""
import os

from soil.test.fixtures import new_soil_app


def inject_ext_data(new_soil_app):
    """Adds information necessary to test the ContextAdditions extension
    to the project.
    """
    project = new_soil_app.projdir

    with open(os.path.join(project, 'soilcfg.py'), 'a') as cfg:
        cfg.write('extensions = ["soil.extensions.ContextAdditions"]')

    with open(os.path.join(project, 'templates', 'index.html'), 'w') as t:
        t.write('{{ test_context_additions() }}')

    with open(os.path.join(project, 'ctx_additions.py'), 'w') as py:
        py.write('def test_context_additions(): return "how do i lock on"')


def test_proj_building(new_soil_app):
    """Tests if names that are supposed to be inserted into Jinja2's context
    are inserted and can be used.
    """
    soil_app = new_soil_app
    inject_ext_data(soil_app)
    soil_app.build()

    bld_dir = soil_app.config['directories']['build'][1]

    with open(os.path.join(bld_dir, 'index.html'), 'r') as index:
        assert index.read() == "how do i lock on"
