# -*- coding: utf-8 -*-
"""
    soil.test.test_serving
    ~~~~~~~~~~~~~~~~~~~~~~

    Contains tests for the Werkzeug Soil application.

    :copyright: (c) 2012 by Natan Lao.
    :license: BSD, see LICENSE for more details.
"""
import os

from soil.serving import create_app
from soil.test.fixtures import test_proj_dir
from soil import Soil

from werkzeug.test import Client
from werkzeug.wsgi import SharedDataMiddleware
from werkzeug.wrappers import BaseResponse, Response


class TestServer:
    """Contains test cases for testing the Werkzeug soil application."""

    def setup_method(self, method):
        self.soil = Soil(test_proj_dir)
        # Replicate '/static' functionality
        self.app = SharedDataMiddleware(create_app(self.soil.projdir), {
            '/static': self.soil.config['directories']['static'][1]
            })

        self.c = Client(self.app, BaseResponse)

    def test_error_404(self):
        """Tests if 404 errors are being caught correctly."""
        resp = self.c.get(os.urandom(24))
        assert resp.status_code == 404
        assert resp.data == 'test: 404, page not found'

    def test_static_files(self):
        """Tests if static files are being served correctly."""
        resp = self.c.get('/static/test')
        assert resp.status_code == 200
        assert "they're called sausage links" in resp.data

    def test_page_serving(self):
        """Tests is normal pages are being served correctly."""
        resp = self.c.get('/testpage.html')
        template = self.soil.render_template('testpage.html')

        assert resp.data == Response(template, mimetype='text/html').data

    def test_index(self):
        """Tests if index rules ('/' vs '/index.html') are being added
        correctly.
        """
        resp1 = self.c.get('/')
        resp2 = self.c.get('/index.html')
        assert resp1.data == resp2.data

    def test_ignore(self):
        """Tests if pages are supposed to be ignored are correctly ignored."""
        resp = self.c.get('_base.html')
        assert resp.status_code == 404
