# -*- coding: utf-8 -*-
"""
    soil.util
    ~~~~~~~~~

    Various utilities used throughout soil.

    :copyright: (c) 2012 by Natan Lao.
    :license: BSD, see LICENSE for more details.
"""
import os
from termcolor import colored

#: Dictionary with operation statuses
status = {
    'create':       colored('      create', 'green'),
    'exists':       colored('   identical', 'cyan'),
    'conflict':     colored('    conflict', 'red', attrs=['bold']),
    'overwrite':    colored('   overwrite', 'yellow', attrs=['bold']),
    'skip':         colored('        skip', 'yellow', attrs=['bold']),
    'success':      colored('     success', 'green'),
    'error':        colored('       error', 'red', attrs=['bold']),
}

#: Path to the application skeleton
skeleton_path = os.path.join(os.path.dirname(__file__), 'skeleton')
skeleton_path = os.path.realpath(skeleton_path)


def getattr_nested(name):
    """Performs a nested `getattr`.
    :param name: name of the package to import
    """
    split = name.split('.')

    try:
        ext = __import__(name)
    except ImportError as e:
        if len(split) == 2:
            ext = __import__(split[0])
            ext = getattr(ext, split[1])
            return ext
        else:
            raise e

    for attr in split[1:]:
        ext = getattr(ext, attr)

    return ext
