# -*- coding: utf-8 -*-
"""
    soil.extensions.ContextAdditions
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    Extension that allows adding names to the Jinja context for use in
    templates.
    Intended for minimal use- if you find yourself requiring a bit more
    space/organization than a single ctx_additions.py requires, then
    that's a sign that you might want to use something other than soil
    (like Flask) to prototype your site instead.

    :copyright: (c) 2012 by Natan Lao.
    :license: BSD, see LICENSE for more details.
"""
import imp
import os

from soil.util import getattr_nested


class ContextAdditionExtension(object):
    """Implements the ContextAddition extension."""
    def __init__(self, soil_instance):
        self.soil = soil_instance

        self.path = os.path.join(self.soil.projdir, 'ctx_additions.py')
        self.path = os.path.realpath(self.path)

        entry_points = {'pre': self.inject}
        self.soil.register_ext_entry_points(entry_points)
        self.soil.watched_files.append(self.path)

    def inject(self):
        """Injects names defined in ctx_additions.py into the Jinja2 context.
        """
        if not os.path.exists(self.path):
            return

        ctx_additions = imp.load_source('ctx_additions', self.path)
        ctx_adds_name = ctx_additions.__name__
        ctx_additions = {k: getattr_nested('.'.join([ctx_adds_name, k]))
                         for k in dir(ctx_additions) if not k.startswith('_')}
        self.soil.jinja_context.update(ctx_additions)
        return
