# -*- coding: utf-8 -*-
"""
    soil.test.test_config
    ~~~~~~~~~~~~~~~~~~~~~

    Contains tests for configuration.

    :copyright: (c) 2012 by Natan Lao.
    :license: BSD, see LICENSE for more details.
"""
import os.path
from soil.test.fixtures import soil_app, test_project


def test_config(soil_app):
    """Tests if coniguration is being imported properly."""
    listen_addr = ('123.456.789.123', 2314)
    assert soil_app.config['listen_addr'][0] == listen_addr[0]
    assert len(soil_app.config['error_pages']) == 2


def test_config_dirs(soil_app):
    """Tests if absolute paths are being added by `soil.core.Soil.load_config`
    properly."""
    for k, v in soil_app.config['directories'].iteritems():
        path0 = os.path.join(soil_app.projdir, v[0])
        assert os.path.samefile(path0, v[1])
