# -*- coding: utf-8 -*-
# soilcfg.py - configuration for `soil`

# listen_addr - the address the server will listen for new connections on
# e.g.: ('127.0.0.1', 5000)
listen_addr = ('127.0.0.1', 5000)

# jinja_opts - parameters passed to the underlying jinja environment object
# Full list of possible parameters at:
#     http://jinja.pocoo.org/docs/api/#jinja2.Environment
# e.g.:
#   jinja_opts = {
#       'parameter': 'value'
#   }
jinja_opts = {
    'extensions': [
        'jinja2.ext.with_',
        'jinja2.ext.autoescape'
    ]
}

# directories - defines locations of directories used by soil. All paths are
#               relative to the project directory (that is, the directory that
#               this file is located in)
# There are three possible keys for this option:
#   'templates': where soil will look for templates
#   'static': the directory in which static files are kept
#   'build': where soil will deposit the built templates
directories = {
    'templates': 'templates/',
    'static': 'static/',
    'build': 'build/'
}

# extensions - list of extensions to use
# e.g.: extensions = ['package.of.SoilExtension']
extensions = ['soil.extensions.ContextAdditions']

# error_pages - paths of error pages relative to the 'templates' directory.
# These are only used when the project is run through `shovel run`.
# If an error template cannot be found, the server will fall back onto the
# page for error 500.
# e.g.:
#   error_pages = {
#       error_code_as_int: 'path/to/template/relative/to/template/dir.html'
#   }
error_pages = {
    404: 'error/404.html',
    500: 'error/500.html'
}

# templates_ignore - regex of templates to skip
# The regular expression will only be applied to the filename (and not the
# combined directory and filename) of the template.
templates_ignore = '^_|^\.'
