from __future__ import absolute_import

__author__ = "ardevelop"

import urllib

try:
    import ujson as json
except ImportError:
    import json

from tornado.httpclient import HTTPRequest

try:
    from tornado.curl_httpclient import CurlAsyncHTTPClient as AsyncHTTPClient
except ImportError:
    from tornado.httpclient import AsyncHTTPClient


class TornadoAsyncSolrClient(object):
    def __init__(self, url):
        self.url = url.strip('/')
        self.update_url = self.url + '/update'
        self.update_url_with_commit = self.url + '/update?commit=true'
        self.select_url = self.url + '/select'
        self.client = AsyncHTTPClient()

    def request(self, verb, url, obj=None, callback=None):
        def _callback(response):
            if 200 == response.code:
                callback(json.loads(response.body))
            else:
                raise response.error

        request = HTTPRequest(url, verb, {'Content-Type': 'application/json'},
                              json.dumps(obj) if obj else None, use_gzip=True)
        self.client.fetch(request, _callback)

    def select(self, query, callback=None, **kwargs):
        kwargs['q'] = query
        kwargs['wt'] = 'json'
        self.request('GET', "%s?%s" % (self.select_url, urllib.urlencode(kwargs, 1)), callback=callback)

    def add(self, callback=None, **fields):
        self.request('POST', self.update_url, {"add": {"doc": fields}}, callback)

    def update(self, doc_id, commit=False, callback=None, **fields):
        data = {'id': doc_id}
        for field, value in fields.items():
            data[field] = {'set': value}
        self.request('POST', self.update_url_with_commit if commit else self.update_url, [data], callback)

    def delete_doc(self, doc_id, callback=None):
        self.request('POST', self.update_url, {"delete": {"id": doc_id}}, callback)

    def delete_query(self, query, callback=None):
        self.request('POST', self.update_url, {"delete": {"query": query}}, callback)
