/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import edu.stanford.nlp.io.BZip2PipedOutputStream;
import edu.stanford.nlp.io.EncodingFileReader;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StreamGobbler;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IOUtils {
    private static final int SLURPBUFFSIZE = 16000;
    public static final String eolChar = System.getProperty("line.separator");
    private static final String defaultEnc = "utf-8";
    private static final Pattern tab = Pattern.compile("\t");

    private IOUtils() {
    }

    public static File writeObjectToFile(Object o, String filename) throws IOException {
        return IOUtils.writeObjectToFile(o, new File(filename));
    }

    public static File writeObjectToFile(Object o, File file) throws IOException {
        return IOUtils.writeObjectToFile(o, file, false);
    }

    public static File writeObjectToFile(Object o, File file, boolean append) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file, append))));
        oos.writeObject(o);
        oos.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeObjectToFileNoExceptions(Object o, String filename) {
        File file = null;
        ObjectOutputStream oos = null;
        try {
            file = new File(filename);
            oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
            oos.writeObject(o);
            oos.close();
            IOUtils.closeIgnoringExceptions(oos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeIgnoringExceptions(oos);
        }
        return file;
    }

    public static File writeObjectToTempFile(Object o, String filename) throws IOException {
        File file = File.createTempFile(filename, ".tmp");
        file.deleteOnExit();
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
        oos.writeObject(o);
        oos.close();
        return file;
    }

    public static File writeObjectToTempFileNoExceptions(Object o, String filename) {
        try {
            return IOUtils.writeObjectToTempFile(o, filename);
        }
        catch (Exception e) {
            System.err.println("Error writing object to file " + filename);
            e.printStackTrace();
            return null;
        }
    }

    public static void writeStringToFile(String contents, String path, String encoding) throws IOException {
        FilterOutputStream writer = null;
        writer = path.endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(path)) : new BufferedOutputStream(new FileOutputStream(path));
        ((OutputStream)writer).write(contents.getBytes(encoding));
    }

    public static void writeStringToFile(String contents, String path) throws IOException {
        IOUtils.writeStringToFile(contents, path, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeStringToFileNoExceptions(String contents, String path, String encoding) {
        FilterOutputStream writer = null;
        try {
            writer = path.endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(path)) : new BufferedOutputStream(new FileOutputStream(path));
            ((OutputStream)writer).write(contents.getBytes(encoding));
            if (writer == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (writer != null) {
                IOUtils.closeIgnoringExceptions(writer);
            }
        }
        IOUtils.closeIgnoringExceptions(writer);
        return;
    }

    public static void writeStringToFileNoExceptions(String contents, String path) {
        IOUtils.writeStringToFileNoExceptions(contents, path, "UTF-8");
    }

    public static File writeStringToTempFile(String contents, String path, String encoding) throws IOException {
        FilterOutputStream writer = null;
        File tmp = File.createTempFile(path, ".tmp");
        writer = path.endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(tmp)) : new BufferedOutputStream(new FileOutputStream(tmp));
        ((OutputStream)writer).write(contents.getBytes(encoding));
        return tmp;
    }

    public static void writeStringToTempFile(String contents, String path) throws IOException {
        IOUtils.writeStringToTempFile(contents, path, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File writeStringToTempFileNoExceptions(String contents, String path, String encoding) {
        FilterOutputStream writer = null;
        File tmp = null;
        try {
            tmp = File.createTempFile(path, ".tmp");
            writer = path.endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(tmp)) : new BufferedOutputStream(new FileOutputStream(tmp));
            ((OutputStream)writer).write(contents.getBytes(encoding));
            if (writer == null) return tmp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return tmp;
        }
        finally {
            if (writer != null) {
                IOUtils.closeIgnoringExceptions(writer);
            }
        }
        IOUtils.closeIgnoringExceptions(writer);
        return tmp;
    }

    public static void writeStringToTempFileNoExceptions(String contents, String path) {
        IOUtils.writeStringToTempFileNoExceptions(contents, path, "UTF-8");
    }

    public static <T> T readObjectFromFile(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        Object o = ois.readObject();
        ois.close();
        return ErasureUtils.uncheckedCast(o);
    }

    public static <T> T readObjectFromObjectStream(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object o = ois.readObject();
        return ErasureUtils.uncheckedCast(o);
    }

    public static <T> T readObjectFromFile(String filename) throws IOException, ClassNotFoundException {
        return ErasureUtils.uncheckedCast(IOUtils.readObjectFromFile(new File(filename)));
    }

    public static <T> T readObjectFromFileNoExceptions(File file) {
        Object o = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
            o = ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return ErasureUtils.uncheckedCast(o);
    }

    public static int lineCount(File textFile) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(textFile));
        int numLines = 0;
        while (r.readLine() != null) {
            ++numLines;
        }
        return numLines;
    }

    public static ObjectOutputStream writeStreamFromString(String serializePath) throws IOException {
        ObjectOutputStream oos = serializePath.endsWith(".gz") ? new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(serializePath)))) : new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(serializePath)));
        return oos;
    }

    public static ObjectInputStream readStreamFromString(String filenameOrUrl) throws IOException {
        InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(filenameOrUrl);
        ObjectInputStream in = new ObjectInputStream(is);
        return in;
    }

    private static InputStream findStreamInClasspathOrFileSystem(String fn) throws FileNotFoundException {
        InputStream is = IOUtils.class.getClassLoader().getResourceAsStream(fn);
        if (is == null) {
            is = IOUtils.class.getClassLoader().getResourceAsStream(fn.replaceAll("\\\\", "/"));
        }
        if (is == null) {
            is = new FileInputStream(fn);
        }
        return is;
    }

    public static InputStream getInputStreamFromURLOrClasspathOrFileSystem(String textFileOrUrl) throws IOException {
        InputStream in;
        if (textFileOrUrl.matches("https?://.*")) {
            URL u = new URL(textFileOrUrl);
            URLConnection uc = u.openConnection();
            in = uc.getInputStream();
        } else {
            try {
                in = IOUtils.findStreamInClasspathOrFileSystem(textFileOrUrl);
            }
            catch (FileNotFoundException e) {
                try {
                    URL u = new URL(textFileOrUrl);
                    URLConnection uc = u.openConnection();
                    in = uc.getInputStream();
                }
                catch (IOException e2) {
                    throw new IOException("Unable to resolve \"" + textFileOrUrl + "\" as either " + "class path, filename or URL", e2);
                }
            }
        }
        in = new BufferedInputStream(in);
        if (textFileOrUrl.endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public static BufferedReader readReaderFromString(String textFileOrUrl) throws IOException {
        return new BufferedReader(new InputStreamReader(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(textFileOrUrl)));
    }

    public static BufferedReader readReaderFromString(String textFileOrUrl, String encoding) throws IOException {
        InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(textFileOrUrl);
        return new BufferedReader(new InputStreamReader(is, encoding));
    }

    public static Iterable<String> readLines(String path) {
        return IOUtils.readLines(new File(path));
    }

    public static Iterable<String> readLines(File file) {
        return IOUtils.readLines(file, null);
    }

    public static Iterable<String> readLines(final File file, final Class<? extends InputStream> fileInputStreamWrapper) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    protected BufferedReader reader = this.getReader();
                    protected String line = this.getLine();

                    @Override
                    public boolean hasNext() {
                        return this.line != null;
                    }

                    @Override
                    public String next() {
                        String nextLine = this.line;
                        if (nextLine == null) {
                            throw new NoSuchElementException();
                        }
                        this.line = this.getLine();
                        return nextLine;
                    }

                    protected String getLine() {
                        try {
                            String result = this.reader.readLine();
                            if (result == null) {
                                this.reader.close();
                            }
                            return result;
                        }
                        catch (IOException e) {
                            throw new RuntimeIOException(e);
                        }
                    }

                    protected BufferedReader getReader() {
                        try {
                            InputStream stream = new FileInputStream(file);
                            if (fileInputStreamWrapper != null) {
                                stream = (InputStream)fileInputStreamWrapper.getConstructor(InputStream.class).newInstance(stream);
                            }
                            return new BufferedReader(new InputStreamReader(stream));
                        }
                        catch (Exception e) {
                            throw new RuntimeIOException(e);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static InputStream openFile(File file) throws RuntimeIOException {
        try {
            FilterInputStream is = new BufferedInputStream(new FileInputStream(file));
            if (file.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            return is;
        }
        catch (Exception e) {
            throw new RuntimeIOException(e);
        }
    }

    public static void closeIgnoringExceptions(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Iterable<File> iterFilesRecursive(File dir) {
        return IOUtils.iterFilesRecursive(dir, (Pattern)null);
    }

    public static Iterable<File> iterFilesRecursive(File dir, String ext) {
        return IOUtils.iterFilesRecursive(dir, Pattern.compile(Pattern.quote(ext) + "$"));
    }

    public static Iterable<File> iterFilesRecursive(final File dir, final Pattern pattern) {
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new AbstractIterator<File>(){
                    private final Queue<File> files;
                    private File file;
                    {
                        this.files = new LinkedList<File>(Collections.singleton(dir));
                        this.file = this.findNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.file != null;
                    }

                    @Override
                    public File next() {
                        File result = this.file;
                        if (result == null) {
                            throw new NoSuchElementException();
                        }
                        this.file = this.findNext();
                        return result;
                    }

                    private File findNext() {
                        File next = null;
                        while (!this.files.isEmpty() && next == null) {
                            next = this.files.remove();
                            if (next.isDirectory()) {
                                this.files.addAll(Arrays.asList(next.listFiles()));
                                next = null;
                                continue;
                            }
                            if (pattern == null || pattern.matcher(next.getPath()).find()) continue;
                            next = null;
                        }
                        return next;
                    }
                };
            }
        };
    }

    public static String slurpFile(File file) throws IOException {
        FileReader r = new FileReader(file);
        return IOUtils.slurpReader(r);
    }

    public static String slurpFile(File file, String encoding) throws IOException {
        return IOUtils.slurpReader(IOUtils.encodedInputStreamReader(new FileInputStream(file), encoding));
    }

    public static String slurpGZippedFile(String filename) throws IOException {
        InputStreamReader r = new InputStreamReader(new GZIPInputStream(new FileInputStream(filename)));
        return IOUtils.slurpReader(r);
    }

    public static String slurpGZippedFile(File file) throws IOException {
        InputStreamReader r = new InputStreamReader(new GZIPInputStream(new FileInputStream(file)));
        return IOUtils.slurpReader(r);
    }

    public static String slurpGBFileNoExceptions(String filename) {
        return IOUtils.slurpFileNoExceptions(filename, "GB18030");
    }

    public static String slurpFile(String filename, String encoding) throws IOException {
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(filename), encoding);
        return IOUtils.slurpReader(r);
    }

    public static String slurpFileNoExceptions(String filename, String encoding) {
        try {
            return IOUtils.slurpFile(filename, encoding);
        }
        catch (Exception e) {
            throw new RuntimeIOException("slurpFile IO problem", e);
        }
    }

    public static String slurpGBFile(String filename) throws IOException {
        return IOUtils.slurpFile(filename, "GB18030");
    }

    public static String slurpFile(String filename) throws IOException {
        return IOUtils.slurpReader(new FileReader(filename));
    }

    public static String slurpGBURL(URL u) throws IOException {
        return IOUtils.slurpURL(u, "GB18030");
    }

    public static String slurpGBURLNoExceptions(URL u) {
        try {
            return IOUtils.slurpGBURL(u);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURLNoExceptions(URL u, String encoding) {
        try {
            return IOUtils.slurpURL(u, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURL(URL u, String encoding) throws IOException {
        String temp;
        InputStream is;
        String lineSeparator = System.getProperty("line.separator");
        URLConnection uc = u.openConnection();
        uc.setReadTimeout(30000);
        try {
            is = uc.getInputStream();
        }
        catch (SocketTimeoutException e) {
            System.err.println("Time out. Return empty string");
            return "";
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        StringBuilder buff = new StringBuilder(16000);
        while ((temp = br.readLine()) != null) {
            buff.append(temp);
            buff.append(lineSeparator);
        }
        br.close();
        return buff.toString();
    }

    public static String slurpURL(URL u) throws IOException {
        String temp;
        String lineSeparator = System.getProperty("line.separator");
        URLConnection uc = u.openConnection();
        InputStream is = uc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder buff = new StringBuilder(16000);
        while ((temp = br.readLine()) != null) {
            buff.append(temp);
            buff.append(lineSeparator);
        }
        br.close();
        return buff.toString();
    }

    public static String slurpURLNoExceptions(URL u) {
        try {
            return IOUtils.slurpURL(u);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURL(String path) throws Exception {
        return IOUtils.slurpURL(new URL(path));
    }

    public static String slurpURLNoExceptions(String path) {
        try {
            return IOUtils.slurpURL(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpFileNoExceptions(File file) {
        try {
            return IOUtils.slurpReader(new FileReader(file));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpFileNoExceptions(String filename) {
        try {
            return IOUtils.slurpFile(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpReader(Reader reader) {
        BufferedReader r = new BufferedReader(reader);
        StringBuilder buff = new StringBuilder();
        try {
            int amountRead;
            char[] chars = new char[16000];
            while ((amountRead = r.read(chars, 0, 16000)) >= 0) {
                buff.append(chars, 0, amountRead);
            }
            r.close();
        }
        catch (Exception e) {
            throw new RuntimeIOException("slurpReader IO problem", e);
        }
        return buff.toString();
    }

    public static void writeStreamToStream(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = input.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
    }

    public static List<Map<String, String>> readCSVWithHeader(String path, char quoteChar, char escapeChar) throws IOException {
        String[] labels = null;
        ArrayList<Map<String, String>> rows = Generics.newArrayList();
        for (String line : IOUtils.readLines(path)) {
            System.out.println("Splitting " + line);
            if (labels == null) {
                labels = StringUtils.splitOnCharWithQuoting(line, ',', '\"', escapeChar);
                continue;
            }
            String[] cells = StringUtils.splitOnCharWithQuoting(line, ',', quoteChar, escapeChar);
            assert (cells.length == labels.length);
            HashMap<String, String> cellMap = new HashMap<String, String>();
            for (int i = 0; i < labels.length; ++i) {
                cellMap.put(labels[i], cells[i]);
            }
            rows.add(cellMap);
        }
        return rows;
    }

    public static List<Map<String, String>> readCSVWithHeader(String path) throws IOException {
        return IOUtils.readCSVWithHeader(path, '\"', '\"');
    }

    public static LinkedList<String[]> readCSVStrictly(char[] csvContents, int numColumns) {
        StringBuilder[] buffer = new StringBuilder[numColumns];
        buffer[0] = new StringBuilder();
        LinkedList<String[]> lines = new LinkedList<String[]>();
        boolean inQuotes = false;
        boolean nextIsEscaped = false;
        int columnI = 0;
        block6: for (int offset = 0; offset < csvContents.length; ++offset) {
            if (nextIsEscaped) {
                buffer[columnI].append(csvContents[offset]);
                nextIsEscaped = false;
                continue;
            }
            switch (csvContents[offset]) {
                case '\"': {
                    inQuotes = !inQuotes;
                    continue block6;
                }
                case ',': {
                    if (inQuotes) {
                        buffer[columnI].append(',');
                        continue block6;
                    }
                    if (++columnI >= numColumns) {
                        throw new IllegalArgumentException("Too many columns: " + columnI + "/" + numColumns + " (offset: " + offset + ")");
                    }
                    buffer[columnI] = new StringBuilder();
                    continue block6;
                }
                case '\n': {
                    if (inQuotes) {
                        buffer[columnI].append('\n');
                        continue block6;
                    }
                    if (columnI != numColumns - 1) {
                        throw new IllegalArgumentException("Too few columns: " + columnI + "/" + numColumns + " (offset: " + offset + ")");
                    }
                    String[] rtn = new String[buffer.length];
                    for (int i = 0; i < buffer.length; ++i) {
                        rtn[i] = buffer[i].toString();
                    }
                    lines.add(rtn);
                    columnI = 0;
                    buffer[columnI] = new StringBuilder();
                    continue block6;
                }
                case '\\': {
                    nextIsEscaped = true;
                    continue block6;
                }
                default: {
                    buffer[columnI].append(csvContents[offset]);
                }
            }
        }
        return lines;
    }

    public static LinkedList<String[]> readCSVStrictly(String filename, int numColumns) throws IOException {
        return IOUtils.readCSVStrictly(IOUtils.slurpFile(filename).toCharArray(), numColumns);
    }

    public static InputStream getFileInputStream(String filename) throws IOException {
        InputStream in = new FileInputStream(filename);
        if (filename.endsWith(".gz")) {
            in = new GZIPInputStream(in);
        } else if (filename.endsWith(".bz2")) {
            in = IOUtils.getBZip2PipedInputStream(filename);
        }
        return in;
    }

    public static OutputStream getFileOutputStream(String filename) throws IOException {
        OutputStream out2 = new FileOutputStream(filename);
        if (filename.endsWith(".gz")) {
            out2 = new GZIPOutputStream(out2);
        } else if (filename.endsWith(".bz2")) {
            out2 = IOUtils.getBZip2PipedOutputStream(filename);
        }
        return out2;
    }

    public static BufferedReader getBufferedFileReader(String filename) throws IOException {
        return IOUtils.getBufferedFileReader(filename, defaultEnc);
    }

    public static BufferedReader getBufferedFileReader(String filename, String encoding) throws IOException {
        InputStream in = IOUtils.getFileInputStream(filename);
        return new BufferedReader(new InputStreamReader(in, encoding));
    }

    public static PrintWriter getPrintWriter(File textFile) throws IOException {
        File f = textFile.getAbsoluteFile();
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f))));
    }

    public static PrintWriter getPrintWriter(String filename) throws IOException {
        return IOUtils.getPrintWriter(filename, defaultEnc);
    }

    public static PrintWriter getPrintWriter(String filename, String encoding) throws IOException {
        OutputStream out2 = IOUtils.getFileOutputStream(filename);
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(out2, encoding)));
    }

    public static InputStream getBZip2PipedInputStream(String filename) throws IOException {
        String bzcat = System.getProperty("bzcat", "bzcat");
        Runtime rt = Runtime.getRuntime();
        String cmd = bzcat + " " + filename;
        Process p = rt.exec(cmd);
        BufferedWriter errWriter = new BufferedWriter(new OutputStreamWriter(System.err));
        StreamGobbler errGobler = new StreamGobbler(p.getErrorStream(), errWriter);
        errGobler.start();
        return p.getInputStream();
    }

    public static OutputStream getBZip2PipedOutputStream(String filename) throws IOException {
        return new BZip2PipedOutputStream(filename);
    }

    public static Set<String> readColumnSet(String infile, int field) throws IOException {
        String line;
        BufferedReader br = IOUtils.getBufferedFileReader(infile);
        HashSet<String> set = new HashSet<String>();
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            if (field < 0) {
                set.add(line);
                continue;
            }
            String[] fields = tab.split(line);
            if (field >= fields.length) continue;
            set.add(fields[field]);
        }
        br.close();
        return set;
    }

    public static <C> List<C> readObjectFromColumns(Class objClass, String filename, String[] fieldNames, String delimiter) throws IOException, InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        String line;
        Pattern delimiterPattern = Pattern.compile(delimiter);
        ArrayList list = new ArrayList();
        BufferedReader br = IOUtils.getBufferedFileReader(filename);
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            Object item = StringUtils.columnStringToObject(objClass, line, delimiterPattern, fieldNames);
            list.add(item);
        }
        br.close();
        return list;
    }

    public static Map<String, String> readMap(String filename) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String line;
            BufferedReader br = IOUtils.getBufferedFileReader(filename);
            while ((line = br.readLine()) != null) {
                String[] fields = tab.split(line, 2);
                map.put(fields[0], fields[1]);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return map;
    }

    public static String stringFromFile(String filename) {
        return IOUtils.stringFromFile(filename, defaultEnc);
    }

    public static String stringFromFile(String filename, String encoding) {
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            BufferedReader in = new BufferedReader(new EncodingFileReader(filename, encoding));
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append(eolChar);
            }
            in.close();
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> linesFromFile(String filename) {
        return IOUtils.linesFromFile(filename, defaultEnc);
    }

    public static List<String> linesFromFile(String filename, String encoding) {
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader in = new BufferedReader(new EncodingFileReader(filename, encoding));
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
            in.close();
            return lines;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String backupName(String filename) {
        return IOUtils.backupFile(new File(filename)).toString();
    }

    public static File backupFile(File file) {
        int max = 1000;
        String filename = file.toString();
        File backup = new File(filename + "~");
        if (!backup.exists()) {
            return backup;
        }
        for (int i = 1; i <= max; ++i) {
            backup = new File(filename + ".~" + i + ".~");
            if (backup.exists()) continue;
            return backup;
        }
        return null;
    }

    public static boolean renameToBackupName(File file) {
        return file.renameTo(IOUtils.backupFile(file));
    }

    public static File getJNLPLocalScratch() {
        try {
            String machineName = InetAddress.getLocalHost().getHostName().split("\\.")[0];
            String username = System.getProperty("user.name");
            return new File("/" + machineName + "/scr1/" + username);
        }
        catch (Exception e) {
            return new File("./scr/");
        }
    }

    public static File ensureDir(File tgtDir) throws IOException {
        if (tgtDir.exists()) {
            if (tgtDir.isDirectory()) {
                return tgtDir;
            }
            throw new IOException("Could not create directory " + tgtDir.getAbsolutePath() + ", as a file already exists at that path.");
        }
        tgtDir.mkdirs();
        return tgtDir;
    }

    public static void main(String[] args) {
        System.out.println(IOUtils.backupName(args[0]));
    }

    public static String getExtension(String fileName) {
        if (!fileName.contains(".")) {
            return null;
        }
        int idx = fileName.lastIndexOf(46);
        return fileName.substring(idx + 1);
    }

    public static Reader encodedInputStreamReader(InputStream stream, String encoding) throws IOException {
        if (encoding == null) {
            return new InputStreamReader(stream);
        }
        return new InputStreamReader(stream, encoding);
    }

    public static Writer encodedOutputStreamWriter(OutputStream stream, String encoding) throws IOException {
        if (encoding == null) {
            return new OutputStreamWriter(stream);
        }
        return new OutputStreamWriter(stream, encoding);
    }

    public static PrintWriter encodedOutputStreamPrintWriter(OutputStream stream, String encoding, boolean autoFlush) throws IOException {
        if (encoding == null) {
            return new PrintWriter(stream, autoFlush);
        }
        return new PrintWriter((Writer)new OutputStreamWriter(stream, encoding), autoFlush);
    }
}

