/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.AnnotationLookup;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.HasCategory;
import edu.stanford.nlp.ling.HasContext;
import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.ling.HasOffset;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.TypesafeMap;
import java.util.HashMap;
import java.util.Set;

public class CoreLabel
extends ArrayCoreMap
implements Label,
HasWord,
HasTag,
HasCategory,
HasContext,
HasIndex,
HasOffset {
    private static final long serialVersionUID = 2L;
    public static HashMap<String, Class<? extends GenericAnnotation>> genericKeys = new HashMap();
    public static HashMap<Class<? extends GenericAnnotation>, String> genericValues = new HashMap();
    public static final String TAG_SEPARATOR = "/";

    public CoreLabel() {
    }

    public CoreLabel(int capacity) {
        super(capacity);
    }

    public CoreLabel(CoreLabel label) {
        this((CoreMap)label);
    }

    public CoreLabel(CoreMap label) {
        super(label.size());
        Set<Class<?>> otherKeys = label.keySet();
        for (Class<?> key : otherKeys) {
            this.set(key, label.get(key));
        }
    }

    public CoreLabel(Label label) {
        super(1);
        if (label instanceof CoreMap) {
            CoreMap cl = (CoreMap)((Object)label);
            Set<Class<?>> otherKeys = cl.keySet();
            this.setCapacity(otherKeys.size());
            for (Class<?> key : otherKeys) {
                this.set(key, cl.get(key));
            }
        } else {
            if (label instanceof HasWord) {
                this.setWord(((HasWord)((Object)label)).word());
            }
            this.setValue(label.value());
        }
    }

    public CoreLabel(String[] keys, String[] values) {
        super(keys.length);
        this.initFromStrings(keys, values);
    }

    private void initFromStrings(String[] keys, String[] values) {
        for (int i = 0; i < Math.min(keys.length, values.length); ++i) {
            String key = keys[i];
            String value = values[i];
            AnnotationLookup.KeyLookup lookup = AnnotationLookup.getCoreKey(key);
            if (lookup == null) {
                if (key == null) continue;
                throw new UnsupportedOperationException("Unknown key " + key);
            }
            try {
                Class<?> valueClass = AnnotationLookup.getValueType(lookup.coreKey);
                if (valueClass.equals(String.class)) {
                    this.set(lookup.coreKey, values[i]);
                    continue;
                }
                if (valueClass == Integer.class) {
                    this.set(lookup.coreKey, Integer.parseInt(values[i]));
                    continue;
                }
                if (valueClass == Double.class) {
                    this.set(lookup.coreKey, Double.parseDouble(values[i]));
                    continue;
                }
                if (valueClass != Long.class) continue;
                this.set(lookup.coreKey, Long.parseLong(values[i]));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("CORE: CoreLabel.initFromStrings: Bad type for " + key + ". Value was: " + value + "; expected " + AnnotationLookup.getValueType(lookup.coreKey));
            }
        }
    }

    public static LabelFactory factory() {
        return new CoreLabelFactory();
    }

    @Override
    public LabelFactory labelFactory() {
        return CoreLabel.factory();
    }

    public <KEY extends TypesafeMap.Key<CoreMap, String>> String getString(Class<KEY> key) {
        String value = (String)this.get(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    @Override
    public void setFromString(String labelStr) {
        throw new UnsupportedOperationException("Cannot set from string");
    }

    @Override
    public final void setValue(String value) {
        this.set(CoreAnnotations.ValueAnnotation.class, value);
    }

    @Override
    public final String value() {
        return (String)this.get(CoreAnnotations.ValueAnnotation.class);
    }

    @Override
    public void setWord(String word) {
        this.set(CoreAnnotations.TextAnnotation.class, word);
        this.remove(CoreAnnotations.LemmaAnnotation.class);
    }

    @Override
    public String word() {
        return (String)this.get(CoreAnnotations.TextAnnotation.class);
    }

    @Override
    public void setTag(String tag) {
        this.set(CoreAnnotations.PartOfSpeechAnnotation.class, tag);
    }

    @Override
    public String tag() {
        return (String)this.get(CoreAnnotations.PartOfSpeechAnnotation.class);
    }

    @Override
    public void setCategory(String category) {
        this.set(CoreAnnotations.CategoryAnnotation.class, category);
    }

    @Override
    public String category() {
        return (String)this.get(CoreAnnotations.CategoryAnnotation.class);
    }

    @Override
    public void setAfter(String after) {
        this.set(CoreAnnotations.AfterAnnotation.class, after);
    }

    @Override
    public String after() {
        return this.getString(CoreAnnotations.AfterAnnotation.class);
    }

    @Override
    public void setBefore(String before) {
        this.set(CoreAnnotations.BeforeAnnotation.class, before);
    }

    @Override
    public String before() {
        return this.getString(CoreAnnotations.BeforeAnnotation.class);
    }

    @Override
    public void setOriginalText(String originalText) {
        this.set(CoreAnnotations.OriginalTextAnnotation.class, originalText);
    }

    @Override
    public String originalText() {
        return this.getString(CoreAnnotations.OriginalTextAnnotation.class);
    }

    @Override
    public String docID() {
        return (String)this.get(CoreAnnotations.DocIDAnnotation.class);
    }

    @Override
    public void setDocID(String docID) {
        this.set(CoreAnnotations.DocIDAnnotation.class, docID);
    }

    public String ner() {
        return (String)this.get(CoreAnnotations.NamedEntityTagAnnotation.class);
    }

    public void setNER(String ner) {
        this.set(CoreAnnotations.NamedEntityTagAnnotation.class, ner);
    }

    public String lemma() {
        return (String)this.get(CoreAnnotations.LemmaAnnotation.class);
    }

    public void setLemma(String lemma) {
        this.set(CoreAnnotations.LemmaAnnotation.class, lemma);
    }

    @Override
    public int index() {
        Integer n = (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
        if (n == null) {
            return -1;
        }
        return n;
    }

    @Override
    public void setIndex(int index) {
        this.set(CoreAnnotations.IndexAnnotation.class, index);
    }

    @Override
    public int sentIndex() {
        Integer n = (Integer)this.get(CoreAnnotations.SentenceIndexAnnotation.class);
        if (n == null) {
            return -1;
        }
        return n;
    }

    @Override
    public void setSentIndex(int sentIndex) {
        this.set(CoreAnnotations.SentenceIndexAnnotation.class, sentIndex);
    }

    @Override
    public int beginPosition() {
        Integer i = (Integer)this.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        if (i != null) {
            return i;
        }
        return -1;
    }

    @Override
    public int endPosition() {
        Integer i = (Integer)this.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        if (i != null) {
            return i;
        }
        return -1;
    }

    @Override
    public void setBeginPosition(int beginPos) {
        this.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, beginPos);
    }

    @Override
    public void setEndPosition(int endPos) {
        this.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, endPos);
    }

    private static class CoreLabelFactory
    implements LabelFactory {
        private CoreLabelFactory() {
        }

        @Override
        public Label newLabel(String labelStr) {
            CoreLabel label = new CoreLabel();
            label.setValue(labelStr);
            return label;
        }

        @Override
        public Label newLabel(String labelStr, int options) {
            return this.newLabel(labelStr);
        }

        @Override
        public Label newLabel(Label oldLabel) {
            if (oldLabel instanceof CoreLabel) {
                return new CoreLabel((CoreLabel)oldLabel);
            }
            CoreLabel label = new CoreLabel();
            if (oldLabel instanceof HasWord) {
                label.setWord(((HasWord)((Object)oldLabel)).word());
            }
            if (oldLabel instanceof HasTag) {
                label.setTag(((HasTag)((Object)oldLabel)).tag());
            }
            if (oldLabel instanceof HasOffset) {
                label.setBeginPosition(((HasOffset)((Object)oldLabel)).beginPosition());
                label.setEndPosition(((HasOffset)((Object)oldLabel)).endPosition());
            }
            if (oldLabel instanceof HasCategory) {
                label.setCategory(((HasCategory)((Object)oldLabel)).category());
            }
            if (oldLabel instanceof HasIndex) {
                label.setIndex(((HasIndex)((Object)oldLabel)).index());
            }
            label.setValue(oldLabel.value());
            return label;
        }

        @Override
        public Label newLabelFromString(String encodedLabelStr) {
            throw new UnsupportedOperationException("This code branch left blank because we do not understand what this method should do.");
        }
    }

    public static interface GenericAnnotation<T>
    extends CoreAnnotation<T> {
    }
}

