/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Tag;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.WordTag;
import edu.stanford.nlp.parser.lexparser.BaseUnknownWordModel;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.Index;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ChineseUnknownWordModel
extends BaseUnknownWordModel {
    private static final String encoding = "GB18030";
    private final boolean useUnicodeType;
    private static final String numberMatch = ".*[0-9\uff10-\uff19\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343\u4e07\u4ebf\u96f6\u3007\u25cb\u25ef].*";
    private static final String dateMatch = ".*[0-9\uff10-\uff19\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343\u4e07\u4ebf\u96f6\u3007\u25cb\u25ef].*[\u5e74\u6708\u65e5\u53f7]";
    private static final String ordinalMatch = "\u7b2c.*";
    private static final String properNameMatch = ".*[\u00b7\u0387\u2022\u2024\u2027\u2219\u22c5\u30fb].*";
    private final Set<String> seenFirst;
    private static final long serialVersionUID = 221L;

    public ChineseUnknownWordModel(Options op, Lexicon lex, Index<String> wordIndex, Index<String> tagIndex, ClassicCounter<IntTaggedWord> unSeenCounter, HashMap<Label, ClassicCounter<String>> tagHash, HashMap<String, Float> unknownGT, boolean useGT, Set<String> seenFirst) {
        super(op, lex, wordIndex, tagIndex, unSeenCounter, tagHash, unknownGT, null);
        this.useFirst = !useGT;
        this.useGT = useGT;
        this.useUnicodeType = op.lexOptions.useUnicodeType;
        this.seenFirst = seenFirst;
    }

    public ChineseUnknownWordModel(Options op, Lexicon lex, Index<String> wordIndex, Index<String> tagIndex) {
        this(op, lex, wordIndex, tagIndex, new ClassicCounter<IntTaggedWord>(), new HashMap<Label, ClassicCounter<String>>(), new HashMap<String, Float>(), false, new HashSet<String>());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public float score(IntTaggedWord itw, String word) {
        String tag = itw.tagString(this.tagIndex);
        Tag tagL = new Tag(tag);
        if (word.matches(dateMatch)) {
            if (!tag.equals("NT")) return Float.NEGATIVE_INFINITY;
            return 0.0f;
        }
        if (word.matches(numberMatch)) {
            if (tag.equals("CD") && !word.matches(ordinalMatch)) {
                return 0.0f;
            }
            if (!tag.equals("OD")) return Float.NEGATIVE_INFINITY;
            if (!word.matches(ordinalMatch)) return Float.NEGATIVE_INFINITY;
            return 0.0f;
        }
        if (word.matches(properNameMatch)) {
            if (!tag.equals("NR")) return Float.NEGATIVE_INFINITY;
            return 0.0f;
        }
        if (this.useFirst) {
            ClassicCounter wordProbs;
            char ch;
            int type;
            String first = word.substring(0, 1);
            if (this.useUnicodeType && (type = Character.getType(ch = word.charAt(0))) != 5) {
                first = Integer.toString(type);
            }
            if (!this.seenFirst.contains(first)) {
                if (this.useGT) {
                    return this.scoreGT(tag);
                }
                first = "UNK";
            }
            if ((wordProbs = (ClassicCounter)this.tagHash.get(tagL)) == null) {
                return Float.NEGATIVE_INFINITY;
            }
            if (!wordProbs.containsKey(first)) return (float)wordProbs.getCount("UNK");
            return (float)wordProbs.getCount(first);
        }
        if (!this.useGT) return Float.NEGATIVE_INFINITY;
        return this.scoreGT(tag);
    }

    public static void main(String[] args) {
        System.out.println("Testing unknown matching");
        String s = "\u5218\u00b7\u9769\u547d";
        if (s.matches(properNameMatch)) {
            System.out.println("hooray names!");
        } else {
            System.out.println("Uh-oh names!");
        }
        String s1 = "\uff13\uff10\uff10\uff10";
        if (s1.matches(numberMatch)) {
            System.out.println("hooray numbers!");
        } else {
            System.out.println("Uh-oh numbers!");
        }
        String s11 = "\u767e\u5206\u4e4b\u56db\u5341\u4e09\u70b9\u4e8c";
        if (s11.matches(numberMatch)) {
            System.out.println("hooray numbers!");
        } else {
            System.out.println("Uh-oh numbers!");
        }
        String s12 = "\u767e\u5206\u4e4b\u4e09\u5341\u516b\u70b9\u516d";
        if (s12.matches(numberMatch)) {
            System.out.println("hooray numbers!");
        } else {
            System.out.println("Uh-oh numbers!");
        }
        String s2 = "\u4e09\u6708";
        if (s2.matches(dateMatch)) {
            System.out.println("hooray dates!");
        } else {
            System.out.println("Uh-oh dates!");
        }
        System.out.println("Testing tagged word");
        ClassicCounter<TaggedWord> c = new ClassicCounter<TaggedWord>();
        TaggedWord tw1 = new TaggedWord("w", "t");
        c.incrementCount(tw1);
        TaggedWord tw2 = new TaggedWord("w", "t2");
        System.out.println(c.containsKey(tw2));
        System.out.println(tw1.equals(tw2));
        WordTag wt1 = ChineseUnknownWordModel.toWordTag(tw1);
        WordTag wt2 = ChineseUnknownWordModel.toWordTag(tw2);
        WordTag wt3 = new WordTag("w", "t2");
        System.out.println(wt1.equals(wt2));
        System.out.println(wt2.equals(wt3));
    }

    private static WordTag toWordTag(TaggedWord tw) {
        return new WordTag(tw.word(), tw.tag());
    }

    @Override
    public String getSignature(String word, int loc) {
        throw new UnsupportedOperationException();
    }
}

