/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.server;

import edu.stanford.nlp.trees.Tree;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.Socket;

public class LexicalizedParserClient {
    final String host;
    final int port;

    public LexicalizedParserClient(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
    }

    public String getParse(String query) throws IOException {
        String line;
        Socket socket = new Socket(this.host, this.port);
        OutputStreamWriter out2 = new OutputStreamWriter(socket.getOutputStream(), "utf-8");
        out2.write("parse " + query + "\n");
        ((Writer)out2).flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "utf-8"));
        StringBuilder result = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            result.append(line);
        }
        socket.close();
        return result.toString();
    }

    public Tree getTree(String query) throws IOException {
        Object o;
        Socket socket = new Socket(this.host, this.port);
        OutputStreamWriter out2 = new OutputStreamWriter(socket.getOutputStream(), "utf-8");
        out2.write("tree " + query + "\n");
        ((Writer)out2).flush();
        ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
        try {
            o = ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (!(o instanceof Tree)) {
            throw new IllegalArgumentException("Expected a tree");
        }
        Tree tree = (Tree)o;
        socket.close();
        return tree;
    }

    public void sendQuit() throws IOException {
        Socket socket = new Socket(this.host, this.port);
        OutputStreamWriter out2 = new OutputStreamWriter(socket.getOutputStream(), "utf-8");
        out2.write("quit\n");
        ((Writer)out2).flush();
        socket.close();
    }

    public static void main(String[] args) throws IOException {
        System.setOut(new PrintStream((OutputStream)System.out, true, "utf-8"));
        System.setErr(new PrintStream((OutputStream)System.err, true, "utf-8"));
        LexicalizedParserClient client = new LexicalizedParserClient("localhost", 4466);
        String query = "John Bauer works at Stanford.";
        System.out.println(query);
        Tree tree = client.getTree(query);
        System.out.println(tree);
        String results = client.getParse(query);
        System.out.println(results);
    }
}

