/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.HasCategory;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class SemanticHeadFinder
extends ModCollinsHeadFinder {
    private static final boolean DEBUG = false;
    private static final String[] auxiliaries = new String[]{"will", "wo", "shall", "sha", "may", "might", "should", "would", "can", "could", "ca", "must", "has", "have", "had", "having", "get", "gets", "getting", "got", "gotten", "do", "does", "did", "to", "'ve", "'d", "'ll"};
    private static final String[] beGetVerbs = new String[]{"be", "being", "been", "am", "are", "is", "was", "were", "'m", "'re", "'s", "s", "get", "getting", "gets", "got"};
    private static final String[] copulaVerbs = new String[]{"be", "being", "been", "am", "are", "is", "was", "were", "'m", "'re", "'s", "s", "seem", "seems", "seemed", "appear", "appears", "appeared", "stay", "stays", "stayed", "remain", "remains", "remained", "resemble", "resembles", "resembled", "become", "becomes", "became"};
    private static final String[] verbTags = new String[]{"TO", "MD", "VB", "VBD", "VBP", "VBZ", "VBG", "VBN", "AUX", "AUXG"};
    private final HashSet<String> verbalAuxiliaries;
    private final HashSet<String> copulars;
    private final HashSet<String> passiveAuxiliaries;
    private final HashSet<String> verbalTags;
    private static final long serialVersionUID = 5721799188009249808L;

    public SemanticHeadFinder() {
        this(new PennTreebankLanguagePack(), true);
    }

    public SemanticHeadFinder(boolean cop) {
        this(new PennTreebankLanguagePack(), cop);
    }

    public SemanticHeadFinder(TreebankLanguagePack tlp, boolean cop) {
        super(tlp);
        this.ruleChanges();
        this.verbalAuxiliaries = new HashSet();
        this.verbalAuxiliaries.addAll(Arrays.asList(auxiliaries));
        this.passiveAuxiliaries = new HashSet();
        this.passiveAuxiliaries.addAll(Arrays.asList(beGetVerbs));
        this.copulars = new HashSet();
        if (cop) {
            this.copulars.addAll(Arrays.asList(copulaVerbs));
        }
        this.verbalTags = new HashSet();
        this.verbalTags.addAll(Arrays.asList(verbTags));
    }

    private void ruleChanges() {
        this.nonTerminalInfo.put("NP", new String[][]{{"rightdis", "NN", "NNP", "NNPS", "NNS", "NX", "NML", "JJR"}, {"left", "NP", "PRP"}, {"rightdis", "$", "ADJP", "FW"}, {"right", "CD"}, {"rightdis", "JJ", "JJS", "QP", "DT", "WDT", "NML", "PRN", "RB", "RBR", "ADVP"}, {"left", "POS"}, rightExceptPunct});
        this.nonTerminalInfo.put("WHNP", new String[][]{{"rightdis", "NN", "NNP", "NNPS", "NNS", "NX", "NML", "JJR", "WP"}, {"left", "WHNP", "NP"}, {"rightdis", "$", "ADJP", "PRN", "FW"}, {"right", "CD"}, {"rightdis", "JJ", "JJS", "RB", "QP"}, {"left", "WHPP", "WHADJP", "WP$", "WDT"}});
        this.nonTerminalInfo.put("WHADJP", new String[][]{{"left", "ADJP", "JJ", "JJR"}, {"right", "RB"}, rightExceptPunct});
        this.nonTerminalInfo.put("WHADVP", new String[][]{{"rightdis", "WRB", "WHADVP", "RB", "JJ"}, rightExceptPunct});
        this.nonTerminalInfo.put("QP", new String[][]{{"right", "$", "NNS", "NN", "CD", "JJ", "PDT", "DT", "IN", "RB", "NCD", "QP", "JJR", "JJS"}});
        this.nonTerminalInfo.put("S", new String[][]{{"left", "VP", "S", "FRAG", "SBAR", "ADJP", "UCP", "TO"}, {"right", "NP"}});
        this.nonTerminalInfo.put("SBAR", new String[][]{{"left", "S", "SQ", "SINV", "SBAR", "FRAG", "VP", "WHNP", "WHPP", "WHADVP", "WHADJP", "IN", "DT"}});
        this.nonTerminalInfo.put("SQ", new String[][]{{"left", "VP", "SQ", "ADJP", "VB", "VBZ", "VBD", "VBP", "MD", "AUX", "AUXG"}});
        this.nonTerminalInfo.put("UCP", new String[][]{leftExceptPunct});
        this.nonTerminalInfo.put("CONJP", new String[][]{{"right", "VB", "JJ", "RB", "IN", "CC"}, rightExceptPunct});
        this.nonTerminalInfo.put("FRAG", new String[][]{{"left", "IN"}, {"right", "RB"}, {"left", "NP"}, {"left", "ADJP", "ADVP", "FRAG", "S", "SBAR", "VP"}, leftExceptPunct});
        this.nonTerminalInfo.put("PP", new String[][]{{"right", "IN", "TO", "VBG", "VBN", "RP", "FW", "JJ"}, {"left", "PP"}});
        this.nonTerminalInfo.put("PRN", new String[][]{{"left", "VP", "SQ", "S", "SINV", "SBAR", "NP", "ADJP", "PP", "ADVP", "INTJ", "WHNP", "NAC", "VBP", "JJ", "NN", "NNP"}, leftExceptPunct});
        this.nonTerminalInfo.put("XS", new String[][]{{"right", "IN"}});
    }

    @Override
    protected int postOperationFix(int headIdx, Tree[] daughterTrees) {
        String prevLab;
        if (headIdx >= 2 && ((prevLab = this.tlp.basicCategory(daughterTrees[headIdx - 1].value())).equals("CC") || prevLab.equals("CONJP"))) {
            int newHeadIdx;
            for (newHeadIdx = headIdx - 2; newHeadIdx >= 0 && daughterTrees[newHeadIdx].isPreTerminal() && this.tlp.isPunctuationTag(daughterTrees[newHeadIdx].value()); --newHeadIdx) {
            }
            while (newHeadIdx >= 2 && this.tlp.isPunctuationTag(daughterTrees[newHeadIdx - 1].value())) {
                newHeadIdx -= 2;
            }
            if (newHeadIdx >= 0) {
                headIdx = newHeadIdx;
            }
        }
        return headIdx;
    }

    @Override
    protected Tree determineNonTrivialHead(Tree t, Tree parent) {
        Tree hd;
        Tree[] hdChildren;
        String motherCat = this.tlp.basicCategory(t.label().value());
        if (motherCat.equals("VP") || motherCat.equals("SQ") || motherCat.equals("SINV")) {
            String[] how;
            Tree pti;
            Tree[] kids = t.children();
            if ((this.hasVerbalAuxiliary(kids, this.verbalAuxiliaries) || this.hasPassiveProgressiveAuxiliary(kids, this.passiveAuxiliaries)) && (pti = this.traverseLocate(kids, how = new String[]{"left", "VP", "ADJP"}, false)) != null) {
                return pti;
            }
            if (this.hasVerbalAuxiliary(kids, this.copulars) && !this.isExistential(t, parent) && !SemanticHeadFinder.isWHQ(t, parent)) {
                how = motherCat.equals("SQ") ? new String[]{"right", "VP", "ADJP", "NP", "WHADJP", "WHNP"} : new String[]{"left", "VP", "ADJP", "NP", "WHADJP", "WHNP"};
                pti = this.traverseLocate(kids, how, false);
                if (pti != null && pti.label() != null && pti.label().value().contains("-TMP")) {
                    pti = null;
                }
                if (motherCat.equals("SQ") && pti != null && pti.label() != null && pti.label().value().startsWith("NP")) {
                    boolean foundAnotherNp = false;
                    for (Tree kid : kids) {
                        if (kid == pti) break;
                        if (kid.label() == null || !kid.label().value().startsWith("NP")) continue;
                        foundAnotherNp = true;
                        break;
                    }
                    if (!foundAnotherNp) {
                        pti = null;
                    }
                }
                if (pti != null) {
                    return pti;
                }
            }
        }
        if ((hdChildren = (hd = super.determineNonTrivialHead(t, parent)).children()) != null && hdChildren.length > 0 && hdChildren[0].isLeaf() && this.tlp.isPunctuationWord(hdChildren[0].label().value())) {
            Tree[] tChildren = t.children();
            for (int i = tChildren.length - 1; i >= 0; --i) {
                if (this.tlp.isPunctuationWord(tChildren[i].children()[0].label().value())) continue;
                hd = tChildren[i];
                break;
            }
        }
        return hd;
    }

    private boolean isExistential(Tree t, Tree parent) {
        boolean toReturn;
        block5: {
            Tree[] kids;
            String motherCat;
            block4: {
                Tree[] kids2;
                toReturn = false;
                motherCat = this.tlp.basicCategory(t.label().value());
                if (!motherCat.equals("VP") || parent == null) break block4;
                for (Tree kid : kids2 = parent.children()) {
                    if (kid.value().equals("VP")) break;
                    List<Label> tags = kid.preTerminalYield();
                    for (Label tag : tags) {
                        if (!tag.value().equals("EX")) continue;
                        toReturn = true;
                    }
                }
                break block5;
            }
            if (!motherCat.startsWith("SQ") || parent == null) break block5;
            for (Tree kid : kids = parent.children()) {
                if (kid.value().startsWith("VB")) continue;
                List<Label> tags = kid.preTerminalYield();
                for (Label tag : tags) {
                    if (!tag.value().equals("EX")) continue;
                    toReturn = true;
                }
            }
        }
        return toReturn;
    }

    private static boolean isWHQ(Tree t, Tree parent) {
        if (t == null) {
            return false;
        }
        boolean toReturn = false;
        if (t.value().startsWith("SQ") && parent != null && parent.value().equals("SBARQ")) {
            Tree[] kids;
            for (Tree kid : kids = parent.children()) {
                if (!kid.value().startsWith("WH")) continue;
                toReturn = true;
            }
        }
        return toReturn;
    }

    private boolean hasPassiveProgressiveAuxiliary(Tree[] kids, HashSet<String> verbalSet) {
        boolean foundPassiveVP = false;
        boolean foundPassiveAux = false;
        for (Tree kid : kids) {
            block17: {
                Label kidLabel;
                block16: {
                    if (!kid.isPreTerminal()) break block16;
                    kidLabel = kid.label();
                    String tag = null;
                    if (kidLabel instanceof HasTag) {
                        tag = ((HasTag)((Object)kidLabel)).tag();
                    }
                    if (tag == null) {
                        tag = kid.value();
                    }
                    Label wordLabel = kid.firstChild().label();
                    String word = null;
                    if (wordLabel instanceof HasWord) {
                        word = ((HasWord)((Object)wordLabel)).word();
                    }
                    if (word == null) {
                        word = wordLabel.value();
                    }
                    String lcWord = word.toLowerCase();
                    if (!this.verbalTags.contains(tag) || !verbalSet.contains(lcWord)) break block17;
                    foundPassiveAux = true;
                    break block17;
                }
                if (kid.isPhrasal()) {
                    kidLabel = kid.label();
                    String cat = null;
                    if (kidLabel instanceof HasCategory) {
                        cat = ((HasCategory)((Object)kidLabel)).category();
                    }
                    if (cat == null) {
                        cat = kid.value();
                    }
                    if (!cat.startsWith("VP")) continue;
                    Tree[] kidkids = kid.children();
                    boolean foundParticipleInVp = false;
                    for (Tree kidkid : kidkids) {
                        if (kidkid.isPreTerminal()) {
                            Label kidkidLabel = kidkid.label();
                            String tag = null;
                            if (kidkidLabel instanceof HasTag) {
                                tag = ((HasTag)((Object)kidkidLabel)).tag();
                            }
                            if (tag == null) {
                                tag = kidkid.value();
                            }
                            if ("VBN".equals(tag) || "VBG".equals(tag) || "VBD".equals(tag)) {
                                foundPassiveVP = true;
                                break;
                            }
                            if (!"CC".equals(tag) || !foundParticipleInVp) continue;
                            foundPassiveVP = true;
                            break;
                        }
                        if (!kidkid.isPhrasal()) continue;
                        String catcat = null;
                        if (kidLabel instanceof HasCategory) {
                            catcat = ((HasCategory)((Object)kidLabel)).category();
                        }
                        if (catcat == null) {
                            catcat = kid.value();
                        }
                        if ("VP".equals(catcat)) {
                            foundParticipleInVp = SemanticHeadFinder.vpContainsParticiple(kidkid);
                            continue;
                        }
                        if (!"CONJP".equals(catcat) && !"PRN".equals(catcat) || !foundParticipleInVp) continue;
                        foundPassiveVP = true;
                        break;
                    }
                }
            }
            if (foundPassiveAux && foundPassiveVP) break;
        }
        return foundPassiveAux && foundPassiveVP;
    }

    private static boolean vpContainsParticiple(Tree t) {
        for (Tree kid : t.children()) {
            if (!kid.isPreTerminal()) continue;
            Label kidLabel = kid.label();
            String tag = null;
            if (kidLabel instanceof HasTag) {
                tag = ((HasTag)((Object)kidLabel)).tag();
            }
            if (tag == null) {
                tag = kid.value();
            }
            if (!"VBN".equals(tag) && !"VBG".equals(tag) && !"VBD".equals(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean isVerbalAuxiliary(Tree t) {
        Tree[] trees = new Tree[]{t};
        return this.hasVerbalAuxiliary(trees, this.verbalAuxiliaries);
    }

    private boolean hasVerbalAuxiliary(Tree[] kids, HashSet<String> verbalSet) {
        for (Tree kid : kids) {
            if (!kid.isPreTerminal()) continue;
            Label kidLabel = kid.label();
            String tag = null;
            if (kidLabel instanceof HasTag) {
                tag = ((HasTag)((Object)kidLabel)).tag();
            }
            if (tag == null) {
                tag = kid.value();
            }
            Label wordLabel = kid.firstChild().label();
            String word = null;
            if (wordLabel instanceof HasWord) {
                word = ((HasWord)((Object)wordLabel)).word();
            }
            if (word == null) {
                word = wordLabel.value();
            }
            String lcWord = word.toLowerCase();
            if (!this.verbalTags.contains(tag) || !verbalSet.contains(lcWord)) continue;
            return true;
        }
        return false;
    }
}

