/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.Relation;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.VariableStrings;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Pair;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DescriptionPattern
extends TregexPattern {
    private final Relation rel;
    private final boolean negDesc;
    private final DescriptionMode descriptionMode;
    private final String exactMatch;
    private final Pattern descPattern;
    private final String stringDesc;
    private final String name;
    private final String linkedName;
    private final boolean isLink;
    private TregexPattern child;
    private boolean changesVariables;
    private final List<Pair<Integer, String>> variableGroups;
    private final Function<String, String> basicCatFunction;
    private static final long serialVersionUID = 1179819056757295757L;

    public DescriptionPattern(Relation rel, boolean negDesc, String desc, String name, boolean useBasicCat, Function<String, String> basicCatFunction, List<Pair<Integer, String>> variableGroups, boolean isLink, String linkedName) {
        this.rel = rel;
        this.negDesc = negDesc;
        this.isLink = isLink;
        this.linkedName = linkedName;
        if (desc != null) {
            this.stringDesc = desc;
            if (desc.equals("__") || desc.equals("/.*/") || desc.equals("/^.*$/")) {
                this.descriptionMode = DescriptionMode.ANYTHING;
                this.descPattern = null;
                this.exactMatch = null;
            } else if (desc.matches("/.*/")) {
                this.descriptionMode = DescriptionMode.PATTERN;
                this.descPattern = Pattern.compile(desc.substring(1, desc.length() - 1));
                this.exactMatch = null;
            } else if (desc.indexOf(124) >= 0) {
                this.descriptionMode = DescriptionMode.PATTERN;
                this.descPattern = Pattern.compile("^(" + desc + ")$");
                this.exactMatch = null;
            } else {
                this.descriptionMode = DescriptionMode.EXACT;
                this.descPattern = null;
                this.exactMatch = desc;
            }
        } else {
            assert (name != null);
            this.stringDesc = " ";
            this.descriptionMode = null;
            this.descPattern = null;
            this.exactMatch = null;
        }
        this.name = name;
        this.setChild(null);
        this.basicCatFunction = useBasicCat ? basicCatFunction : null;
        this.variableGroups = variableGroups;
    }

    @Override
    public String localString() {
        return this.rel.toString() + ' ' + (this.negDesc ? "!" : "") + (this.basicCatFunction != null ? "@" : "") + this.stringDesc + (this.name == null ? "" : '=' + this.name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isNegated()) {
            sb.append('!');
        }
        if (this.isOptional()) {
            sb.append('?');
        }
        sb.append(this.rel.toString());
        sb.append(' ');
        if (this.child != null) {
            sb.append('(');
        }
        if (this.negDesc) {
            sb.append('!');
        }
        if (this.basicCatFunction != null) {
            sb.append('@');
        }
        sb.append(this.stringDesc);
        if (this.isLink) {
            sb.append('~');
            sb.append(this.linkedName);
        }
        if (this.name != null) {
            sb.append('=');
            sb.append(this.name);
        }
        sb.append(' ');
        if (this.child != null) {
            sb.append(this.child.toString());
            sb.append(')');
        }
        return sb.toString();
    }

    public void setChild(TregexPattern n) {
        this.child = n;
        this.changesVariables = (this.descriptionMode != null || this.isLink) && this.name != null;
        this.changesVariables = this.changesVariables || this.child != null && this.child.getChangesVariables();
    }

    @Override
    public List<TregexPattern> getChildren() {
        if (this.child == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.child);
    }

    @Override
    boolean getChangesVariables() {
        return this.changesVariables;
    }

    @Override
    public TregexMatcher matcher(Tree root, Tree tree, IdentityHashMap<Tree, Tree> nodesToParents, Map<String, Tree> namesToNodes, VariableStrings variableStrings) {
        return new DescriptionMatcher(this, root, tree, nodesToParents, namesToNodes, variableStrings);
    }

    private static class DescriptionMatcher
    extends TregexMatcher {
        private Iterator<Tree> treeNodeMatchCandidateIterator;
        private final DescriptionPattern myNode;
        private TregexMatcher childMatcher;
        private Tree nextTreeNodeMatchCandidate;
        private boolean finished = false;
        private boolean matchedOnce = false;
        private boolean committedVariables = false;

        public DescriptionMatcher(DescriptionPattern n, Tree root, Tree tree, IdentityHashMap<Tree, Tree> nodesToParents, Map<String, Tree> namesToNodes, VariableStrings variableStrings) {
            super(root, tree, nodesToParents, namesToNodes, variableStrings);
            this.myNode = n;
            this.resetChildIter();
        }

        @Override
        void resetChildIter() {
            this.decommitVariableGroups();
            this.removeNamedNodes();
            this.treeNodeMatchCandidateIterator = this.myNode.rel.searchNodeIterator(this.tree, this);
            this.finished = false;
            this.nextTreeNodeMatchCandidate = null;
            if (this.childMatcher != null) {
                this.childMatcher.resetChildIter();
            }
        }

        private void resetChild() {
            if (this.childMatcher == null) {
                if (this.myNode.child == null) {
                    this.matchedOnce = false;
                } else {
                    this.childMatcher = this.myNode.child.matcher(this.root, this.nextTreeNodeMatchCandidate, this.nodesToParents, this.namesToNodes, this.variableStrings);
                }
            } else {
                this.childMatcher.resetChildIter(this.nextTreeNodeMatchCandidate);
            }
        }

        @Override
        boolean getChangesVariables() {
            return this.myNode.getChangesVariables();
        }

        private void goToNextTreeNodeMatch() {
            this.decommitVariableGroups();
            this.removeNamedNodes();
            this.finished = true;
            Matcher m = null;
            String value = null;
            while (this.treeNodeMatchCandidateIterator.hasNext()) {
                boolean found;
                this.nextTreeNodeMatchCandidate = this.treeNodeMatchCandidateIterator.next();
                if (this.myNode.descriptionMode == null) {
                    if (this.myNode.isLink) {
                        String myValue;
                        String otherValue;
                        Tree otherTree = (Tree)this.namesToNodes.get(this.myNode.linkedName);
                        if (otherTree == null || !(otherValue = this.myNode.basicCatFunction == null ? otherTree.value() : (String)this.myNode.basicCatFunction.apply(otherTree.value())).equals(myValue = this.myNode.basicCatFunction == null ? this.nextTreeNodeMatchCandidate.value() : (String)this.myNode.basicCatFunction.apply(this.nextTreeNodeMatchCandidate.value()))) continue;
                        this.finished = false;
                        break;
                    }
                    if (this.namesToNodes.get(this.myNode.name) != this.nextTreeNodeMatchCandidate) continue;
                    this.finished = false;
                    break;
                }
                value = this.nextTreeNodeMatchCandidate.value();
                if (value == null) {
                    found = false;
                } else {
                    if (this.myNode.basicCatFunction != null) {
                        value = (String)this.myNode.basicCatFunction.apply(value);
                    }
                    switch (this.myNode.descriptionMode) {
                        case EXACT: {
                            found = value.equals(this.myNode.exactMatch);
                            break;
                        }
                        case PATTERN: {
                            m = this.myNode.descPattern.matcher(value);
                            found = m.find();
                            break;
                        }
                        case ANYTHING: {
                            found = true;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected match mode");
                        }
                    }
                }
                if (found) {
                    for (Pair varGroup : this.myNode.variableGroups) {
                        String thisVariable = (String)varGroup.second();
                        String thisVarString = this.variableStrings.getString(thisVariable);
                        if (m != null) {
                            if (thisVarString == null || thisVarString.equals(m.group((Integer)varGroup.first()))) continue;
                            found = false;
                            break;
                        }
                        if (thisVarString == null || thisVarString.equals(value)) continue;
                        found = false;
                        break;
                    }
                }
                if (found == this.myNode.negDesc) continue;
                this.finished = false;
                break;
            }
            if (!this.finished) {
                this.resetChild();
                if ((this.myNode.descriptionMode != null || this.myNode.isLink) && this.myNode.name != null) {
                    this.namesToNodes.put(this.myNode.name, this.nextTreeNodeMatchCandidate);
                }
                if (m != null) {
                    this.commitVariableGroups(m);
                } else if (value != null) {
                    this.commitVariableGroups(value);
                }
            }
        }

        private void commitVariableGroups(Matcher m) {
            this.committedVariables = true;
            for (Pair varGroup : this.myNode.variableGroups) {
                String thisVarString = m.group((Integer)varGroup.first());
                this.variableStrings.setVar((String)varGroup.second(), thisVarString);
            }
        }

        private void commitVariableGroups(String value) {
            this.committedVariables = true;
            for (Pair varGroup : this.myNode.variableGroups) {
                this.variableStrings.setVar((String)varGroup.second(), value);
            }
        }

        private void decommitVariableGroups() {
            if (this.committedVariables) {
                for (Pair varGroup : this.myNode.variableGroups) {
                    this.variableStrings.unsetVar((String)varGroup.second());
                }
            }
            this.committedVariables = false;
        }

        private void removeNamedNodes() {
            if ((this.myNode.descPattern != null || this.myNode.isLink) && this.myNode.name != null) {
                this.namesToNodes.remove(this.myNode.name);
            }
        }

        private boolean matchChild() {
            if (this.nextTreeNodeMatchCandidate == null) {
                return false;
            }
            if (this.childMatcher == null) {
                if (!this.matchedOnce) {
                    this.matchedOnce = true;
                    return true;
                }
                return false;
            }
            return this.childMatcher.matches();
        }

        @Override
        public boolean matches() {
            if (this.finished) {
                return false;
            }
            while (!this.finished) {
                if (this.matchChild()) {
                    if (this.myNode.isNegated()) {
                        this.finished = true;
                        return false;
                    }
                    if (this.myNode.isOptional()) {
                        this.finished = true;
                    }
                    return true;
                }
                this.goToNextTreeNodeMatch();
            }
            if (this.myNode.isNegated()) {
                return true;
            }
            this.decommitVariableGroups();
            this.removeNamedNodes();
            this.nextTreeNodeMatchCandidate = null;
            return this.myNode.isOptional();
        }

        @Override
        public Tree getMatch() {
            return this.nextTreeNodeMatchCandidate;
        }
    }

    static enum DescriptionMode {
        PATTERN,
        EXACT,
        ANYTHING;

    }
}

