/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.IdentityHashSet;
import edu.stanford.nlp.util.Interner;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class Relation
implements Serializable {
    private static final long serialVersionUID = -1564793674551362909L;
    private final String symbol;
    private static final Pattern parentOfLastChild = Pattern.compile("(<-|<`)");
    private static final Pattern lastChildOfParent = Pattern.compile("(>-|>`)");
    static final Relation ROOT = new Relation("Root"){
        private static final long serialVersionUID = -8311913236233762612L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return t1 == t2;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                }
            };
        }
    };
    private static final Relation EQUALS = new Relation("=="){
        private static final long serialVersionUID = 164629344977943816L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return t1 == t2;
        }

        @Override
        Iterator<Tree> searchNodeIterator(Tree t, TregexMatcher matcher) {
            return Collections.singletonList(t).iterator();
        }
    };
    private static final Relation PATTERN_SPLITTER = new Relation(":"){
        private static final long serialVersionUID = 3409941930361386114L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return true;
        }

        @Override
        Iterator<Tree> searchNodeIterator(Tree t, TregexMatcher matcher) {
            return matcher.getRoot().iterator();
        }
    };
    private static final Relation DOMINATES = new Relation("<<"){
        private static final long serialVersionUID = -2580199434621268260L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return t1 != t2 && t1.dominates(t2);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.searchStack = new Stack();
                    for (int i = t.numChildren() - 1; i >= 0; --i) {
                        this.searchStack.push(t.getChild(i));
                    }
                    if (!this.searchStack.isEmpty()) {
                        this.advance();
                    }
                }

                @Override
                void advance() {
                    if (this.searchStack.isEmpty()) {
                        this.next = null;
                    } else {
                        this.next = this.searchStack.pop();
                        for (int i = this.next.numChildren() - 1; i >= 0; --i) {
                            this.searchStack.push(this.next.getChild(i));
                        }
                    }
                }
            };
        }
    };
    private static final Relation DOMINATED_BY = new Relation(">>"){
        private static final long serialVersionUID = 6140614010121387690L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return DOMINATES.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = matcher.getParent(t);
                }

                @Override
                public void advance() {
                    this.next = matcher.getParent(this.next);
                }
            };
        }
    };
    private static final Relation PARENT_OF = new Relation("<"){
        private static final long serialVersionUID = 9140193735607580808L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            Tree[] kids = t1.children();
            int n = kids.length;
            for (int i = 0; i < n; ++i) {
                if (kids[i] != t2) continue;
                return true;
            }
            return false;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){
                int nextNum;

                @Override
                public void advance() {
                    if (this.nextNum < t.numChildren()) {
                        this.next = t.getChild(this.nextNum);
                        ++this.nextNum;
                    } else {
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation CHILD_OF = new Relation(">"){
        private static final long serialVersionUID = 8919710375433372537L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return PARENT_OF.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = matcher.getParent(t);
                }
            };
        }
    };
    private static final Relation PRECEDES = new Relation(".."){
        private static final long serialVersionUID = -9065012389549976867L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return Trees.rightEdge(t1, root) <= Trees.leftEdge(t2, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.searchStack = new Stack();
                    Tree current = t;
                    Tree parent = matcher.getParent(t);
                    while (parent != null) {
                        int i = parent.numChildren() - 1;
                        while (parent.getChild(i) != current) {
                            this.searchStack.push(parent.getChild(i));
                            --i;
                        }
                        current = parent;
                        parent = matcher.getParent(parent);
                    }
                    this.advance();
                }

                @Override
                void advance() {
                    if (this.searchStack.isEmpty()) {
                        this.next = null;
                    } else {
                        this.next = this.searchStack.pop();
                        for (int i = this.next.numChildren() - 1; i >= 0; --i) {
                            this.searchStack.push(this.next.getChild(i));
                        }
                    }
                }
            };
        }
    };
    private static final Relation IMMEDIATELY_PRECEDES = new Relation("."){
        private static final long serialVersionUID = 3390147676937292768L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return Trees.leftEdge(t2, root) == Trees.rightEdge(t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    Tree current;
                    Tree parent = t;
                    do {
                        current = parent;
                        if ((parent = matcher.getParent(parent)) != null) continue;
                        this.next = null;
                        return;
                    } while (parent.lastChild() == current);
                    int n = parent.numChildren();
                    for (int i = 1; i < n; ++i) {
                        if (parent.getChild(i - 1) != current) continue;
                        this.next = parent.getChild(i);
                        return;
                    }
                }

                @Override
                public void advance() {
                    this.next = this.next.isLeaf() ? null : this.next.firstChild();
                }
            };
        }
    };
    private static final Relation FOLLOWS = new Relation(",,"){
        private static final long serialVersionUID = -5948063114149496983L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return Trees.rightEdge(t2, root) <= Trees.leftEdge(t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.searchStack = new Stack();
                    Tree current = t;
                    Tree parent = matcher.getParent(t);
                    while (parent != null) {
                        int i = 0;
                        while (parent.getChild(i) != current) {
                            this.searchStack.push(parent.getChild(i));
                            ++i;
                        }
                        current = parent;
                        parent = matcher.getParent(parent);
                    }
                    this.advance();
                }

                @Override
                void advance() {
                    if (this.searchStack.isEmpty()) {
                        this.next = null;
                    } else {
                        this.next = this.searchStack.pop();
                        for (int i = this.next.numChildren() - 1; i >= 0; --i) {
                            this.searchStack.push(this.next.getChild(i));
                        }
                    }
                }
            };
        }
    };
    private static final Relation IMMEDIATELY_FOLLOWS = new Relation(","){
        private static final long serialVersionUID = -2895075562891296830L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return Trees.leftEdge(t1, root) == Trees.rightEdge(t2, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    Tree current;
                    Tree parent = t;
                    do {
                        current = parent;
                        if ((parent = matcher.getParent(parent)) != null) continue;
                        this.next = null;
                        return;
                    } while (parent.firstChild() == current);
                    int n = parent.numChildren() - 1;
                    for (int i = 0; i < n; ++i) {
                        if (parent.getChild(i + 1) != current) continue;
                        this.next = parent.getChild(i);
                        return;
                    }
                }

                @Override
                public void advance() {
                    this.next = this.next.isLeaf() ? null : this.next.lastChild();
                }
            };
        }
    };
    private static final Relation HAS_LEFTMOST_DESCENDANT = new Relation("<<,"){
        private static final long serialVersionUID = -7352081789429366726L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            if (t1.isLeaf()) {
                return false;
            }
            return t1.children()[0] == t2 || this.satisfies(t1.children()[0], t2, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                    this.advance();
                }

                @Override
                public void advance() {
                    this.next = this.next.isLeaf() ? null : this.next.firstChild();
                }
            };
        }
    };
    private static final Relation HAS_RIGHTMOST_DESCENDANT = new Relation("<<-"){
        private static final long serialVersionUID = -1405509785337859888L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            if (t1.isLeaf()) {
                return false;
            }
            Tree lastKid = t1.children()[t1.children().length - 1];
            return lastKid == t2 || this.satisfies(lastKid, t2, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                    this.advance();
                }

                @Override
                public void advance() {
                    this.next = this.next.isLeaf() ? null : this.next.lastChild();
                }
            };
        }
    };
    private static final Relation LEFTMOST_DESCENDANT_OF = new Relation(">>,"){
        private static final long serialVersionUID = 3103412865783190437L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return HAS_LEFTMOST_DESCENDANT.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                    this.advance();
                }

                @Override
                public void advance() {
                    Tree last = this.next;
                    this.next = matcher.getParent(this.next);
                    if (this.next != null && this.next.firstChild() != last) {
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation RIGHTMOST_DESCENDANT_OF = new Relation(">>-"){
        private static final long serialVersionUID = -2000255467314675477L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return HAS_RIGHTMOST_DESCENDANT.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                    this.advance();
                }

                @Override
                public void advance() {
                    Tree last = this.next;
                    this.next = matcher.getParent(this.next);
                    if (this.next != null && this.next.lastChild() != last) {
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation SISTER_OF = new Relation("$"){
        private static final long serialVersionUID = -3776688096782419004L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            if (t1 == t2 || t1 == root) {
                return false;
            }
            Tree parent = t1.parent(root);
            return PARENT_OF.satisfies(parent, t2, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Tree parent;
                int nextNum;

                @Override
                void initialize() {
                    this.parent = matcher.getParent(t);
                    if (this.parent != null) {
                        this.nextNum = 0;
                        this.advance();
                    }
                }

                @Override
                public void advance() {
                    if (this.nextNum < this.parent.numChildren()) {
                        this.next = this.parent.getChild(this.nextNum++);
                        if (this.next == t) {
                            this.advance();
                        }
                    } else {
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation LEFT_SISTER_OF = new Relation("$++"){
        private static final long serialVersionUID = -4516161080140406862L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            if (t1 == t2 || t1 == root) {
                return false;
            }
            Tree parent = t1.parent(root);
            Tree[] kids = parent.children();
            for (int i = kids.length - 1; i > 0; --i) {
                if (kids[i] == t1) {
                    return false;
                }
                if (kids[i] != t2) continue;
                return true;
            }
            return false;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Tree parent;
                int nextNum;

                @Override
                void initialize() {
                    this.parent = matcher.getParent(t);
                    if (this.parent != null) {
                        this.nextNum = this.parent.numChildren() - 1;
                        this.advance();
                    }
                }

                @Override
                public void advance() {
                    this.next = this.parent.getChild(this.nextNum--);
                    if (this.next == t) {
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation RIGHT_SISTER_OF = new Relation("$--"){
        private static final long serialVersionUID = -5880626025192328694L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return LEFT_SISTER_OF.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Tree parent;
                int nextNum;

                @Override
                void initialize() {
                    this.parent = matcher.getParent(t);
                    if (this.parent != null) {
                        this.nextNum = 0;
                        this.advance();
                    }
                }

                @Override
                public void advance() {
                    this.next = this.parent.getChild(this.nextNum++);
                    if (this.next == t) {
                        this.next = null;
                    }
                }
            };
        }
    };
    private static final Relation IMMEDIATE_LEFT_SISTER_OF = new Relation("$+"){
        private static final long serialVersionUID = 7745237994722126917L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            if (t1 == t2 || t1 == root) {
                return false;
            }
            Tree[] sisters = t1.parent(root).children();
            for (int i = sisters.length - 1; i > 0; --i) {
                if (sisters[i] == t1) {
                    return false;
                }
                if (sisters[i] != t2) continue;
                return sisters[i - 1] == t1;
            }
            return false;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (t != matcher.getRoot()) {
                        Tree parent = matcher.getParent(t);
                        int i = 0;
                        while (parent.getChild(i) != t) {
                            ++i;
                        }
                        if (i + 1 < parent.numChildren()) {
                            this.next = parent.getChild(i + 1);
                        }
                    }
                }
            };
        }
    };
    private static final Relation IMMEDIATE_RIGHT_SISTER_OF = new Relation("$-"){
        private static final long serialVersionUID = -6555264189937531019L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return IMMEDIATE_LEFT_SISTER_OF.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (t != matcher.getRoot()) {
                        Tree parent = matcher.getParent(t);
                        int i = 0;
                        while (parent.getChild(i) != t) {
                            ++i;
                        }
                        if (i > 0) {
                            this.next = parent.getChild(i - 1);
                        }
                    }
                }
            };
        }
    };
    private static final Relation ONLY_CHILD_OF = new Relation(">:"){
        private static final long serialVersionUID = 1719812660770087879L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return t2.children().length == 1 && t2.firstChild() == t1;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (t != matcher.getRoot()) {
                        this.next = matcher.getParent(t);
                        if (this.next.numChildren() != 1) {
                            this.next = null;
                        }
                    }
                }
            };
        }
    };
    private static final Relation HAS_ONLY_CHILD = new Relation("<:"){
        private static final long serialVersionUID = -8776487500849294279L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return t1.children().length == 1 && t1.firstChild() == t2;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (!t.isLeaf() && t.numChildren() == 1) {
                        this.next = t.firstChild();
                    }
                }
            };
        }
    };
    private static final Relation UNARY_PATH_ANCESTOR_OF = new Relation("<<:"){
        private static final long serialVersionUID = -742912038636163403L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            if (t1.isLeaf() || t1.children().length > 1) {
                return false;
            }
            Tree onlyDtr = t1.children()[0];
            if (onlyDtr == t2) {
                return true;
            }
            return this.satisfies(onlyDtr, t2, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.searchStack = new Stack();
                    if (!t.isLeaf() && t.children().length == 1) {
                        this.searchStack.push(t.getChild(0));
                    }
                    if (!this.searchStack.isEmpty()) {
                        this.advance();
                    }
                }

                @Override
                void advance() {
                    if (this.searchStack.isEmpty()) {
                        this.next = null;
                    } else {
                        this.next = this.searchStack.pop();
                        if (!this.next.isLeaf() && this.next.children().length == 1) {
                            this.searchStack.push(this.next.getChild(0));
                        }
                    }
                }
            };
        }
    };
    private static final Relation UNARY_PATH_DESCENDANT_OF = new Relation(">>:"){
        private static final long serialVersionUID = 4364021807752979404L;

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            if (t2.isLeaf() || t2.children().length > 1) {
                return false;
            }
            Tree onlyDtr = t2.children()[0];
            if (onlyDtr == t1) {
                return true;
            }
            return this.satisfies(t1, onlyDtr, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.searchStack = new Stack();
                    Tree parent = matcher.getParent(t);
                    if (parent != null && !parent.isLeaf() && parent.children().length == 1) {
                        this.searchStack.push(parent);
                    }
                    if (!this.searchStack.isEmpty()) {
                        this.advance();
                    }
                }

                @Override
                void advance() {
                    if (this.searchStack.isEmpty()) {
                        this.next = null;
                    } else {
                        this.next = this.searchStack.pop();
                        Tree parent = matcher.getParent(this.next);
                        if (parent != null && !parent.isLeaf() && parent.children().length == 1) {
                            this.searchStack.push(parent);
                        }
                    }
                }
            };
        }
    };
    private static final Relation[] SIMPLE_RELATIONS = new Relation[]{DOMINATES, DOMINATED_BY, PARENT_OF, CHILD_OF, PRECEDES, IMMEDIATELY_PRECEDES, FOLLOWS, IMMEDIATELY_FOLLOWS, HAS_LEFTMOST_DESCENDANT, HAS_RIGHTMOST_DESCENDANT, LEFTMOST_DESCENDANT_OF, RIGHTMOST_DESCENDANT_OF, SISTER_OF, LEFT_SISTER_OF, RIGHT_SISTER_OF, IMMEDIATE_LEFT_SISTER_OF, IMMEDIATE_RIGHT_SISTER_OF, ONLY_CHILD_OF, HAS_ONLY_CHILD, EQUALS, PATTERN_SPLITTER, UNARY_PATH_ANCESTOR_OF, UNARY_PATH_DESCENDANT_OF};
    private static final Map<String, Relation> SIMPLE_RELATIONS_MAP = new HashMap<String, Relation>();

    abstract boolean satisfies(Tree var1, Tree var2, Tree var3);

    abstract Iterator<Tree> searchNodeIterator(Tree var1, TregexMatcher var2);

    static Relation getRelation(String s, Function<String, String> basicCatFunction, HeadFinder headFinder) throws ParseException {
        Relation r;
        if (SIMPLE_RELATIONS_MAP.containsKey(s)) {
            return SIMPLE_RELATIONS_MAP.get(s);
        }
        if (s.equals("<,")) {
            return Relation.getRelation("<", "1", basicCatFunction, headFinder);
        }
        if (parentOfLastChild.matcher(s).matches()) {
            return Relation.getRelation("<", "-1", basicCatFunction, headFinder);
        }
        if (s.equals(">,")) {
            return Relation.getRelation(">", "1", basicCatFunction, headFinder);
        }
        if (lastChildOfParent.matcher(s).matches()) {
            return Relation.getRelation(">", "-1", basicCatFunction, headFinder);
        }
        if (s.equals(">>#")) {
            r = new Heads(headFinder);
        } else if (s.equals("<<#")) {
            r = new HeadedBy(headFinder);
        } else if (s.equals(">#")) {
            r = new ImmediatelyHeads(headFinder);
        } else if (s.equals("<#")) {
            r = new ImmediatelyHeadedBy(headFinder);
        } else {
            throw new ParseException("Unrecognized simple relation " + s);
        }
        return Interner.globalIntern(r);
    }

    static Relation getRelation(String s, String arg, Function<String, String> basicCatFunction, HeadFinder headFinder) throws ParseException {
        Relation r;
        if (arg == null) {
            return Relation.getRelation(s, basicCatFunction, headFinder);
        }
        if (s.equals("<")) {
            r = new HasIthChild(Integer.parseInt(arg));
        } else if (s.equals(">")) {
            r = new IthChildOf(Integer.parseInt(arg));
        } else if (s.equals("<+")) {
            r = new UnbrokenCategoryDominates(arg, basicCatFunction);
        } else if (s.equals(">+")) {
            r = new UnbrokenCategoryIsDominatedBy(arg, basicCatFunction);
        } else if (s.equals(".+")) {
            r = new UnbrokenCategoryPrecedes(arg, basicCatFunction);
        } else if (s.equals(",+")) {
            r = new UnbrokenCategoryFollows(arg, basicCatFunction);
        } else {
            throw new ParseException("Unrecognized compound relation " + s + ' ' + arg);
        }
        return Interner.globalIntern(r);
    }

    private Relation(String symbol) {
        this.symbol = symbol;
    }

    public String toString() {
        return this.symbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Relation)) {
            return false;
        }
        Relation relation = (Relation)o;
        return this.symbol.equals(relation.symbol);
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    static {
        for (Relation r : SIMPLE_RELATIONS) {
            SIMPLE_RELATIONS_MAP.put(r.symbol, r);
        }
        SIMPLE_RELATIONS_MAP.put("<<`", HAS_RIGHTMOST_DESCENDANT);
        SIMPLE_RELATIONS_MAP.put("<<,", HAS_LEFTMOST_DESCENDANT);
        SIMPLE_RELATIONS_MAP.put(">>`", RIGHTMOST_DESCENDANT_OF);
        SIMPLE_RELATIONS_MAP.put(">>,", LEFTMOST_DESCENDANT_OF);
        SIMPLE_RELATIONS_MAP.put("$..", LEFT_SISTER_OF);
        SIMPLE_RELATIONS_MAP.put("$,,", RIGHT_SISTER_OF);
        SIMPLE_RELATIONS_MAP.put("$.", IMMEDIATE_LEFT_SISTER_OF);
        SIMPLE_RELATIONS_MAP.put("$,", IMMEDIATE_RIGHT_SISTER_OF);
    }

    private static class UnbrokenCategoryFollows
    extends Relation {
        private static final long serialVersionUID = -7890430001297866437L;
        private final Pattern pattern;
        private final boolean negatedPattern;
        private final boolean basicCat;
        private Function<String, String> basicCatFunction;

        UnbrokenCategoryFollows(String arg, Function<String, String> basicCatFunction) {
            super(",+(" + arg + ')');
            if (arg.startsWith("!")) {
                this.negatedPattern = true;
                arg = arg.substring(1);
            } else {
                this.negatedPattern = false;
            }
            if (arg.startsWith("@")) {
                this.basicCat = true;
                this.basicCatFunction = basicCatFunction;
                arg = arg.substring(1);
            } else {
                this.basicCat = false;
            }
            this.pattern = arg.matches("/.*/") ? Pattern.compile(arg.substring(1, arg.length() - 1)) : (arg.matches("__") ? Pattern.compile("^.*$") : Pattern.compile("^(?:" + arg + ")$"));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return true;
        }

        private boolean pathMatchesNode(Tree node) {
            Matcher m;
            String lab = node.value();
            if (lab == null) {
                return this.negatedPattern;
            }
            if (this.basicCat) {
                lab = this.basicCatFunction.apply(lab);
            }
            return (m = this.pattern.matcher(lab)).find() != this.negatedPattern;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                IdentityHashSet<Tree> nodesToSearch;
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.nodesToSearch = new IdentityHashSet();
                    this.searchStack = new Stack();
                    this.initializeHelper(this.searchStack, t, matcher.getRoot());
                    this.advance();
                }

                private void initializeHelper(Stack<Tree> stack, Tree node, Tree root) {
                    if (node == root) {
                        return;
                    }
                    Tree parent = matcher.getParent(node);
                    int i = parent.indexOf(node);
                    while (i == 0 && parent != root) {
                        node = parent;
                        parent = matcher.getParent(parent);
                        i = parent.indexOf(node);
                    }
                    Tree precedingNode = i > 0 ? parent.children()[i - 1] : null;
                    while (precedingNode != null) {
                        if (!this.nodesToSearch.contains(precedingNode)) {
                            stack.add(precedingNode);
                            this.nodesToSearch.add(precedingNode);
                        }
                        if (UnbrokenCategoryFollows.this.pathMatchesNode(precedingNode)) {
                            this.initializeHelper(stack, precedingNode, root);
                        }
                        if (!precedingNode.isLeaf()) {
                            precedingNode = precedingNode.children()[0];
                            continue;
                        }
                        precedingNode = null;
                    }
                }

                @Override
                void advance() {
                    this.next = this.searchStack.isEmpty() ? null : this.searchStack.pop();
                }
            };
        }
    }

    private static class UnbrokenCategoryPrecedes
    extends Relation {
        private static final long serialVersionUID = 6866888667804306111L;
        private final Pattern pattern;
        private final boolean negatedPattern;
        private final boolean basicCat;
        private Function<String, String> basicCatFunction;

        UnbrokenCategoryPrecedes(String arg, Function<String, String> basicCatFunction) {
            super(".+(" + arg + ')');
            if (arg.startsWith("!")) {
                this.negatedPattern = true;
                arg = arg.substring(1);
            } else {
                this.negatedPattern = false;
            }
            if (arg.startsWith("@")) {
                this.basicCat = true;
                this.basicCatFunction = basicCatFunction;
                arg = arg.substring(1);
            } else {
                this.basicCat = false;
            }
            this.pattern = arg.matches("/.*/") ? Pattern.compile(arg.substring(1, arg.length() - 1)) : (arg.matches("__") ? Pattern.compile("^.*$") : Pattern.compile("^(?:" + arg + ")$"));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return true;
        }

        private boolean pathMatchesNode(Tree node) {
            Matcher m;
            String lab = node.value();
            if (lab == null) {
                return this.negatedPattern;
            }
            if (this.basicCat) {
                lab = this.basicCatFunction.apply(lab);
            }
            return (m = this.pattern.matcher(lab)).find() != this.negatedPattern;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){
                private IdentityHashSet<Tree> nodesToSearch;
                private Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.nodesToSearch = new IdentityHashSet();
                    this.searchStack = new Stack();
                    this.initializeHelper(this.searchStack, t, matcher.getRoot());
                    this.advance();
                }

                private void initializeHelper(Stack<Tree> stack, Tree node, Tree root) {
                    if (node == root) {
                        return;
                    }
                    Tree parent = matcher.getParent(node);
                    int i = parent.indexOf(node);
                    while (i == parent.children().length - 1 && parent != root) {
                        node = parent;
                        parent = matcher.getParent(parent);
                        i = parent.indexOf(node);
                    }
                    Tree followingNode = i + 1 < parent.children().length ? parent.children()[i + 1] : null;
                    while (followingNode != null) {
                        if (!this.nodesToSearch.contains(followingNode)) {
                            stack.add(followingNode);
                            this.nodesToSearch.add(followingNode);
                        }
                        if (UnbrokenCategoryPrecedes.this.pathMatchesNode(followingNode)) {
                            this.initializeHelper(stack, followingNode, root);
                        }
                        if (!followingNode.isLeaf()) {
                            followingNode = followingNode.children()[0];
                            continue;
                        }
                        followingNode = null;
                    }
                }

                @Override
                void advance() {
                    this.next = this.searchStack.isEmpty() ? null : this.searchStack.pop();
                }
            };
        }
    }

    private static class UnbrokenCategoryIsDominatedBy
    extends Relation {
        private static final long serialVersionUID = 2867922828235355129L;
        private final UnbrokenCategoryDominates unbrokenCategoryDominates;

        UnbrokenCategoryIsDominatedBy(String arg, Function<String, String> basicCatFunction) {
            super(">+(" + arg + ')');
            this.unbrokenCategoryDominates = Interner.globalIntern(new UnbrokenCategoryDominates(arg, basicCatFunction));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return this.unbrokenCategoryDominates.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = matcher.getParent(t);
                }

                @Override
                public void advance() {
                    this.next = UnbrokenCategoryIsDominatedBy.this.unbrokenCategoryDominates.pathMatchesNode(this.next) ? matcher.getParent(this.next) : null;
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnbrokenCategoryIsDominatedBy)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnbrokenCategoryIsDominatedBy unbrokenCategoryIsDominatedBy = (UnbrokenCategoryIsDominatedBy)o;
            return this.unbrokenCategoryDominates.equals(unbrokenCategoryIsDominatedBy.unbrokenCategoryDominates);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + this.unbrokenCategoryDominates.hashCode();
            return result;
        }
    }

    private static class UnbrokenCategoryDominates
    extends Relation {
        private static final long serialVersionUID = -4174923168221859262L;
        private final Pattern pattern;
        private final boolean negatedPattern;
        private final boolean basicCat;
        private Function<String, String> basicCatFunction;

        UnbrokenCategoryDominates(String arg, Function<String, String> basicCatFunction) {
            super("<+(" + arg + ')');
            if (arg.startsWith("!")) {
                this.negatedPattern = true;
                arg = arg.substring(1);
            } else {
                this.negatedPattern = false;
            }
            if (arg.startsWith("@")) {
                this.basicCat = true;
                this.basicCatFunction = basicCatFunction;
                arg = arg.substring(1);
            } else {
                this.basicCat = false;
            }
            this.pattern = arg.matches("/.*/") ? Pattern.compile(arg.substring(1, arg.length() - 1)) : (arg.matches("__") ? Pattern.compile("^.*$") : Pattern.compile("^(?:" + arg + ")$"));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            for (Tree kid : t1.children()) {
                if (kid == t2) {
                    return true;
                }
                if (!this.pathMatchesNode(kid) || !this.satisfies(kid, t2, root)) continue;
                return true;
            }
            return false;
        }

        private boolean pathMatchesNode(Tree node) {
            Matcher m;
            String lab = node.value();
            if (lab == null) {
                return this.negatedPattern;
            }
            if (this.basicCat) {
                lab = this.basicCatFunction.apply(lab);
            }
            return (m = this.pattern.matcher(lab)).find() != this.negatedPattern;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){
                Stack<Tree> searchStack;

                @Override
                public void initialize() {
                    this.searchStack = new Stack();
                    for (int i = t.numChildren() - 1; i >= 0; --i) {
                        this.searchStack.push(t.getChild(i));
                    }
                    if (!this.searchStack.isEmpty()) {
                        this.advance();
                    }
                }

                @Override
                void advance() {
                    if (this.searchStack.isEmpty()) {
                        this.next = null;
                    } else {
                        this.next = this.searchStack.pop();
                        if (UnbrokenCategoryDominates.this.pathMatchesNode(this.next)) {
                            for (int i = this.next.numChildren() - 1; i >= 0; --i) {
                                this.searchStack.push(this.next.getChild(i));
                            }
                        }
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnbrokenCategoryDominates)) {
                return false;
            }
            UnbrokenCategoryDominates unbrokenCategoryDominates = (UnbrokenCategoryDominates)o;
            if (this.negatedPattern != unbrokenCategoryDominates.negatedPattern) {
                return false;
            }
            return this.pattern.equals(unbrokenCategoryDominates.pattern);
        }

        @Override
        public int hashCode() {
            int result = this.pattern.hashCode();
            result = 29 * result + (this.negatedPattern ? 1 : 0);
            return result;
        }
    }

    private static class HasIthChild
    extends Relation {
        private static final long serialVersionUID = 3546853729291582806L;
        private final IthChildOf ithChildOf;

        HasIthChild(int i) {
            super('<' + String.valueOf(i));
            this.ithChildOf = Interner.globalIntern(new IthChildOf(i));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return this.ithChildOf.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    int childNum = HasIthChild.this.ithChildOf.childNum;
                    if (t.numChildren() >= Math.abs(childNum)) {
                        this.next = childNum > 0 ? t.getChild(childNum - 1) : t.getChild(t.numChildren() + childNum);
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HasIthChild)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HasIthChild hasIthChild = (HasIthChild)o;
            return !(this.ithChildOf != null ? !this.ithChildOf.equals(hasIthChild.ithChildOf) : hasIthChild.ithChildOf != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + (this.ithChildOf != null ? this.ithChildOf.hashCode() : 0);
            return result;
        }
    }

    private static class IthChildOf
    extends Relation {
        private static final long serialVersionUID = -1463126827537879633L;
        private final int childNum;

        IthChildOf(int i) {
            super('>' + String.valueOf(i));
            if (i == 0) {
                throw new IllegalArgumentException("Error -- no such thing as zeroth child!");
            }
            this.childNum = i;
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            Tree[] kids = t2.children();
            if (kids.length < Math.abs(this.childNum)) {
                return false;
            }
            if (this.childNum > 0 && kids[this.childNum - 1] == t1) {
                return true;
            }
            return this.childNum < 0 && kids[kids.length + this.childNum] == t1;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (t != matcher.getRoot()) {
                        this.next = matcher.getParent(t);
                        if (IthChildOf.this.childNum > 0 && (this.next.numChildren() < IthChildOf.this.childNum || this.next.getChild(IthChildOf.this.childNum - 1) != t) || IthChildOf.this.childNum < 0 && (this.next.numChildren() < -IthChildOf.this.childNum || this.next.getChild(this.next.numChildren() + IthChildOf.this.childNum) != t)) {
                            this.next = null;
                        }
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IthChildOf)) {
                return false;
            }
            IthChildOf ithChildOf = (IthChildOf)o;
            return this.childNum == ithChildOf.childNum;
        }

        @Override
        public int hashCode() {
            return this.childNum;
        }
    }

    private static class ImmediatelyHeadedBy
    extends Relation {
        private static final long serialVersionUID = 5910075663419780905L;
        private final ImmediatelyHeads immediatelyHeads;

        ImmediatelyHeadedBy(HeadFinder hf) {
            super("<#");
            this.immediatelyHeads = Interner.globalIntern(new ImmediatelyHeads(hf));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return this.immediatelyHeads.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (!t.isLeaf()) {
                        this.next = ImmediatelyHeadedBy.this.immediatelyHeads.hf.determineHead(t);
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImmediatelyHeadedBy)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ImmediatelyHeadedBy immediatelyHeadedBy = (ImmediatelyHeadedBy)o;
            return !(this.immediatelyHeads != null ? !this.immediatelyHeads.equals(immediatelyHeadedBy.immediatelyHeads) : immediatelyHeadedBy.immediatelyHeads != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + (this.immediatelyHeads != null ? this.immediatelyHeads.hashCode() : 0);
            return result;
        }
    }

    private static class ImmediatelyHeads
    extends Relation {
        private static final long serialVersionUID = 2085410152913894987L;
        private final HeadFinder hf;

        ImmediatelyHeads(HeadFinder hf) {
            super(">#");
            this.hf = hf;
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return this.hf.determineHead(t2) == t1;
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    if (t != matcher.getRoot()) {
                        this.next = matcher.getParent(t);
                        if (ImmediatelyHeads.this.hf.determineHead(this.next) != t) {
                            this.next = null;
                        }
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ImmediatelyHeads)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ImmediatelyHeads immediatelyHeads = (ImmediatelyHeads)o;
            return this.hf.equals(immediatelyHeads.hf);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + this.hf.hashCode();
            return result;
        }
    }

    private static class HeadedBy
    extends Relation {
        private static final long serialVersionUID = 2825997185749055693L;
        private final Heads heads;

        HeadedBy(HeadFinder hf) {
            super("<<#");
            this.heads = Interner.globalIntern(new Heads(hf));
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            return this.heads.satisfies(t2, t1, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                    this.advance();
                }

                @Override
                public void advance() {
                    this.next = this.next.isLeaf() ? null : ((HeadedBy)HeadedBy.this).heads.hf.determineHead(this.next);
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HeadedBy)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HeadedBy headedBy = (HeadedBy)o;
            return !(this.heads != null ? !this.heads.equals(headedBy.heads) : headedBy.heads != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + (this.heads != null ? this.heads.hashCode() : 0);
            return result;
        }
    }

    private static class Heads
    extends Relation {
        private static final long serialVersionUID = 4681433462932265831L;
        final HeadFinder hf;

        Heads(HeadFinder hf) {
            super(">>#");
            this.hf = hf;
        }

        @Override
        boolean satisfies(Tree t1, Tree t2, Tree root) {
            if (t2.isLeaf()) {
                return false;
            }
            if (t2.isPreTerminal()) {
                return t2.firstChild() == t1;
            }
            Tree head = this.hf.determineHead(t2);
            if (head == t1) {
                return true;
            }
            return this.satisfies(t1, head, root);
        }

        @Override
        Iterator<Tree> searchNodeIterator(final Tree t, final TregexMatcher matcher) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = t;
                    this.advance();
                }

                @Override
                public void advance() {
                    Tree last = this.next;
                    this.next = matcher.getParent(this.next);
                    if (this.next != null && Heads.this.hf.determineHead(this.next) != last) {
                        this.next = null;
                    }
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Heads)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Heads heads = (Heads)o;
            return !(this.hf != null ? !this.hf.equals(heads.hf) : heads.hf != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 29 * result + (this.hf != null ? this.hf.hashCode() : 0);
            return result;
        }
    }

    static abstract class SearchNodeIterator
    implements Iterator<Tree> {
        Tree next;

        public SearchNodeIterator() {
            this.initialize();
        }

        void initialize() {
            this.advance();
        }

        void advance() {
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Tree next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Tree ret = this.next;
            this.advance();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SearchNodeIterator does not support remove().");
        }
    }
}

