/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.AuxiliaryTree;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;

class AdjoinNode
extends TsurgeonPattern {
    private final AuxiliaryTree adjunctionTree;

    public AdjoinNode(AuxiliaryTree t, TsurgeonPattern p) {
        super("adjoin", new TsurgeonPattern[]{p});
        if (t == null || p == null) {
            throw new NullPointerException("AdjoinNode: illegal null argument, t=" + t + ", p=" + p);
        }
        this.adjunctionTree = t;
    }

    protected AuxiliaryTree adjunctionTree() {
        return this.adjunctionTree;
    }

    @Override
    public Tree evaluate(Tree t, TregexMatcher m) {
        Tree targetNode = this.children[0].evaluate(t, m);
        Tree parent = targetNode.parent(t);
        AuxiliaryTree ft = this.adjunctionTree.copy(this);
        ft.foot.setChildren(targetNode.getChildrenAsList());
        if (parent == null) {
            return ft.tree;
        }
        int i = parent.indexOf(targetNode);
        parent.setChild(i, ft.tree);
        return t;
    }

    @Override
    public String toString() {
        return super.toString() + "<-" + this.adjunctionTree.toString();
    }
}

