/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.AdjoinNode;
import edu.stanford.nlp.trees.tregex.tsurgeon.AuxiliaryTree;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;

class AdjoinToFootNode
extends AdjoinNode {
    public AdjoinToFootNode(AuxiliaryTree t, TsurgeonPattern p) {
        super(t, p);
    }

    @Override
    public Tree evaluate(Tree t, TregexMatcher m) {
        Tree targetNode = this.children[0].evaluate(t, m);
        Tree parent = targetNode.parent(t);
        AuxiliaryTree ft = this.adjunctionTree().copy(this);
        Tree parentOfFoot = ft.foot.parent(ft.tree);
        if (parentOfFoot == null) {
            System.err.println("Warning: adjoin to foot for depth-1 auxiliary tree has no effect.");
            return t;
        }
        int i = parentOfFoot.indexOf(ft.foot);
        if (parent == null) {
            parentOfFoot.setChild(i, targetNode);
            return ft.tree;
        }
        int j = parent.indexOf(targetNode);
        parent.setChild(j, ft.tree);
        parentOfFoot.setChild(i, targetNode);
        return t;
    }
}

