/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AuxiliaryTree {
    private final String originalTreeString;
    final Tree tree;
    final Tree foot;
    private final IdentityHashMap<Tree, String> nodesToNames;
    private final Map<String, Tree> namesToNodes;
    private static final String footNodeCharacter = "@";
    private static final Pattern footNodeLabelPattern = Pattern.compile("^(.*)@$");
    private static final Pattern escapedFootNodeCharacter = Pattern.compile("\\@");
    static final Pattern namePattern = Pattern.compile("^((?:[^\\\\]*)|(?:(?:.*[^\\\\])?)(?:\\\\\\\\)*)=([^=]+)$");

    public AuxiliaryTree(Tree tree, boolean mustHaveFoot) {
        this.originalTreeString = tree.toString();
        this.tree = tree;
        this.foot = AuxiliaryTree.findFootNode(tree);
        if (this.foot == null && mustHaveFoot) {
            throw new RuntimeException("Error -- no foot node found for " + this.originalTreeString);
        }
        this.namesToNodes = new HashMap<String, Tree>();
        this.nodesToNames = new IdentityHashMap();
        this.initializeNamesNodesMaps(tree);
    }

    private AuxiliaryTree(Tree tree, Tree foot, Map<String, Tree> namesToNodes, String originalTreeString) {
        this.originalTreeString = originalTreeString;
        this.tree = tree;
        this.foot = foot;
        this.namesToNodes = namesToNodes;
        this.nodesToNames = null;
    }

    public Map<String, Tree> namesToNodes() {
        return this.namesToNodes;
    }

    public String toString() {
        return this.originalTreeString;
    }

    public AuxiliaryTree copy(TsurgeonPattern p) {
        HashMap<String, Tree> newNamesToNodes = new HashMap<String, Tree>();
        Pair<Tree, Tree> result = this.copyHelper(this.tree, newNamesToNodes);
        p.root.newNodeNames.putAll(newNamesToNodes);
        return new AuxiliaryTree(result.first(), result.second(), newNamesToNodes, this.originalTreeString);
    }

    private Pair<Tree, Tree> copyHelper(Tree node, Map<String, Tree> newNamesToNodes) {
        Tree clone;
        Tree newFoot = null;
        if (node.isLeaf()) {
            if (node == this.foot) {
                newFoot = clone = node.treeFactory().newTreeNode(node.label(), new ArrayList<Tree>(0));
            } else {
                clone = node.treeFactory().newLeaf(node.label().labelFactory().newLabel(node.label()));
            }
        } else {
            ArrayList<Tree> newChildren = new ArrayList<Tree>(node.children().length);
            for (Tree child : node.children()) {
                Pair<Tree, Tree> newChild = this.copyHelper(child, newNamesToNodes);
                newChildren.add(newChild.first());
                if (newChild.second() == null) continue;
                if (newFoot != null) {
                    System.err.println("Error -- two feet found when copying auxiliary tree " + this.tree.toString() + "; using last foot found.");
                }
                newFoot = newChild.second();
            }
            clone = node.treeFactory().newTreeNode(node.label().labelFactory().newLabel(node.label()), newChildren);
            if (this.nodesToNames.containsKey(node)) {
                newNamesToNodes.put(this.nodesToNames.get(node), clone);
            }
        }
        return new Pair<Tree, Tree>(clone, newFoot);
    }

    private static Tree findFootNode(Tree t) {
        Tree footNode;
        Tree result = footNode = AuxiliaryTree.findFootNodeHelper(t);
        if (footNode != null) {
            Tree parent = footNode.parent(t);
            int i = parent.indexOf(footNode);
            Tree newFootNode = footNode.treeFactory().newTreeNode(footNode.label(), new ArrayList<Tree>());
            parent.setChild(i, newFootNode);
            result = newFootNode;
        }
        return result;
    }

    private static Tree findFootNodeHelper(Tree t) {
        Tree foundDtr = null;
        if (t.isLeaf()) {
            Matcher m = footNodeLabelPattern.matcher(t.label().value());
            if (m.matches()) {
                t.label().setValue(m.group(1));
                return t;
            }
            return null;
        }
        for (Tree child : t.children()) {
            Tree thisFoundDtr = AuxiliaryTree.findFootNodeHelper(child);
            if (thisFoundDtr == null) continue;
            if (foundDtr != null) {
                throw new RuntimeException("Error -- two foot nodes in subtree" + t.toString());
            }
            foundDtr = thisFoundDtr;
        }
        Matcher m = escapedFootNodeCharacter.matcher(t.label().value());
        t.label().setValue(m.replaceAll(footNodeCharacter));
        return foundDtr;
    }

    private void initializeNamesNodesMaps(Tree t) {
        for (Tree node : t.subTreeList()) {
            Matcher m = namePattern.matcher(node.label().value());
            if (m.find()) {
                this.namesToNodes.put(m.group(1), node);
                this.nodesToNames.put(node, m.group(1));
                node.label().setValue(m.group(1));
            }
            node.label().setValue(AuxiliaryTree.unescape(node.label().value()));
        }
    }

    static String unescape(String input) {
        return input.replaceAll("\\\\(.)", "$1");
    }
}

