/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.logging.Color;
import edu.stanford.nlp.util.logging.LogRecordHandler;
import edu.stanford.nlp.util.logging.OutputHandler;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.RepeatedRecordHandler;
import edu.stanford.nlp.util.logging.Style;
import edu.stanford.nlp.util.logging.VisibilityHandler;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RedwoodConfiguration {
    private static Pattern consoleColor = Pattern.compile("^log\\.console\\.(.*?)Color$");
    private static Pattern fileColor = Pattern.compile("^log\\.file\\.(.*?)Color$");
    private static Pattern consoleStyle = Pattern.compile("^log\\.console\\.(.*?)Style$");
    private static Pattern fileStyle = Pattern.compile("^log\\.file\\.(.*?)Style$");
    private LinkedList<Runnable> tasks = new LinkedList();

    protected RedwoodConfiguration() {
    }

    public void apply() {
        for (Runnable task : this.tasks) {
            task.run();
        }
    }

    public RedwoodConfiguration clear() {
        this.tasks = new LinkedList();
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.clearHandlers();
                Redwood.restoreSystemStreams();
                Redwood.clearLoggingClasses();
            }
        });
        return this;
    }

    public RedwoodConfiguration stdout() {
        VisibilityHandler visibility = new VisibilityHandler();
        Redwood.ConsoleHandler console = Redwood.ConsoleHandler.out();
        return this.rootHandler(visibility).handler(visibility, console);
    }

    public RedwoodConfiguration stderr() {
        VisibilityHandler visibility = new VisibilityHandler();
        Redwood.ConsoleHandler console = Redwood.ConsoleHandler.err();
        return this.rootHandler(visibility).handler(visibility, console);
    }

    public RedwoodConfiguration console() {
        return this.stdout();
    }

    public RedwoodConfiguration file(String file) {
        VisibilityHandler visibility = new VisibilityHandler();
        Redwood.FileHandler console = new Redwood.FileHandler(file);
        return this.rootHandler(visibility).handler(visibility, console);
    }

    public RedwoodConfiguration rootHandler(final LogRecordHandler handler) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.appendHandler(handler);
            }
        });
        Redwood.appendHandler(handler);
        return this;
    }

    public RedwoodConfiguration handler(final LogRecordHandler parent, final LogRecordHandler child) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.appendHandler(parent, child);
            }
        });
        return this;
    }

    public RedwoodConfiguration splice(final LogRecordHandler parent, final LogRecordHandler toAdd, final LogRecordHandler grandchild) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.spliceHandler(parent, toAdd, grandchild);
            }
        });
        return this;
    }

    public RedwoodConfiguration loggingClass(final String classToIgnoreInTraces) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.addLoggingClass(classToIgnoreInTraces);
            }
        });
        return this;
    }

    public RedwoodConfiguration loggingClass(final Class<?> classToIgnoreInTraces) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.addLoggingClass(classToIgnoreInTraces.getName());
            }
        });
        return this;
    }

    public RedwoodConfiguration collapseApproximate() {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.spliceHandler(VisibilityHandler.class, (LogRecordHandler)new RepeatedRecordHandler(RepeatedRecordHandler.APPROXIMATE), OutputHandler.class);
            }
        });
        return this;
    }

    public RedwoodConfiguration collapseExact() {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.spliceHandler(VisibilityHandler.class, (LogRecordHandler)new RepeatedRecordHandler(RepeatedRecordHandler.EXACT), OutputHandler.class);
            }
        });
        return this;
    }

    public RedwoodConfiguration collapseNone() {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.removeHandler(RepeatedRecordHandler.class);
            }
        });
        return this;
    }

    public RedwoodConfiguration captureStdout() {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.captureSystemStreams(true, false);
            }
        });
        return this;
    }

    public RedwoodConfiguration captureStderr() {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.captureSystemStreams(false, true);
            }
        });
        return this;
    }

    public RedwoodConfiguration captureStreams() {
        return this.captureStdout().captureStderr();
    }

    public RedwoodConfiguration neatExit() {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        Redwood.stop();
                    }
                });
            }
        });
        return this;
    }

    public RedwoodConfiguration printChannels(final int width) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.Util.printChannels(width);
            }
        });
        return this;
    }

    public RedwoodConfiguration hideChannels(final Object[] channels) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.hideChannels(channels);
            }
        });
        return this;
    }

    public RedwoodConfiguration showOnlyChannels(final Object[] channels) {
        this.tasks.add(new Runnable(){

            @Override
            public void run() {
                Redwood.showOnlyChannels(channels);
            }
        });
        return this;
    }

    public static RedwoodConfiguration empty() {
        return new RedwoodConfiguration().clear();
    }

    public static RedwoodConfiguration standard() {
        return new RedwoodConfiguration().clear().console().loggingClass(Redwood.class);
    }

    public static RedwoodConfiguration current() {
        return new RedwoodConfiguration();
    }

    private static String get(Properties p, String key, String defaultValue, Set<String> used) {
        String rtn = p.getProperty(key, defaultValue);
        used.add(key);
        return rtn;
    }

    public static RedwoodConfiguration parse(Properties props) {
        HashSet<String> used = new HashSet<String>();
        Redwood.ConsoleHandler console = RedwoodConfiguration.get(props, "log.toStderr", "false", used).equalsIgnoreCase("true") ? Redwood.ConsoleHandler.err() : Redwood.ConsoleHandler.out();
        VisibilityHandler visibility = new VisibilityHandler();
        RepeatedRecordHandler repeat = null;
        RedwoodConfiguration config = new RedwoodConfiguration().clear().rootHandler(visibility);
        String collapseSetting = RedwoodConfiguration.get(props, "log.collapse", "none", used);
        if (collapseSetting.equalsIgnoreCase("exact")) {
            repeat = new RepeatedRecordHandler(RepeatedRecordHandler.EXACT);
            config = config.handler(visibility, repeat);
        } else if (collapseSetting.equalsIgnoreCase("approximate")) {
            repeat = new RepeatedRecordHandler(RepeatedRecordHandler.APPROXIMATE);
            config = config.handler(visibility, repeat);
        } else if (!collapseSetting.equalsIgnoreCase("none")) {
            throw new IllegalArgumentException("Unknown collapse type: " + collapseSetting);
        }
        config.handler(repeat == null ? visibility : repeat, console);
        console.trackColor = Color.valueOf(RedwoodConfiguration.get(props, "log.console.trackColor", "NONE", used).toUpperCase());
        console.trackStyle = Style.valueOf(RedwoodConfiguration.get(props, "log.console.trackStyle", "NONE", used).toUpperCase());
        for (Object propAsObj : props.keySet()) {
            String channel;
            String prop = propAsObj.toString();
            Matcher m = consoleColor.matcher(prop);
            if (m.find()) {
                channel = m.group(1);
                console.colorChannel(channel, Color.valueOf(RedwoodConfiguration.get(props, prop, "NONE", used)));
            }
            if (!(m = consoleStyle.matcher(prop)).find()) continue;
            channel = m.group(1);
            console.styleChannel(channel, Style.valueOf(RedwoodConfiguration.get(props, prop, "NONE", used)));
        }
        console.setColorChannels(Boolean.parseBoolean(RedwoodConfiguration.get(props, "log.console.colorChannels", "false", used)));
        String logFilename = RedwoodConfiguration.get(props, "log.file", null, used);
        if (logFilename != null) {
            Redwood.FileHandler file = new Redwood.FileHandler(logFilename);
            config.handler(repeat == null ? visibility : repeat, file);
            file.trackColor = Color.valueOf(RedwoodConfiguration.get(props, "log.file.trackColor", "NONE", used).toUpperCase());
            file.trackStyle = Style.valueOf(RedwoodConfiguration.get(props, "log.file.trackStyle", "NONE", used).toUpperCase());
            for (Object propAsObj : props.keySet()) {
                String channel;
                String prop = propAsObj.toString();
                Matcher m = fileColor.matcher(prop);
                if (m.find()) {
                    channel = m.group(1);
                    file.colorChannel(channel, Color.valueOf(RedwoodConfiguration.get(props, prop, "NONE", used)));
                }
                if (!(m = fileStyle.matcher(prop)).find()) continue;
                channel = m.group(1);
                file.styleChannel(channel, Style.valueOf(RedwoodConfiguration.get(props, prop, "NONE", used)));
            }
            file.setColorChannels(Boolean.parseBoolean(RedwoodConfiguration.get(props, "log.file.colorChannels", "false", used)));
        }
        if (RedwoodConfiguration.get(props, "log.captureStreams", "false", used).equalsIgnoreCase("true")) {
            config = config.captureStreams();
        }
        if (RedwoodConfiguration.get(props, "log.captureStdout", "false", used).equalsIgnoreCase("true")) {
            config = config.captureStdout();
        }
        if (RedwoodConfiguration.get(props, "log.captureStderr", "false", used).equalsIgnoreCase("true")) {
            config = config.captureStderr();
        }
        if (RedwoodConfiguration.get(props, "log.neatExit", "false", used).equalsIgnoreCase("true")) {
            config = config.neatExit();
        }
        String channelsToShow = RedwoodConfiguration.get(props, "log.showOnlyChannels", null, used);
        String channelsToHide = RedwoodConfiguration.get(props, "log.hideChannels", null, used);
        if (channelsToShow != null && channelsToHide != null) {
            throw new IllegalArgumentException("Can't specify both log.showOnlyChannels and log.hideChannels");
        }
        if (channelsToShow != null) {
            config = config.showOnlyChannels(channelsToShow.split(","));
        } else if (channelsToHide != null) {
            config = config.hideChannels(channelsToHide.split(","));
        }
        for (Object propAsObj : props.keySet()) {
            String prop = propAsObj.toString();
            if (!prop.startsWith("log.") || used.contains(prop)) continue;
            throw new IllegalArgumentException("Could not find Redwood log property: " + prop);
        }
        return config;
    }

    public static void apply(Properties props) {
        RedwoodConfiguration.parse(props).apply();
    }
}

