from django.contrib import admin

from sparky.models import *

class EntryAdmin(admin.ModelAdmin):
    list_display = ('msgid')
    search_fields = ('msgid')
    ordering = ('msgid',)

# Users shouldn't edit entries in the admin. (md5 checksum should be kept in sync with msgid)
# admin.site.register(Entry, EntryAdmin)

class ApplicationAdmin(admin.ModelAdmin):
    list_display = ('name', 'description')
    search_fields = ('name', 'description')

admin.site.register(Application, ApplicationAdmin)


class ConflictAdmin(admin.ModelAdmin):
    list_display = ('msgid', 'language', 'existing_string', 'new_string', 'created')
    search_fields = ('msgid', 'language', 'existing_string', 'new_string', 'created')
    ordering = ('-created',)

admin.site.register(Conflict, ConflictAdmin)
