from django import forms
from django.utils.translation import ugettext_lazy as _

from sparky.models import Application


class SearchForm(forms.Form):
    q = forms.CharField(label=_('Search'), required=False)
    show_translated = forms.BooleanField(label=_('Show translated'), required=False)
    original_only = forms.BooleanField(label=_('Original only'), required=False)
    show_ignored = forms.BooleanField(label=_('Show ignored'), required=False)
    filter_application = forms.ModelMultipleChoiceField(queryset=Application.objects.all(), label=_('Filter application'), required=False)

    def __init__(self, *args, **kwargs):
        self._project = kwargs.pop('project', None)

        super(SearchForm, self).__init__(*args, **kwargs)

        if self._project:
            self.fields['filter_application'].queryset = Application.objects.filter(projectapplication__project=self._project)
