from django.conf import settings
from django.conf.urls.defaults import patterns, url, include
from django.contrib import admin
from django.contrib.auth.decorators import permission_required
from django.views.generic.simple import redirect_to

from sparky.views import *

admin.autodiscover()

urlpatterns = patterns('',
    # Authentication
    url(r'^accounts/login/$', login, name="login"),
    url(r'^accounts/logout/$', logout, name="logout"),

    # Views
    url(r'^$', redirect_to, {'url': '/projects/'}),
    url(r'^conflicts/$', conflicts, name='conflicts'),
    url(r'^upload-po/$', upload_po, name='upload_po'),
    url(r'^upload-entry/$', upload_entry, name='upload_entry'),
    url(r'^complete-po/$', complete_po, name='complete_po'),
    url(r'^download-po/$', download_po, name='download_po'),
    url(r'^ajax/save-translation/$', ajax_save_translations, name='ajax_save_translations'),
    url(r'^ajax/save-fuzzy/$', ajax_save_fuzzy, name='ajax_save_fuzzy'),
    url(r'^ajax/save-ignore/$', ajax_save_ignore, name='ajax_save_ignore'),
    url(r'^ajax/solve_conflict/(?P<conflict_id>\d+)/$', solve_conflict, name='solve_conflict'),
    url(r'^download-backup/$', download_backup, name='download_backup'),
    url(r'^download-overview/$', download_overview, name='download_overview'),
    url(r'^projects/', include('sparky.project.urls')),

    # Admin
    url(r'^admin/doc/', include('django.contrib.admindocs.urls')),
    url(r'^admin/', include(admin.site.urls)),
)

# if not settings.MEDIA_URL.startswith('http://') and settings.DEBUG:
#     urlpatterns += patterns('',
#         url(r'^%s(?P<path>.*)$' % (settings.MEDIA_URL[1:], ), 'django.views.static.serve', {'document_root' : settings.MEDIA_ROOT, 'show_indexes' : True})
#     )

if settings.DEBUG:
    from django.contrib.staticfiles.urls import staticfiles_urlpatterns
    urlpatterns += staticfiles_urlpatterns()
