# -*- coding: utf-8 -*-
"""
    sphinxjp-gettext-helper
    ~~~~~~~~~~~~~~~~~~~~~~~~

    This package is a namespace package that contains all extensions
    distributed in the ``sphinxjp-gettext-helper`` distribution.

    :copyright: Copyright 2011 by Takeshi Komiya <i.tkomiya@gmail.com>
    :license: BSD, see LICENSE for details.
"""

import os
import sys
import re
from optparse import OptionParser


def parse_option():
    p = OptionParser()
    p.add_option('-b', '--build', action='store_true',
                 help='build message catalogs')
    p.add_option('-c', '--config', default="conf.py",
                 help='read configurations from FILE', metavar='FILE')
    p.add_option('-l', '--language',
                 help='target language')
    p.add_option('-p', '--potdir',
                 help='pot files directory which is generated by sphinx')
    p.add_option('-u', '--update', action='store_true',
                 help='update message catalogs')
    options, args = p.parse_args()

    if len(args) > 0:
        p.print_help()
        sys.exit(0)

    if not options.build and not options.update:
        msg = "Specify --build or --update option"
        raise RuntimeError(msg)

    if not options.potdir:
        msg = "Specify --potdir option"
        raise RuntimeError(msg)

    if not os.path.isfile(options.config):
        msg = "config file is not found: %s" % options.config
        raise RuntimeError(msg)

    config = read_config(options.config)
    if not config.has_key('language') or not config.has_key('locale_dirs'):
        msg = "language and locale_dirs was not defined: %s" % options.config
        raise RuntimeError(msg)

    options.locale_dir = os.path.join(config['locale_dirs'][0],
                                      options.language, 'LC_MESSAGES')

    if options.language is None:
        options.language = config['language']

    return options, args


def read_config(path):
    olddir = os.getcwd()
    try:
        os.chdir(os.path.dirname(path) or ".")
        execfile(path)
    finally:
        os.chdir(olddir)

    return locals()


def do_update(options):
    for file in os.listdir(options.potdir):
        file = os.path.join(options.potdir, file)

        if re.search('\.pot$', file):
            basename = os.path.basename(file)[:-1]
            pofile = os.path.join(options.locale_dir, basename)

            if os.path.isfile(pofile):
                cmd = "msgmerge -U %s %s" % (pofile, file)
            else:
                cmd = "msginit --locale=%s --input=%s --output=%s" % \
                      (options.language, file, pofile)

            os.system(cmd)


def do_build(options):
    for file in os.listdir(options.locale_dir):
        file = os.path.join(options.locale_dir, file)

        if re.search('\.po$', file):
            mofile = file[:-2] + "mo"

            cmd = "msgfmt %s -o %s" % (file, mofile)
            os.system(cmd)


def main():
    try:
        options, args = parse_option()
    except RuntimeError, e:
        sys.stderr.write("ERROR: %s\n" % e)
        return

    if not os.path.exists(options.locale_dir):
        os.makedirs(options.locale_dir)

    if options.update:
        do_update(options)

    if options.build:
        do_build(options)
