import unittest
from importlib import import_module
component = import_module('sphinx_settings.settings')


class SettingsTest(unittest.TestCase):

    # Actions

    def setUp(self):
        self.Settings = self.make_mock_settings_class()
        self.settings = self.Settings()

    # Helpers

    def make_mock_settings_class(self):
        class MockSettings(component.Settings):
            # Public
            author = 'author'
            master_doc = 'master_doc'
            project = 'project'
            version = 'version'
        return MockSettings

    # Tests

    def test___getattr__(self):
        self.assertEqual(self.settings.author, 'author')
        self.assertRaises(AttributeError, getattr, self.settings, 'no_attr')

    def test_release(self):
        self.assertEqual(self.settings.release, 'version')

    def test_latex_documents(self):
        self.assertEqual(self.settings.latex_documents,
            [('master_doc',
              'project.tex',
              'project Documentation',
              'author',
              'manual')])

    def test_man_pages(self):
        self.assertEqual(self.settings.man_pages,
            [('master_doc',
              'project',
              'project Documentation',
              ['author'],
              1)])

    def test_texinfo_documents(self):
        self.assertEqual(self.settings.texinfo_documents,
            [('master_doc',
              'project',
              'project Documentation',
              'author',
              'project',
              'One line description of project.',
              'Miscellaneous')])

    def test_autodoc_process_docstring(self):
        self.lines = ['doc']
        self.result = self.settings.autodoc_process_docstring(
            'app', 'what', 'name', 'obj', 'options', self.lines)
        self.assertEqual(self.lines, ['doc'])

    def test_autodoc_process_docstring_with_header(self):
        self.lines = ['Returns', '-------']
        self.result = self.settings.autodoc_process_docstring(
            'app', 'what', 'name', 'obj', 'options', self.lines)
        self.assertEqual(self.lines, ['**Returns**', ''])

    def test_autodoc_skip_member(self):
        self.settings.autodoc_skip_members = ['name']
        self.result = self.settings.autodoc_skip_member(
            'app', 'what', 'name', 'obj', False, 'options')
        self.assertTrue(self.result)

    def test_autodoc_skip_member_not_match(self):
        self.result = self.settings.autodoc_skip_member(
            'app', 'what', 'name', 'obj', False, 'options')
        self.assertFalse(self.result)
