from sugarbowl import Function


class connect(Function):
    """Decorate method to be connected to a sphinx event.

    Parameters
    ----------
    event: str
        Sphinx event.
    """

    # Public

    MARKER = '_sphinx_settings_connect'
    protocol = Function.DECORATOR

    def __init__(self, event):
        self.__event = event

    def __call__(self, function):
        setattr(function, self.MARKER, self)
        return function

    def invoke(self, function, app):
        app.connect(self.__event, function)
