# Block: caution
# TO MAKE CHANGES USE [meta] DIRECTORY.

# Block: data_files
import os
data_files = []
if data_files:
    try:
        if os.geteuid() != 0:
            data_files.clear()
    except Exception:
        pass

# Block: long_description
from glob import iglob
long_description = 'Class-based settings for Sphinx.'
for filepath in iglob('README.*'):
    with open(filepath) as file:
        long_description = file.read()
    break     

# Block: packages
from setuptools import find_packages
packages = find_packages(os.path.dirname(__file__) or '.', exclude=['tests*'])

# Block: setup
from setuptools import setup
setup(
    author='roll',
    author_email='roll@respect31.com',
    classifiers=[],       
    description='Class-based settings for Sphinx.',
    data_files=data_files,
    download_url='https://github.com/respect31/sphinx-settings/tarball/0.1.1',
    entry_points={},
    license='MIT License',
    long_description=long_description,
    maintainer='roll',
    maintainer_email='roll@respect31.com',
    name='sphinx-settings',
    include_package_data=True,
    install_requires=['sphinx', 'sugarbowl'], 
    packages=packages,
    platforms=['Unix'],
    url='https://github.com/respect31/sphinx-settings',
    tests_require=['nose', 'coverage'],
    test_suite='nose.collector',
    version='0.1.1')
