from sugarbowl import Function


class setup(Function):
    """Decorate method to be added to sphinx setup.
    """

    # Public

    MARKER = '_sphinx_settings_setup'
    protocol = Function.FUNCTION

    def __call__(self, function):
        setattr(function, self.MARKER, self)
        return function

    def invoke(self, function, app):
        function(app)
