import os, sys
from setuptools import setup


long_description = """\
The sphinx document processor generates HTML that uses more advanced syntax
than the HtmlHelp browser in wxPython and wxWidgets can render.  This program
uses the htmlhelp files generated by sphinx as input and attempts to remove
elements that confuse the wxHtmlHelp system while adding or modifying elements
in an attempt to allow the wxHtmlHelp to render the HTML as closely as
possible to the HTML as viewed by a modern browser.

This package provides a script ``sphinx-wxoptimize`` that is designed to
be integrated into your ``make htmlhelp`` target that will automatically
reprocess the sphinx-generated htmlhelp files and convert them to be better
rendered in the wxPython or wxWidgets wxHtmlHelpController.

Features
========

Currently converts the following to be better rendered in wxHtmlHelpController:

* fixes anchor links
* removes extra linebreaks caused by div tags
* adds a line break after center-aligned images
* fixes left margin issues of mulitple paragraphs in definition lists 
* removes unnecessary CSS and JavaScript
* removes the search link from the index page

Example
=======

For an example of the output of ``sphinx-wxoptimize``, visit the
`Peppy User Manual`__.

__ http://peppy.flipturn.org/manual/index.html


Automatic Integration with Sphinx
=================================

In your sphinx Makefile, change the htmlhelp target from::

    htmlhelp:
            $(SPHINXBUILD) -b htmlhelp $(ALLSPHINXOPTS) $(BUILDDIR)/htmlhelp

to::

    htmlhelp:
            $(SPHINXBUILD) -b htmlhelp $(ALLSPHINXOPTS) $(BUILDDIR)/htmlhelp
            sphinx-wxoptimize $(BUILDDIR)/htmlhelp


Installation
============

Installation is through the usual python packaging commands, either by
downloading the source archive and installing manually::

    python setup.py install

or using easy_install::

    easy_install sphinx-wxoptimize

Using easy_install will automatically install the prerequisite BeautifulSoup__
library.

__ http://pypi.python.org/pypi/BeautifulSoup

Development
===========

Please use the `Google Code`__ site to report any bugs, add any feature
requests, or check out the subversion source code repository.

__ http://code.google.com/p/sphinx-wxoptimize/


ChangeLog
=========

1.2
---

* Fixed bug in single paragraph definition lists including inline markup
  (italics, bold, etc.)

1.1
---

* Now removes unnecessary CSS and JavaScript files from _static directory to
  reduce the size of the distributed HtmlHelp.  The wxHtmlHelpController can't
  use the CSS and JavaScript anyway, so there's no need to include it.

1.0
---

* Initial release

"""



setup(name = "sphinx_wxoptimize",
      version = "1.2",
      description = "Convert sphinx-generated htmlhelp files into versions optimized for reading using the wxHtmlHelp browser",
      long_description = long_description,
      keywords = "sphinx, htmlhelp, python, wxwidgets, wxpython, documentation",
      license = "GPL",
      author = "Rob McMullen",
      author_email = "robm@users.sourceforge.net",
      url = "http://pypi.python.org/pypi/sphinx-wxoptimize/",
      scripts = ['sphinx-wxoptimize'],
      
      platforms = 'any',
      classifiers=[
          'Development Status :: 5 - Production/Stable',
          'Intended Audience :: Developers',
          'License :: OSI Approved :: GNU General Public License (GPL)',
          'Programming Language :: Python',
          'Operating System :: OS Independent',
          'Topic :: Software Development :: Documentation',
          'Topic :: Text Processing :: Markup :: HTML',
          ],
      install_requires = ['BeautifulSoup>=3.0'],
      zip_safe = True,
      )
